/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.factory;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.github.manusant.ss.conf.IgnoreSpec;
import io.github.manusant.ss.model.Model;
import io.github.manusant.ss.model.ModelImpl;
import io.github.manusant.ss.model.properties.ArrayProperty;
import io.github.manusant.ss.model.properties.BooleanProperty;
import io.github.manusant.ss.model.properties.ByteArrayProperty;
import io.github.manusant.ss.model.properties.DateProperty;
import io.github.manusant.ss.model.properties.DecimalProperty;
import io.github.manusant.ss.model.properties.DoubleProperty;
import io.github.manusant.ss.model.properties.FileProperty;
import io.github.manusant.ss.model.properties.FloatProperty;
import io.github.manusant.ss.model.properties.IntegerProperty;
import io.github.manusant.ss.model.properties.LongProperty;
import io.github.manusant.ss.model.properties.MapProperty;
import io.github.manusant.ss.model.properties.ObjectProperty;
import io.github.manusant.ss.model.properties.Property;
import io.github.manusant.ss.model.properties.RefProperty;
import io.github.manusant.ss.model.properties.StringProperty;
import io.github.manusant.ss.model.properties.UUIDProperty;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefinitionsFactory.class);
    public static IgnoreSpec ignoreSpec;

    public static Map<String, Model> create(Class clazz) {
        HashMap<Field, Map<String, Model>> hashMap = new HashMap<Field, Map<String, Model>>();
        return DefinitionsFactory.create(clazz, hashMap);
    }

    private static Map<String, Model> create(Class clazz, Map<Field, Map<String, Model>> map) {
        HashMap<String, Model> hashMap = new HashMap<String, Model>();
        if (DefinitionsFactory.isObject(clazz)) {
            ModelImpl modelImpl = new ModelImpl();
            modelImpl.setType("object");
            hashMap.put(clazz.getSimpleName(), modelImpl);
            Map<String, Model> map2 = DefinitionsFactory.parseProperties(modelImpl, clazz.getDeclaredFields(), map);
            hashMap.putAll(map2);
        }
        return hashMap;
    }

    private static Map<String, Model> parseProperties(ModelImpl modelImpl, Field[] fieldArray, Map<Field, Map<String, Model>> map) {
        HashMap<String, Model> hashMap = new HashMap<String, Model>();
        for (Field field : fieldArray) {
            Object object;
            if (ignoreSpec != null && (ignoreSpec.ignored(field) || ignoreSpec.ignoreAnnotated(field)) || !DefinitionsFactory.isViable(field)) continue;
            Property property = DefinitionsFactory.createProperty(field, field.getType());
            modelImpl.addProperty(field.getName(), property);
            if (DefinitionsFactory.isRef(field.getType())) {
                object = DefinitionsFactory.lookupDefinitions(map, field, field.getType());
                hashMap.putAll((Map<String, Model>)object);
                continue;
            }
            if (!field.getType().isArray() && !Collection.class.isAssignableFrom(field.getType()) || !DefinitionsFactory.isRef(object = DefinitionsFactory.getCollectionType(field))) continue;
            Map<String, Model> map2 = DefinitionsFactory.lookupDefinitions(map, field, (Class)object);
            hashMap.putAll(map2);
        }
        return hashMap;
    }

    private static Map<String, Model> lookupDefinitions(Map<Field, Map<String, Model>> map, Field field, Class clazz) {
        Map<String, Model> map2 = map.get(field);
        if (map2 == null) {
            map.put(field, new HashMap());
            map2 = DefinitionsFactory.create(clazz, map);
            map.put(field, map2);
        }
        return map2;
    }

    private static boolean isViable(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    public static Property createProperty(Field field, Class<?> clazz) {
        if (clazz.isEnum()) {
            StringProperty stringProperty = new StringProperty();
            stringProperty._enum(Stream.of(clazz.getEnumConstants()).map(object -> ((Enum)object).name()).collect(Collectors.toList()));
            return stringProperty;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return new BooleanProperty();
        }
        if (clazz == byte[].class) {
            return new ByteArrayProperty();
        }
        if (clazz.equals(java.util.Date.class) || clazz.equals(Date.class)) {
            return new DateProperty();
        }
        if (clazz.equals(Number.class)) {
            return new DecimalProperty();
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return new DoubleProperty();
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return new FloatProperty();
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return new IntegerProperty();
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return new LongProperty();
        }
        if (clazz.equals(String.class)) {
            return new StringProperty();
        }
        if (clazz.equals(UUID.class)) {
            return new UUIDProperty();
        }
        if (clazz.equals(Map.class)) {
            return new MapProperty();
        }
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
            ArrayProperty arrayProperty = new ArrayProperty();
            arrayProperty.setItems(DefinitionsFactory.getCollectionProperty(field));
            return arrayProperty;
        }
        if (File.class.isAssignableFrom(clazz)) {
            return new FileProperty();
        }
        RefProperty refProperty = new RefProperty();
        refProperty.set$ref("#/definitions/" + clazz.getSimpleName());
        return refProperty;
    }

    public static Property createProperty(String string2, JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case BOOLEAN: {
                BooleanProperty booleanProperty = new BooleanProperty();
                if (string2 != null) {
                    booleanProperty.setName(string2);
                }
                return booleanProperty;
            }
            case NUMBER: {
                IntegerProperty integerProperty = new IntegerProperty();
                if (string2 != null) {
                    integerProperty.setName(string2);
                }
                return integerProperty;
            }
            case STRING: {
                StringProperty stringProperty = new StringProperty();
                if (string2 != null) {
                    stringProperty.setName(string2);
                }
                return stringProperty;
            }
            case ARRAY: {
                ArrayProperty arrayProperty = new ArrayProperty();
                if (string2 != null) {
                    arrayProperty.setName(string2);
                }
                Iterator iterator = ((ArrayNode)jsonNode).iterator();
                Property property2 = null;
                while (iterator.hasNext()) {
                    Property property3;
                    if (property2 == null) {
                        property2 = DefinitionsFactory.createProperty(null, (JsonNode)iterator.next());
                        continue;
                    }
                    if (!(property2 instanceof ObjectProperty) || !((property3 = DefinitionsFactory.createProperty(null, (JsonNode)iterator.next())) instanceof ObjectProperty)) break;
                    ObjectProperty objectProperty = (ObjectProperty)property3;
                    ObjectProperty objectProperty2 = (ObjectProperty)property2;
                    objectProperty.getProperties().forEach((string, property) -> objectProperty2.property((String)string, (Property)property));
                }
                arrayProperty.setItems(property2);
                return arrayProperty;
            }
            case OBJECT: {
                ObjectProperty objectProperty = new ObjectProperty();
                if (string2 != null) {
                    objectProperty.setName(string2);
                }
                Iterator iterator = jsonNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String string3 = ((String)entry.getKey()).trim();
                    if (string3 == null || string3.isEmpty()) continue;
                    Property property4 = DefinitionsFactory.createProperty(string3, (JsonNode)entry.getValue());
                    objectProperty.property(string3, property4);
                }
                return objectProperty;
            }
        }
        return null;
    }

    private static boolean isRef(Class<?> clazz) {
        return !clazz.isEnum() && !clazz.equals(Boolean.TYPE) && !clazz.equals(Boolean.class) && clazz != byte[].class && !clazz.equals(java.util.Date.class) && !clazz.equals(Date.class) && !clazz.equals(Number.class) && !clazz.equals(Double.class) && !clazz.equals(Double.TYPE) && !clazz.equals(Float.class) && !clazz.equals(Float.TYPE) && !clazz.equals(Integer.class) && !clazz.equals(Integer.TYPE) && !clazz.equals(Long.class) && !clazz.equals(Long.TYPE) && !clazz.equals(String.class) && !clazz.equals(UUID.class) && !clazz.isArray() && !clazz.equals(Object.class) && !Collection.class.isAssignableFrom(clazz) && !File.class.isAssignableFrom(clazz) && !clazz.getCanonicalName().contains("java");
    }

    private static boolean isObject(Class<?> clazz) {
        return !clazz.isEnum() && !clazz.equals(Boolean.TYPE) && !clazz.equals(Boolean.class) && clazz != byte[].class && !clazz.equals(Number.class) && !clazz.equals(Double.class) && !clazz.equals(Double.TYPE) && !clazz.equals(Float.class) && !clazz.equals(Float.TYPE) && !clazz.equals(Integer.class) && !clazz.equals(Integer.TYPE) && !clazz.equals(Long.class) && !clazz.equals(Long.TYPE) && !clazz.equals(String.class);
    }

    private static Property getCollectionProperty(Field field) {
        Class<?> clazz = DefinitionsFactory.getCollectionType(field);
        return DefinitionsFactory.createProperty(field, clazz);
    }

    private static Class<?> getCollectionType(Field field) {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type type = parameterizedType.getActualTypeArguments()[0];
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            }
        }
        catch (ClassCastException classCastException) {
            LOGGER.error("Field mapping not supported. ", (Throwable)classCastException);
        }
        return Object.class;
    }
}

