/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.exception;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public class ReflectionExceptions {
    public static void handleReflectionException(Exception exception) {
        if (exception instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + exception.getMessage());
        }
        if (exception instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + exception.getMessage());
        }
        if (exception instanceof InvocationTargetException) {
            ReflectionExceptions.handleInvocationTargetException((InvocationTargetException)exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new UndeclaredThrowableException(exception);
    }

    public static void handleInvocationTargetException(InvocationTargetException invocationTargetException) {
        ReflectionExceptions.rethrowRuntimeException(invocationTargetException.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }
}

