/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.descriptor;

import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.Model;
import java.util.Optional;

public class ParameterDescriptor {
    private String name;
    private String pattern;
    private ParameterType type;
    private String description;
    private boolean required = false;
    private String example;
    private Boolean allowEmptyValue;
    private Model model;
    private Class object;
    private Class collectionOf;
    private String defaultValue;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType parameterType) {
        this.type = parameterType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String string) {
        this.example = string;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean bl) {
        this.allowEmptyValue = bl;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Class getObject() {
        return this.object;
    }

    public void setObject(Class clazz) {
        this.object = clazz;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public Class getCollectionOf() {
        return this.collectionOf;
    }

    public void setCollectionOf(Class clazz) {
        this.collectionOf = clazz;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(MethodDescriptor.Builder builder) {
        return new Builder(builder);
    }

    public static final class Builder {
        private String name;
        private String pattern;
        private ParameterType type;
        private String description;
        private boolean required = false;
        private String example;
        private Boolean allowEmptyValue;
        private Model model;
        private Class object;
        private Class collectionOf;
        private String defaultValue;
        private MethodDescriptor.Builder methodDescriptor;

        private Builder() {
        }

        private Builder(MethodDescriptor.Builder builder) {
            this.methodDescriptor = builder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withName(String string) {
            this.name = string;
            return this;
        }

        public Builder withPattern(String string) {
            this.pattern = string;
            return this;
        }

        public Builder withType(ParameterType parameterType) {
            this.type = parameterType;
            return this;
        }

        public Builder withDescription(String string) {
            this.description = string;
            return this;
        }

        public Builder withRequired(boolean bl) {
            this.required = bl;
            return this;
        }

        public Builder withExample(String string) {
            this.example = string;
            return this;
        }

        public Builder withAllowEmptyValue(Boolean bl) {
            this.allowEmptyValue = bl;
            return this;
        }

        public Builder withModel(Model model) {
            this.model = model;
            return this;
        }

        public Builder withObject(Class clazz) {
            this.object = clazz;
            return this;
        }

        public Builder withCollectionOf(Class clazz) {
            this.collectionOf = clazz;
            return this;
        }

        public Builder withDefaultValue(String string) {
            this.defaultValue = string;
            return this;
        }

        public ParameterDescriptor build() {
            ParameterDescriptor parameterDescriptor = new ParameterDescriptor();
            parameterDescriptor.setName(this.name);
            parameterDescriptor.setPattern(this.pattern);
            parameterDescriptor.setType(this.type);
            parameterDescriptor.setDescription(this.description);
            parameterDescriptor.setRequired(this.required);
            parameterDescriptor.setExample(this.example);
            parameterDescriptor.setAllowEmptyValue(this.allowEmptyValue);
            parameterDescriptor.setModel(this.model);
            parameterDescriptor.setObject(this.object);
            parameterDescriptor.setCollectionOf(this.collectionOf);
            parameterDescriptor.setDefaultValue(this.defaultValue);
            return parameterDescriptor;
        }

        public MethodDescriptor.Builder and() {
            Optional.ofNullable(this.methodDescriptor).orElseThrow(() -> new IllegalStateException("AND operation is only available if building from a MethodDescriptor"));
            ParameterDescriptor parameterDescriptor = this.build();
            this.methodDescriptor.withParam(parameterDescriptor);
            return this.methodDescriptor;
        }
    }

    public static enum ParameterType {
        PATH,
        QUERY,
        FORM,
        HEADER,
        COOKIE;

    }
}

