/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.descriptor;

import io.github.manusant.ss.descriptor.ParameterDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.model.HttpMethod;
import io.github.manusant.ss.model.Response;
import io.github.manusant.ss.rest.RestResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MethodDescriptor {
    private HttpMethod method;
    private String path;
    private String summary;
    private String description;
    private Class<?> requestType;
    private boolean requestAsCollection;
    private ParameterDescriptor body;
    private Class<?> responseType;
    private boolean responseAsCollection;
    private boolean responseAsMap;
    private String operationId;
    private List<String> consumes;
    private List<String> produces;
    private List<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
    private Map<String, Response> responses;
    private ExternalDocs externalDocs;
    private Boolean deprecated;
    private Integer[] responseStatus;
    private List<Map<String, List<String>>> security;

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod httpMethod) {
        this.method = httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String string) {
        this.summary = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Class<?> getRequestType() {
        return this.requestType;
    }

    public void setRequestType(Class<?> clazz) {
        this.requestType = clazz;
    }

    public boolean isRequestAsCollection() {
        return this.requestAsCollection;
    }

    public void setRequestAsCollection(boolean bl) {
        this.requestAsCollection = bl;
    }

    public ParameterDescriptor getBody() {
        return this.body;
    }

    public void setBody(ParameterDescriptor parameterDescriptor) {
        this.body = parameterDescriptor;
    }

    public Class<?> getResponseType() {
        return this.responseType;
    }

    public void setResponseType(Class<?> clazz) {
        this.responseType = clazz;
    }

    public boolean isResponseAsCollection() {
        return this.responseAsCollection;
    }

    public void setResponseAsCollection(boolean bl) {
        this.responseAsCollection = bl;
    }

    public boolean isResponseAsMap() {
        return this.responseAsMap;
    }

    public void setResponseAsMap(boolean bl) {
        this.responseAsMap = bl;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String string) {
        this.operationId = string;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> list) {
        this.consumes = list;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> list) {
        this.produces = list;
    }

    public List<ParameterDescriptor> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterDescriptor> list) {
        this.parameters = list;
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, Response> map) {
        this.responses = map;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean bl) {
        this.deprecated = bl;
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<Map<String, List<String>>> list) {
        this.security = list;
    }

    public Integer[] getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(Integer ... integerArray) {
        this.responseStatus = integerArray;
    }

    public static Builder path(String string) {
        return new Builder().withPath(string);
    }

    public static Builder path() {
        return new Builder().withPath("");
    }

    public static final class Builder {
        private HttpMethod method;
        private String path;
        private String summary;
        private String description;
        private Class requestType;
        private boolean requestAsCollection;
        private ParameterDescriptor body;
        private Class responseType;
        private boolean responseAsCollection;
        private boolean responseAsMap;
        private String operationId;
        private List<String> consumes;
        private List<String> produces;
        private List<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        private Map<String, Response> responses;
        private ExternalDocs externalDocs;
        private Boolean deprecated;
        private Integer[] responseStatus;
        private List<Map<String, List<String>>> security;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withMethod(HttpMethod httpMethod) {
            this.method = httpMethod;
            return this;
        }

        public Builder withPath(String string) {
            this.path = string;
            return this;
        }

        public Builder withSummary(String string) {
            this.summary = string;
            return this;
        }

        public Builder withDescription(String string) {
            this.description = string;
            return this;
        }

        public Builder withRequestType(Class clazz) {
            this.requestType = clazz;
            return this;
        }

        public Builder withBody(ParameterDescriptor parameterDescriptor) {
            this.body = parameterDescriptor;
            return this;
        }

        public Builder withRequestAsCollection(Class clazz) {
            this.requestAsCollection = true;
            this.requestType = clazz;
            return this;
        }

        public Builder withResponseType(Class clazz) {
            this.responseType = clazz;
            return this;
        }

        public Builder withGenericResponse() {
            this.responseType = RestResponse.class;
            return this;
        }

        public Builder withResponseAsCollection(Class clazz) {
            this.responseAsCollection = true;
            this.responseType = clazz;
            return this;
        }

        public Builder withResponseAsMap(Class clazz) {
            this.responseAsMap = true;
            this.responseType = clazz;
            return this;
        }

        public Builder withOperationId(String string) {
            this.operationId = string;
            return this;
        }

        public Builder withConsumes(List<String> list) {
            this.consumes = list;
            return this;
        }

        public Builder withProduces(List<String> list) {
            this.produces = list;
            return this;
        }

        public Builder withParams(List<ParameterDescriptor> list) {
            this.parameters = list;
            return this;
        }

        public Builder withParam(ParameterDescriptor parameterDescriptor) {
            this.parameters.add(parameterDescriptor);
            return this;
        }

        public Builder withParam(ParameterDescriptor.ParameterType parameterType, ParameterDescriptor parameterDescriptor) {
            parameterDescriptor.setType(parameterType);
            this.parameters.add(parameterDescriptor);
            return this;
        }

        public ParameterDescriptor.Builder withPathParam() {
            return ParameterDescriptor.newBuilder(this).withType(ParameterDescriptor.ParameterType.PATH);
        }

        public Builder withPathParam(ParameterDescriptor parameterDescriptor) {
            parameterDescriptor.setType(ParameterDescriptor.ParameterType.PATH);
            this.parameters.add(parameterDescriptor);
            return this;
        }

        public ParameterDescriptor.Builder withQueryParam() {
            return ParameterDescriptor.newBuilder(this).withType(ParameterDescriptor.ParameterType.QUERY);
        }

        public Builder withQueryParam(ParameterDescriptor parameterDescriptor) {
            parameterDescriptor.setType(ParameterDescriptor.ParameterType.QUERY);
            this.parameters.add(parameterDescriptor);
            return this;
        }

        public ParameterDescriptor.Builder withHeaderParam() {
            return ParameterDescriptor.newBuilder(this).withType(ParameterDescriptor.ParameterType.HEADER);
        }

        public Builder withHeaderParam(ParameterDescriptor parameterDescriptor) {
            parameterDescriptor.setType(ParameterDescriptor.ParameterType.HEADER);
            this.parameters.add(parameterDescriptor);
            return this;
        }

        public ParameterDescriptor.Builder withFormParam() {
            return ParameterDescriptor.newBuilder(this).withType(ParameterDescriptor.ParameterType.FORM);
        }

        public Builder withFormParam(ParameterDescriptor parameterDescriptor) {
            parameterDescriptor.setType(ParameterDescriptor.ParameterType.FORM);
            this.parameters.add(parameterDescriptor);
            return this;
        }

        public ParameterDescriptor.Builder withCookieParam() {
            return ParameterDescriptor.newBuilder(this).withType(ParameterDescriptor.ParameterType.COOKIE);
        }

        public Builder withCookieParam(ParameterDescriptor parameterDescriptor) {
            parameterDescriptor.setType(ParameterDescriptor.ParameterType.COOKIE);
            this.parameters.add(parameterDescriptor);
            return this;
        }

        public Builder withResponses(Map<String, Response> map) {
            this.responses = map;
            return this;
        }

        public Builder withExternalDocs(ExternalDocs externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        public Builder withDeprecated(Boolean bl) {
            this.deprecated = bl;
            return this;
        }

        public Builder withSecurity(List<Map<String, List<String>>> list) {
            this.security = list;
            return this;
        }

        public Builder withSecurity(String string, List<String> list) {
            if (this.security == null) {
                this.security = new ArrayList<Map<String, List<String>>>();
            }
            LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
            if (list == null) {
                list = new ArrayList<String>();
            }
            linkedHashMap.put(string, list);
            this.security.add(linkedHashMap);
            return this;
        }

        public Builder withSecurity(String string) {
            this.withSecurity(string, Collections.emptyList());
            return this;
        }

        public Builder withResponseStatus(Integer ... integerArray) {
            this.responseStatus = integerArray;
            return this;
        }

        public MethodDescriptor build() {
            MethodDescriptor methodDescriptor = new MethodDescriptor();
            methodDescriptor.setMethod(this.method);
            methodDescriptor.setPath(this.path);
            methodDescriptor.setSummary(this.summary);
            methodDescriptor.setDescription(this.description);
            methodDescriptor.setRequestType(this.requestType);
            methodDescriptor.setRequestAsCollection(this.requestAsCollection);
            methodDescriptor.setBody(this.body);
            methodDescriptor.setResponseType(this.responseType);
            methodDescriptor.setResponseAsCollection(this.responseAsCollection);
            methodDescriptor.setResponseAsMap(this.responseAsMap);
            methodDescriptor.setOperationId(this.operationId);
            methodDescriptor.setConsumes(this.consumes);
            methodDescriptor.setProduces(this.produces);
            methodDescriptor.setParameters(this.parameters);
            methodDescriptor.setResponses(this.responses);
            methodDescriptor.setExternalDocs(this.externalDocs);
            methodDescriptor.setDeprecated(this.deprecated);
            methodDescriptor.setSecurity(this.security);
            methodDescriptor.setResponseStatus(this.responseStatus);
            return methodDescriptor;
        }
    }
}

