/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.descriptor;

import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.model.Tag;

public class EndpointDescriptor {
    private String nameSpace;
    private String path;
    private Tag tag;
    private String description;
    private ExternalDocs externalDoc;

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public ExternalDocs getExternalDoc() {
        return this.externalDoc;
    }

    public void setExternalDoc(ExternalDocs externalDocs) {
        this.externalDoc = externalDocs;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String string) {
        this.nameSpace = string;
    }

    public static Builder endpointPath(String string) {
        return new Builder().withPath(string);
    }

    public static final class Builder {
        private String name;
        private String path;
        private String description;
        private ExternalDocs externalDoc;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withName(String string) {
            this.name = string;
            return this;
        }

        public Builder withPath(String string) {
            this.path = string;
            return this;
        }

        public Builder withDescription(String string) {
            this.description = string;
            return this;
        }

        public Builder withExternalDoc(ExternalDocs externalDocs) {
            this.externalDoc = externalDocs;
            return this;
        }

        private String getName() {
            if (this.name != null) {
                return this.name;
            }
            return this.path.contains("/") ? this.path.substring(1) : this.path;
        }

        public EndpointDescriptor build() {
            EndpointDescriptor endpointDescriptor = new EndpointDescriptor();
            endpointDescriptor.setPath(this.path);
            endpointDescriptor.setTag(Tag.newBuilder().withName(this.getName()).withDescription(this.description).withExternalDocs(this.externalDoc).build());
            endpointDescriptor.setDescription(this.description);
            endpointDescriptor.setExternalDoc(this.externalDoc);
            return endpointDescriptor;
        }
    }
}

