/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.conf;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.manusant.ss.conf.IgnoreSpec;
import java.util.function.Supplier;

public class TypifyProvider {
    private static Gson GSON;

    private static Gson createJson(IgnoreSpec ignoreSpec) {
        GsonBuilder gsonBuilder = TypifyProvider.createBuilder(ignoreSpec);
        return gsonBuilder.create();
    }

    private static GsonBuilder createBuilder(final IgnoreSpec ignoreSpec) {
        return new GsonBuilder().setPrettyPrinting().serializeSpecialFloatingPointValues().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return ignoreSpec != null && (ignoreSpec.ignoreAnnotated(fieldAttributes) || ignoreSpec.ignored(fieldAttributes));
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }});
    }

    public static void setUp(Supplier<IgnoreSpec> supplier) {
        GSON = TypifyProvider.createJson(supplier.get());
    }

    public static Gson json() {
        if (GSON == null) {
            GSON = TypifyProvider.createJson(null);
        }
        return GSON;
    }
}

