/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.conf;

import com.google.gson.FieldAttributes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class IgnoreSpec {
    private List<Class<? extends Annotation>> ignoreAnnotated;
    private List<Class<?>> ignoreTypes;
    private List<String> endpointPaths;

    public List<Class<? extends Annotation>> getIgnoreAnnotated() {
        return this.ignoreAnnotated;
    }

    public void setIgnoreAnnotated(List<Class<? extends Annotation>> list) {
        this.ignoreAnnotated = list;
    }

    public List<Class<?>> getIgnoreTypes() {
        return this.ignoreTypes;
    }

    public void setIgnoreTypes(List<Class<?>> list) {
        this.ignoreTypes = list;
    }

    public List<String> getEndpointPaths() {
        return this.endpointPaths;
    }

    public void setEndpointPaths(List<String> list) {
        this.endpointPaths = list;
    }

    public boolean ignored(String string) {
        return this.endpointPaths != null && this.endpointPaths.contains(string);
    }

    public boolean ignored(Field field) {
        if (this.ignoreTypes != null) {
            Type type;
            if ((field.getType().isArray() || Collection.class.isAssignableFrom(field.getType())) && (type = field.getGenericType()) instanceof ParameterizedType && this.ignoreParameterizedType((ParameterizedType)type, this.ignoreTypes)) {
                return true;
            }
            return this.ignoreTypes.contains(field.getType());
        }
        return false;
    }

    public boolean ignored(FieldAttributes fieldAttributes) {
        if (this.ignoreTypes != null) {
            Type type;
            if ((fieldAttributes.getDeclaredClass().isArray() || Collection.class.isAssignableFrom(fieldAttributes.getDeclaredClass())) && (type = fieldAttributes.getDeclaredType()) instanceof ParameterizedType && this.ignoreParameterizedType((ParameterizedType)type, this.ignoreTypes)) {
                return true;
            }
            return this.ignoreTypes.contains(fieldAttributes.getDeclaredClass());
        }
        return false;
    }

    private boolean ignoreParameterizedType(ParameterizedType parameterizedType, List<Class<?>> list) {
        for (Type type : parameterizedType.getActualTypeArguments()) {
            if (!list.stream().map(Class::getTypeName).anyMatch(string -> string.equalsIgnoreCase(type.getTypeName()))) continue;
            return true;
        }
        return false;
    }

    public boolean ignoreAnnotated(Class<?> clazz) {
        if (this.ignoreAnnotated != null) {
            for (Class<? extends Annotation> clazz2 : this.ignoreAnnotated) {
                if (!clazz.isAnnotationPresent(clazz2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ignoreAnnotated(Field field) {
        if (this.ignoreAnnotated != null) {
            for (Class<? extends Annotation> clazz : this.ignoreAnnotated) {
                if (field.getAnnotation(clazz) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ignoreAnnotated(FieldAttributes fieldAttributes) {
        if (this.ignoreAnnotated != null) {
            for (Class<? extends Annotation> clazz : this.ignoreAnnotated) {
                if (fieldAttributes.getAnnotation(clazz) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Class<? extends Annotation>> ignoreAnnotated;
        private List<Class<?>> ignoreTypes;
        private List<String> endpointPaths;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withIgnoreAnnotated(Class<? extends Annotation> ... classArray) {
            this.ignoreAnnotated = Arrays.asList(classArray);
            return this;
        }

        public Builder withIgnoreTypes(Class<?> ... classArray) {
            this.ignoreTypes = Arrays.asList(classArray);
            return this;
        }

        public Builder withEndpointPaths(String ... stringArray) {
            this.endpointPaths = Arrays.asList(stringArray);
            return this;
        }

        public IgnoreSpec build() {
            IgnoreSpec ignoreSpec = new IgnoreSpec();
            ignoreSpec.setIgnoreAnnotated(this.ignoreAnnotated);
            ignoreSpec.setIgnoreTypes(this.ignoreTypes);
            ignoreSpec.setEndpointPaths(this.endpointPaths);
            return ignoreSpec;
        }
    }
}

