/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss;

import io.github.manusant.ss.Swagger;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.descriptor.ParameterDescriptor;
import io.github.manusant.ss.factory.DefinitionsFactory;
import io.github.manusant.ss.factory.ParamsFactory;
import io.github.manusant.ss.model.Model;
import io.github.manusant.ss.model.Operation;
import io.github.manusant.ss.model.RefModel;
import io.github.manusant.ss.model.Response;
import io.github.manusant.ss.model.parameters.BodyParameter;
import io.github.manusant.ss.model.parameters.Parameter;
import io.github.manusant.ss.model.properties.ArrayProperty;
import io.github.manusant.ss.model.properties.MapProperty;
import io.github.manusant.ss.model.properties.Property;
import io.github.manusant.ss.model.utils.PropertyModelConverter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerSpecBuilder {
    private static final Logger log = LoggerFactory.getLogger(SwaggerSpecBuilder.class);
    private static final boolean INCLUDE_RESPONSE_SCHEMA = false;
    private final Swagger swagger;

    public SwaggerSpecBuilder(Swagger swagger) {
        this.swagger = swagger;
    }

    public void build() {
        log.debug("Spark-Swagger: Start parsing metadata");
        if (this.swagger.getApiEndpoints() != null) {
            this.swagger.getApiEndpoints().forEach(apiEndpoint -> {
                if (this.swagger.getIgnoreSpec() == null || !this.swagger.getIgnoreSpec().ignored(apiEndpoint.getEndpointDescriptor().getPath())) {
                    this.swagger.tag(apiEndpoint.getEndpointDescriptor().getTag());
                    apiEndpoint.getMethodDescriptors().forEach(methodDescriptor -> {
                        Operation operation = new Operation();
                        operation.tag(apiEndpoint.getEndpointDescriptor().getTag().getName());
                        operation.description(methodDescriptor.getDescription());
                        operation.setSecurity(methodDescriptor.getSecurity());
                        Optional.ofNullable(methodDescriptor.getSummary()).ifPresent(operation::summary);
                        Optional.ofNullable(methodDescriptor.getOperationId()).ifPresent(operation::operationId);
                        List<Parameter> list = ParamsFactory.create(methodDescriptor.getPath(), methodDescriptor.getParameters());
                        operation.setParameters(list);
                        DefinitionsFactory.ignoreSpec = this.swagger.getIgnoreSpec();
                        ParameterDescriptor parameterDescriptor = methodDescriptor.getBody();
                        if (parameterDescriptor != null && parameterDescriptor.getModel() != null) {
                            this.buildRequest((MethodDescriptor)methodDescriptor, operation, parameterDescriptor);
                        } else if (methodDescriptor.getRequestType() != null) {
                            this.buildRequestFromType((MethodDescriptor)methodDescriptor, operation, parameterDescriptor);
                        }
                        Map<String, Response> map = methodDescriptor.getResponses();
                        if (map != null && !map.isEmpty()) {
                            this.buildResponses((MethodDescriptor)methodDescriptor, operation, map);
                        } else if (methodDescriptor.getResponseType() != null) {
                            Response response = this.buildResponseFromType((MethodDescriptor)methodDescriptor);
                            Integer[] integerArray = methodDescriptor.getResponseStatus();
                            if (integerArray != null) {
                                for (Integer n2 : integerArray) {
                                    operation.addResponse("" + n2, response);
                                }
                            } else {
                                operation.addResponse("200", response);
                            }
                        } else {
                            Response response = new Response();
                            response.description("successful operation");
                            Integer[] integerArray = methodDescriptor.getResponseStatus();
                            if (integerArray != null) {
                                for (Integer n3 : integerArray) {
                                    operation.addResponse("" + n3, response);
                                }
                            } else {
                                operation.addResponse("200", response);
                            }
                        }
                        if (methodDescriptor.getProduces() != null) {
                            operation.produces(methodDescriptor.getProduces());
                        }
                        if (methodDescriptor.getConsumes() != null) {
                            operation.consumes(methodDescriptor.getConsumes());
                        }
                        this.swagger.addOperation(methodDescriptor.getPath(), methodDescriptor.getMethod(), operation);
                    });
                }
            });
            log.debug("Spark-Swagger: metadata successfully parsed");
        } else {
            log.debug("Spark-Swagger: No metadata to parse. Please check your SparkSwagger configurations and Endpoints Resolver");
        }
    }

    private void buildRequest(MethodDescriptor methodDescriptor, Operation operation, ParameterDescriptor parameterDescriptor) {
        Model model = parameterDescriptor.getModel();
        this.swagger.addDefinition(model.getTitle(), model);
        BodyParameter bodyParameter = this.createBodyParameter(parameterDescriptor, model);
        operation.addParameter(bodyParameter);
        if (methodDescriptor.getRequestType() != null) {
            this.swagger.addDefinitionsForType(model.getTitle(), methodDescriptor.getRequestType());
        }
    }

    private void buildRequestFromType(MethodDescriptor methodDescriptor, Operation operation, ParameterDescriptor parameterDescriptor) {
        Object object;
        Map<String, Model> map = DefinitionsFactory.create(methodDescriptor.getRequestType());
        for (String object22 : map.keySet()) {
            if (this.swagger.hasDefinition(object22)) continue;
            this.swagger.addDefinition(object22, map.get(object22));
        }
        if (map.isEmpty()) {
            Property property = DefinitionsFactory.createProperty(null, methodDescriptor.getRequestType());
            object = new PropertyModelConverter().propertyToModel(property);
        } else {
            RefModel refModel = new RefModel();
            refModel.set$ref(methodDescriptor.getRequestType().getSimpleName());
            object = refModel;
        }
        BodyParameter bodyParameter = this.createBodyParameter(parameterDescriptor, (Model)object);
        operation.addParameter(bodyParameter);
    }

    private Response buildResponseFromType(MethodDescriptor methodDescriptor) {
        PropertyModelConverter propertyModelConverter = new PropertyModelConverter();
        Property property = this.typeToProperty(methodDescriptor.getResponseType());
        Response response = new Response();
        response.description("successful operation");
        if (methodDescriptor.isResponseAsCollection()) {
            ArrayProperty arrayProperty = new ArrayProperty();
            arrayProperty.setItems(property);
            response.setSchema(arrayProperty);
            response.setResponseSchema(propertyModelConverter.propertyToModel(arrayProperty));
        } else if (methodDescriptor.isResponseAsMap()) {
            MapProperty mapProperty = new MapProperty(property);
            mapProperty.additionalProperties(property);
            response.setSchema(mapProperty);
            response.setResponseSchema(propertyModelConverter.propertyToModel(mapProperty));
        } else {
            response.setSchema(property);
            response.setResponseSchema(propertyModelConverter.propertyToModel(property));
        }
        return response;
    }

    private void buildResponses(MethodDescriptor methodDescriptor, Operation operation, Map<String, Response> map) {
        map.forEach((string, response) -> {
            if (response.getSchema() != null) {
                Property property = response.getSchema();
                Model model = new PropertyModelConverter().propertyToModel(property);
                response.setResponseSchema(model);
                this.swagger.addDefinition(property.getTitle(), model);
                if (model.getTypeClass() != null) {
                    this.swagger.addDefinitionsForType(model.getTitle(), model.getTypeClass());
                }
            } else if (response.getExamples() != null) {
                response.getExamples().forEach((string2, object) -> {
                    Property property;
                    Map<String, Model> map = DefinitionsFactory.create(object.getClass());
                    map.forEach((string, model) -> {
                        if (!this.swagger.hasDefinition((String)string)) {
                            this.swagger.addDefinition((String)string, (Model)model);
                        }
                    });
                    if (map.isEmpty()) {
                        property = DefinitionsFactory.createProperty(null, object.getClass());
                    } else {
                        RefModel refModel = new RefModel();
                        refModel.set$ref(object.getClass().getSimpleName());
                        property = new PropertyModelConverter().modelToProperty(refModel);
                    }
                    property.setExample(object);
                    response.setSchema(property);
                    response.setResponseSchema(new PropertyModelConverter().propertyToModel(property));
                });
            } else if (methodDescriptor.getResponseType() != null) {
                Model model = this.typeToModel(methodDescriptor.getResponseType());
                response.setResponseSchema(model);
            }
            operation.addResponse((String)string, (Response)response);
        });
    }

    private BodyParameter createBodyParameter(ParameterDescriptor parameterDescriptor, Model model) {
        BodyParameter bodyParameter = new BodyParameter();
        bodyParameter.name(parameterDescriptor != null ? parameterDescriptor.getName() : "body");
        bodyParameter.description(parameterDescriptor != null ? parameterDescriptor.getDescription() : "Body object description");
        bodyParameter.setRequired(parameterDescriptor == null || parameterDescriptor.isRequired());
        bodyParameter.setSchema(model);
        return bodyParameter;
    }

    private Model typeToModel(Class<?> clazz) {
        Model model;
        Map<String, Model> map = this.swagger.addDefinitionsForType(null, clazz);
        if (map.isEmpty()) {
            Property property = DefinitionsFactory.createProperty(null, clazz);
            model = new PropertyModelConverter().propertyToModel(property);
        } else {
            RefModel refModel = new RefModel();
            refModel.set$ref(clazz.getSimpleName());
            model = refModel;
        }
        return model;
    }

    private Property typeToProperty(Class<?> clazz) {
        Property property;
        Map<String, Model> map = this.swagger.addDefinitionsForType(null, clazz);
        if (map.isEmpty()) {
            property = DefinitionsFactory.createProperty(null, clazz);
        } else {
            RefModel refModel = new RefModel();
            refModel.set$ref(clazz.getSimpleName());
            property = new PropertyModelConverter().modelToProperty(refModel);
        }
        return property;
    }
}

