/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.manusant.ss.Swagger;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerParser {
    private static final Logger log = LoggerFactory.getLogger(SwaggerParser.class);

    public static void parseYaml(Swagger swagger, String string) throws IOException {
        log.debug("Spark-Swagger: Start parsing Swagger definitions");
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.writeValue(new File(string), (Object)swagger);
        log.debug("Spark-Swagger: Swagger definitions saved as {} [YAML]", (Object)string);
    }

    public static void parseJson(Swagger swagger, String string) throws IOException {
        log.debug("Spark-Swagger: Start parsing Swagger definitions");
        ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.writeValue(new File(string), (Object)swagger);
        log.debug("Spark-Swagger: Swagger definitions saved as " + string + " [JSON]");
    }

    public static void parseJs(Swagger swagger, String string) throws IOException {
        log.debug("Spark-Swagger: Start parsing Swagger definitions");
        ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String string2 = objectMapper.writeValueAsString((Object)swagger);
        string2 = "window.swaggerSpec=" + string2;
        File file = new File(string);
        file.delete();
        try (PrintWriter printWriter = new PrintWriter(string);){
            printWriter.println(string2);
        }
        log.debug("Spark-Swagger: Swagger definitions saved as " + string + " [JS]");
    }
}

