/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss;

import com.typesafe.config.Config;
import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.Swagger;
import io.github.manusant.ss.SwaggerParser;
import io.github.manusant.ss.conf.Theme;
import io.github.manusant.ss.ui.UiTemplates;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerHammer {
    private static final Logger log = LoggerFactory.getLogger(SwaggerHammer.class);

    public void prepareUi(Config config, Swagger swagger) throws IOException {
        log.debug("Spark-Swagger: Start compiling Swagger UI");
        String string = SwaggerHammer.getUiFolder(config.getString("spark-swagger.basePath"));
        this.extractUi(string);
        String string2 = this.decorateIndex(config);
        this.saveFile(string, "index.html", string2);
        SwaggerParser.parseJs(swagger, string + "swagger-spec.js");
        SwaggerParser.parseYaml(swagger, string + "doc.yaml");
        SwaggerParser.parseJson(swagger, string + "doc.json");
        this.applyTheme(string, config);
    }

    private void extractUi(String string) throws IOException {
        this.extractUiFolder(string);
        this.extractTemplatesFolder(string);
        log.debug("Spark-Swagger: UI resources and templates successfully extracted");
    }

    private void extractUiFolder(String string3) throws IOException {
        String string4 = "ui";
        List list = this.listFiles(string4).stream().map(string2 -> string2.substring(string2.indexOf(string4) + string4.length() + 1).trim()).filter(string -> !string.contains("/") && !string.isEmpty()).collect(Collectors.toList());
        for (String string5 : list) {
            InputStream inputStream = SparkSwagger.class.getClassLoader().getResourceAsStream(string4 + "/" + string5);
            File file = new File(string3 + string5);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            if (inputStream == null) continue;
            Files.copy(inputStream, file.getAbsoluteFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void extractTemplatesFolder(String string3) throws IOException {
        File file = new File(string3 + "templates/");
        if (!file.exists()) {
            file.mkdir();
        }
        String string4 = "ui/templates";
        List list = this.listFiles(string4).stream().map(string2 -> string2.substring(string2.indexOf(string4) + string4.length() + 1).trim()).filter(string -> !string.contains("/") && !string.isEmpty()).collect(Collectors.toList());
        Files.createDirectories(Paths.get(string3 + "templates/", new String[0]), new FileAttribute[0]);
        for (String string5 : list) {
            InputStream inputStream = SparkSwagger.class.getClassLoader().getResourceAsStream(string4 + "/" + string5);
            File file2 = new File(string3 + "templates/" + string5);
            if (file2.exists()) {
                file2.delete();
            }
            file2.createNewFile();
            if (inputStream == null) continue;
            Files.copy(inputStream, file2.getAbsoluteFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private List<String> listFiles(String string) throws IOException {
        CodeSource codeSource = SparkSwagger.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL uRL = codeSource.getLocation();
            if (uRL.toString().endsWith(".jar")) {
                return this.filesFromJar(string, uRL);
            }
            return this.filesFromDir(string, uRL.toString());
        }
        return Collections.emptyList();
    }

    public List<String> filesFromDir(String string, String string3) throws IOException {
        List<String> list;
        String string4 = string3.replace("file:/", "");
        try (Stream<Path> stream = Files.walk(Paths.get(string4, new String[0]).toAbsolutePath(), new FileVisitOption[0]);){
            list = stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path -> path.toString().replace("\\", "/").replace(string4, "")).filter(string2 -> !string2.equals(string) && string2.startsWith(string)).collect(Collectors.toList());
        }
        return list;
    }

    private List<String> filesFromJar(String string, URL uRL) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (!string2.startsWith(string)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private void applyTheme(String string, Config config) throws IOException {
        log.debug("Spark-Swagger: Start applying configured CSS Theme");
        String string2 = config.getString("spark-swagger.theme");
        Theme theme = Theme.fromValue(string2);
        String string3 = this.readFile(string, "templates/" + theme.getValue() + ".css", StandardCharsets.UTF_8);
        this.saveFile(string, "swagger-ui.css", string3);
        log.debug("Spark-Swagger: CSS Theme successfully applied");
    }

    private String readFile(String string, String string2, Charset charset) throws IOException {
        byte[] byArray = Files.readAllBytes(Paths.get(string + string2, new String[0]));
        return new String(byArray, charset);
    }

    private void saveFile(String string, String string2, String string3) throws IOException {
        File file = new File(string + string2);
        file.delete();
        try (FileWriter fileWriter = new FileWriter(file, false);){
            fileWriter.write(string3);
        }
        log.debug("Spark-Swagger: Swagger UI file " + string2 + " successfully saved");
    }

    public static String getUiFolder(String string) {
        if (string.isEmpty() || string.length() == 1) {
            return SwaggerHammer.getSwaggerUiFolder();
        }
        String string2 = (string.startsWith("/") ? string.replaceFirst("/", "") : string) + (string.endsWith("/") ? "" : "/");
        return SwaggerHammer.getSwaggerUiFolder() + string2;
    }

    public static String getSwaggerUiFolder() {
        return Paths.get(System.getProperty("java.io.tmpdir"), "swagger-ui").toString() + "/";
    }

    public static void createDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private String decorateIndex(Config config) {
        log.debug("Spark-Swagger: Start decorating index.html according to ui configurations");
        String string = UiTemplates.indexTemplate();
        int n2 = string.indexOf("window.onload");
        int n3 = string.indexOf("</script>", n2);
        String string2 = string.substring(n2, n3);
        String string3 = UiTemplates.scriptTemplate();
        string3 = this.setStringProperty(string3, "docExpansion", config.getString("spark-swagger.docExpansion"), "list");
        string3 = this.setPrimitiveProperty(string3, "deepLinking", config.getString("spark-swagger.deepLinking"), false);
        string3 = this.setPrimitiveProperty(string3, "displayOperationId", config.getString("spark-swagger.displayOperationId"), false);
        string3 = this.setPrimitiveProperty(string3, "defaultModelsExpandDepth", config.getString("spark-swagger.defaultModelsExpandDepth"), 1);
        string3 = this.setPrimitiveProperty(string3, "defaultModelExpandDepth", config.getString("spark-swagger.defaultModelExpandDepth"), 1);
        string3 = this.setStringProperty(string3, "defaultModelRendering", config.getString("spark-swagger.defaultModelRendering"), "example");
        string3 = this.setPrimitiveProperty(string3, "displayRequestDuration", config.getString("spark-swagger.displayRequestDuration"), false);
        string3 = this.setPrimitiveProperty(string3, "filter", config.getString("spark-swagger.filter"), false);
        string3 = this.setStringProperty(string3, "operationsSorter", config.getString("spark-swagger.operationsSorter"), "alpha");
        string3 = this.setPrimitiveProperty(string3, "showExtensions", config.getString("spark-swagger.showExtensions"), false);
        string3 = this.setPrimitiveProperty(string3, "showCommonExtensions", config.getString("spark-swagger.showCommonExtensions"), false);
        string3 = this.setStringProperty(string3, "tagsSorter", config.getString("spark-swagger.tagsSorter"), "alpha");
        log.debug("Spark-Swagger: index.html successfully decorated");
        return string.replace(string2, string3);
    }

    private String setStringProperty(String string, String string2, String string3, String string4) {
        string = string3 != null ? this.replaceProperty(string, string2, string3.toLowerCase(), true) : this.replaceProperty(string, string2, string4, true);
        return string;
    }

    private String setPrimitiveProperty(String string, String string2, Object object, Object object2) {
        string = object != null ? this.replaceProperty(string, string2, object.toString(), false) : this.replaceProperty(string, string2, object2.toString(), false);
        return string;
    }

    private String replaceProperty(String string, String string2, String string3, boolean bl) {
        int n2;
        if (string3 == null) {
            string3 = "null";
        }
        if (string2 != null && (n2 = string.indexOf(string2)) != -1 && string.indexOf(":", n2) != -1) {
            String string4 = string.substring(string.indexOf(":", n2) + 1, string.indexOf(",", n2)).trim();
            string = bl && !string3.equals("null") ? (string3.isEmpty() ? this.replace(string, string2, string4, "null") : this.replace(string, string2, string4, "'" + string3 + "'")) : this.replace(string, string2, string4, string3);
        }
        return string;
    }

    private String replace(String string, String string2, String string3, String string4) {
        String string5 = string2 + ": " + string3;
        String string6 = string2 + ": " + string4;
        return string.replace(string5, string6);
    }
}

