/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.manusant.ss.ApiEndpoint;
import io.github.manusant.ss.conf.IgnoreSpec;
import io.github.manusant.ss.factory.DefinitionsFactory;
import io.github.manusant.ss.factory.ParamsFactory;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.model.HttpMethod;
import io.github.manusant.ss.model.Info;
import io.github.manusant.ss.model.Model;
import io.github.manusant.ss.model.Operation;
import io.github.manusant.ss.model.Path;
import io.github.manusant.ss.model.Response;
import io.github.manusant.ss.model.Scheme;
import io.github.manusant.ss.model.SecurityRequirement;
import io.github.manusant.ss.model.Tag;
import io.github.manusant.ss.model.auth.SecuritySchemeDefinition;
import io.github.manusant.ss.model.parameters.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Swagger {
    private String swagger = "2.0";
    private Info info;
    private String host;
    private String basePath;
    private List<Tag> tags;
    private List<Scheme> schemes;
    private List<String> consumes;
    private List<String> produces;
    private List<SecurityRequirement> security;
    private Map<String, Path> paths;
    private Map<String, SecuritySchemeDefinition> securityDefinitions;
    private Map<String, Model> definitions;
    private ExternalDocs externalDocs;
    private Map<String, Parameter> parameters;
    private Map<String, Response> responses;
    private Map<String, Object> vendorExtensions;
    @JsonIgnore
    private List<ApiEndpoint> apiEndpoints;
    @JsonIgnore
    private IgnoreSpec ignoreSpec;

    public Swagger endpoints(List<ApiEndpoint> list) {
        this.apiEndpoints = list;
        return this;
    }

    public Swagger ignores(IgnoreSpec ignoreSpec) {
        this.ignoreSpec = ignoreSpec;
        return this;
    }

    public Swagger info(Info info) {
        this.setInfo(info);
        return this;
    }

    public Swagger host(String string) {
        this.setHost(string);
        return this;
    }

    public Swagger basePath(String string) {
        this.setBasePath(string);
        return this;
    }

    public Swagger externalDocs(ExternalDocs externalDocs) {
        this.setExternalDocs(externalDocs);
        return this;
    }

    public Swagger tags(List<Tag> list) {
        this.setTags(list);
        return this;
    }

    public Swagger tag(Tag tag) {
        this.addTag(tag);
        return this;
    }

    public Swagger schemes(List<Scheme> list) {
        this.setSchemes(list);
        return this;
    }

    public Swagger scheme(Scheme scheme) {
        this.addScheme(scheme);
        return this;
    }

    public Swagger consumes(List<String> list) {
        this.setConsumes(list);
        return this;
    }

    public Swagger consumes(String string) {
        this.addConsumes(string);
        return this;
    }

    public Swagger produces(List<String> list) {
        this.setProduces(list);
        return this;
    }

    public Swagger produces(String string) {
        this.addProduces(string);
        return this;
    }

    public Swagger paths(Map<String, Path> map) {
        this.setPaths(map);
        return this;
    }

    public Swagger path(String string, Path path) {
        if (this.paths == null) {
            this.paths = new LinkedHashMap<String, Path>();
        }
        this.paths.put(string, path);
        return this;
    }

    public Swagger responses(Map<String, Response> map) {
        this.responses = map;
        return this;
    }

    public Swagger response(String string, Response response) {
        if (this.responses == null) {
            this.responses = new LinkedHashMap<String, Response>();
        }
        this.responses.put(string, response);
        return this;
    }

    public Swagger parameter(String string, Parameter parameter) {
        this.addParameter(string, parameter);
        return this;
    }

    public Swagger securityDefinition(String string, SecuritySchemeDefinition securitySchemeDefinition) {
        this.addSecurityDefinition(string, securitySchemeDefinition);
        return this;
    }

    public Swagger model(String string, Model model) {
        this.addDefinition(string, model);
        return this;
    }

    public Swagger security(SecurityRequirement securityRequirement) {
        this.addSecurity(securityRequirement);
        return this;
    }

    public Swagger vendorExtension(String string, Object object) {
        if (this.vendorExtensions == null) {
            this.vendorExtensions = new LinkedHashMap<String, Object>();
        }
        this.vendorExtensions.put(string, object);
        return this;
    }

    public String getSwagger() {
        return this.swagger;
    }

    public void setSwagger(String string) {
        this.swagger = string;
    }

    public List<ApiEndpoint> getApiEndpoints() {
        return this.apiEndpoints;
    }

    public void addApiEndpoint(ApiEndpoint apiEndpoint) {
        if (this.apiEndpoints == null) {
            this.apiEndpoints = new ArrayList<ApiEndpoint>();
        }
        this.apiEndpoints.add(apiEndpoint);
    }

    public IgnoreSpec getIgnoreSpec() {
        return this.ignoreSpec;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public List<Scheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<Scheme> list) {
        this.schemes = list;
    }

    public void addScheme(Scheme scheme) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        if (!this.schemes.contains((Object)scheme)) {
            this.schemes.add(scheme);
        }
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> list) {
        this.tags = list;
    }

    public Tag getTag(String string) {
        Tag tag = null;
        if (this.tags != null && string != null) {
            for (Tag tag2 : this.tags) {
                if (!tag2.getName().equals(string)) continue;
                tag = tag2;
                break;
            }
        }
        return tag;
    }

    public void addTag(Tag tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        if (tag != null && tag.getName() != null && this.getTag(tag.getName()) == null) {
            this.tags.add(tag);
        }
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> list) {
        this.consumes = list;
    }

    public void addConsumes(String string) {
        if (this.consumes == null) {
            this.consumes = new ArrayList<String>();
        }
        if (!this.consumes.contains(string)) {
            this.consumes.add(string);
        }
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> list) {
        this.produces = list;
    }

    public void addProduces(String string) {
        if (this.produces == null) {
            this.produces = new ArrayList<String>();
        }
        if (!this.produces.contains(string)) {
            this.produces.add(string);
        }
    }

    public Map<String, Path> getPaths() {
        return this.paths;
    }

    public void setPaths(Map<String, Path> map) {
        this.paths = map;
    }

    public Path getPath(String string) {
        if (this.paths == null) {
            return null;
        }
        return this.paths.get(string);
    }

    public Map<String, SecuritySchemeDefinition> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public void setSecurityDefinitions(Map<String, SecuritySchemeDefinition> map) {
        this.securityDefinitions = map;
    }

    public void addSecurityDefinition(String string, SecuritySchemeDefinition securitySchemeDefinition) {
        if (this.securityDefinitions == null) {
            this.securityDefinitions = new LinkedHashMap<String, SecuritySchemeDefinition>();
        }
        this.securityDefinitions.put(string, securitySchemeDefinition);
    }

    @JsonIgnore
    @Deprecated
    public List<SecurityRequirement> getSecurityRequirement() {
        return this.security;
    }

    @JsonIgnore
    @Deprecated
    public void setSecurityRequirement(List<SecurityRequirement> list) {
        this.security = list;
    }

    @JsonIgnore
    @Deprecated
    public void addSecurityDefinition(SecurityRequirement securityRequirement) {
        this.addSecurity(securityRequirement);
    }

    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRequirement> list) {
        this.security = list;
    }

    public void addSecurity(SecurityRequirement securityRequirement) {
        if (this.security == null) {
            this.security = new ArrayList<SecurityRequirement>();
        }
        this.security.add(securityRequirement);
    }

    public Map<String, Model> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Map<String, Model> map) {
        this.definitions = map;
    }

    public void addDefinition(String string, Model model) {
        if (string == null) {
            return;
        }
        if (this.definitions == null) {
            this.definitions = new LinkedHashMap<String, Model>();
        }
        this.definitions.put(string, model);
    }

    public boolean hasDefinition(String string) {
        if (this.definitions == null) {
            return false;
        }
        return this.definitions.keySet().contains(string);
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> map) {
        this.parameters = map;
    }

    public Parameter getParameter(String string) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(string);
    }

    public void addParameter(String string, Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Parameter>();
        }
        this.parameters.put(string, parameter);
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, Response> map) {
        this.responses = map;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String string, Object object) {
        if (string.startsWith("x-")) {
            this.vendorExtension(string, object);
        }
    }

    protected Map<String, Model> addDefinitionsForType(String string, Class<?> clazz) {
        Map<String, Model> map = DefinitionsFactory.create(clazz);
        map.forEach((string2, model) -> {
            String string3;
            String string4 = string2.equals(clazz.getSimpleName()) ? (string != null ? string : string2) : (string3 = string2);
            if (!this.hasDefinition(string3)) {
                this.addDefinition(string3, (Model)model);
            }
        });
        return map;
    }

    protected void addOperation(String string, HttpMethod httpMethod, Operation operation) {
        String string2 = ParamsFactory.formatPath(string);
        if (this.paths != null && this.paths.containsKey(string2)) {
            Path path = this.paths.get(string2);
            path.set(httpMethod, operation);
        } else {
            Path path = new Path();
            path.set(httpMethod, operation);
            this.path(string2, path);
        }
    }

    public Swagger vendorExtensions(Map<String, Object> map) {
        if (map == null) {
            return this;
        }
        if (this.vendorExtensions == null) {
            this.vendorExtensions = new LinkedHashMap<String, Object>();
        }
        this.vendorExtensions.putAll(map);
        return this;
    }

    public void setVendorExtensions(Map<String, Object> map) {
        this.vendorExtensions = map;
    }
}

