/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.github.manusant.ss.ApiEndpoint;
import io.github.manusant.ss.Swagger;
import io.github.manusant.ss.SwaggerHammer;
import io.github.manusant.ss.SwaggerSpecBuilder;
import io.github.manusant.ss.conf.IgnoreSpec;
import io.github.manusant.ss.conf.IpResolver;
import io.github.manusant.ss.conf.Options;
import io.github.manusant.ss.conf.TypifyProvider;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.model.Contact;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.model.Info;
import io.github.manusant.ss.model.License;
import io.github.manusant.ss.model.Scheme;
import io.github.manusant.ss.model.SecurityRequirement;
import io.github.manusant.ss.model.auth.SecuritySchemeDefinition;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.rest.EndpointResolver;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ExceptionHandler;
import spark.Filter;
import spark.HaltException;
import spark.Service;

public class SparkSwagger {
    private static final Logger log = LoggerFactory.getLogger(SparkSwagger.class);
    public static final String CONF_FILE_NAME = "spark-swagger.conf";
    private final Swagger swagger;
    private final Service spark;
    private final Config config;
    private final Options options;
    private final String apiPath;

    private SparkSwagger(Service service, Options options) {
        this.spark = service;
        this.options = options == null ? Options.defaultOptions().build() : options;
        this.swagger = new Swagger();
        this.config = this.getConfig(options);
        this.apiPath = this.config.getString("spark-swagger.basePath");
        this.swagger.setBasePath(this.apiPath);
        this.swagger.setExternalDocs(ExternalDocs.newBuilder().build());
        this.swagger.setHost(this.getHost(options.getPort()));
        this.swagger.setInfo(this.getInfo());
        this.configDocRoute();
    }

    private Config getConfig(Options options) {
        Config config = ConfigFactory.parseResources((String)Objects.requireNonNull(options).getConfPath());
        if (!config.hasPath("spark-swagger")) {
            config = ConfigFactory.parseFile((File)new File(Objects.requireNonNull(options).getConfPath()));
        }
        return config;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public Options getOptions() {
        return this.options;
    }

    public Service getSpark() {
        return this.spark;
    }

    public static SparkSwagger of(Service service) {
        return new SparkSwagger(service, Options.defaultOptions().build());
    }

    public static SparkSwagger of(Service service, Options options) {
        Objects.requireNonNull(options);
        return new SparkSwagger(service, options);
    }

    private void configDocRoute() {
        String string = SwaggerHammer.getUiFolder(this.apiPath);
        SwaggerHammer.createDir(SwaggerHammer.getSwaggerUiFolder());
        SwaggerHammer.createDir(string);
        if (this.options.isEnableStaticMapping()) {
            this.enableStaticMapping(string);
        }
        if (this.options.isEnableCors()) {
            this.enableCors();
        }
    }

    private void enableCors() {
        this.spark.options("/*", (request, response) -> {
            String string;
            String string2 = request.headers("Access-Control-Request-Headers");
            if (string2 != null) {
                response.header("Access-Control-Allow-Headers", string2);
            }
            if ((string = request.headers("Access-Control-Request-Method")) != null) {
                response.header("Access-Control-Allow-Methods", string);
            }
            return "OK";
        });
        this.spark.before((request, response) -> response.header("Access-Control-Allow-Origin", "*"));
        log.debug("Spark-Swagger: CORS enabled and allow Origin *");
    }

    private void enableStaticMapping(String string) {
        this.spark.externalStaticFileLocation(string);
        log.debug("Spark-Swagger: UI folder deployed at {}", (Object)string);
    }

    public SparkSwagger ignores(Supplier<IgnoreSpec> supplier) {
        this.swagger.ignores(supplier.get());
        TypifyProvider.setUp(supplier);
        return this;
    }

    public void generateDoc() throws IOException {
        new SwaggerSpecBuilder(this.swagger).build();
        new SwaggerHammer().prepareUi(this.config, this.swagger);
    }

    public ApiEndpoint getEndpoint(String string) {
        if (this.swagger.getApiEndpoints() == null) {
            return null;
        }
        for (ApiEndpoint apiEndpoint : this.swagger.getApiEndpoints()) {
            if (!string.equals(apiEndpoint.getEndpointDescriptor().getTag().getName())) continue;
            return apiEndpoint;
        }
        return null;
    }

    public ApiEndpoint endpoint(EndpointDescriptor.Builder builder) {
        return this.endpoint(builder, null);
    }

    public ApiEndpoint endpoint(EndpointDescriptor.Builder builder, Filter filter) {
        Optional.ofNullable(this.apiPath).orElseThrow(() -> new IllegalStateException("API Path must be specified in order to build REST endpoint"));
        EndpointDescriptor endpointDescriptor = builder.build();
        if (filter != null) {
            this.spark.before(this.apiPath + endpointDescriptor.getPath() + "/*", filter);
        }
        ApiEndpoint apiEndpoint = new ApiEndpoint(this, endpointDescriptor);
        this.swagger.addApiEndpoint(apiEndpoint);
        return apiEndpoint;
    }

    public SparkSwagger endpoint(EndpointDescriptor.Builder builder, Filter filter, Consumer<ApiEndpoint> consumer) {
        Optional.ofNullable(this.apiPath).orElseThrow(() -> new IllegalStateException("API Path must be specified in order to build REST endpoint"));
        EndpointDescriptor endpointDescriptor = builder.build();
        this.spark.before(this.apiPath + endpointDescriptor.getPath() + "/*", filter);
        ApiEndpoint apiEndpoint = new ApiEndpoint(this, endpointDescriptor);
        consumer.accept(apiEndpoint);
        this.swagger.addApiEndpoint(apiEndpoint);
        return this;
    }

    public SparkSwagger endpoint(Endpoint endpoint) {
        Optional.ofNullable(endpoint).orElseThrow(() -> new IllegalStateException("API Endpoint cannot be null"));
        endpoint.bind(this);
        return this;
    }

    public SparkSwagger endpoints(EndpointResolver endpointResolver) {
        Optional.ofNullable(endpointResolver).orElseThrow(() -> new IllegalStateException("API Endpoint Resolver cannot be null"));
        endpointResolver.endpoints().forEach(this::endpoint);
        return this;
    }

    public SparkSwagger before(Filter filter) {
        this.spark.before(this.apiPath + "/*", filter);
        return this;
    }

    public SparkSwagger after(Filter filter) {
        this.spark.after(this.apiPath + "/*", filter);
        return this;
    }

    public synchronized SparkSwagger exception(Class<? extends Exception> clazz, ExceptionHandler exceptionHandler) {
        this.spark.exception(clazz, exceptionHandler);
        return this;
    }

    public HaltException halt() {
        return this.spark.halt();
    }

    public HaltException halt(int n2) {
        return this.spark.halt(n2);
    }

    public HaltException halt(String string) {
        return this.spark.halt(string);
    }

    public HaltException halt(int n2, String string) {
        return this.spark.halt(n2, string);
    }

    public SparkSwagger security(String string, SecuritySchemeDefinition securitySchemeDefinition) {
        return this.security(string, securitySchemeDefinition, Collections.emptyList());
    }

    public SparkSwagger security(String string, SecuritySchemeDefinition securitySchemeDefinition, List<String> list) {
        this.swagger.addSecurityDefinition(string, securitySchemeDefinition);
        this.swagger.addSecurity(new SecurityRequirement().requirement(string, list));
        return this;
    }

    private String getHost(Integer n2) {
        String string = this.config.getString("spark-swagger.host");
        if (string == null) {
            throw new IllegalArgumentException("Host is required");
        }
        if (string.contains("localhost")) {
            String[] stringArray = string.split(":");
            string = stringArray.length != 2 ? string + ":" + n2 : IpResolver.resolvePublicIp() + ":" + stringArray[1];
        }
        log.debug("Spark-Swagger: Host resolved to {}", (Object)string);
        return string;
    }

    private Info getInfo() {
        List<Scheme> list;
        Object object;
        Object object2;
        if (!this.config.hasPath("spark-swagger.info")) {
            throw new IllegalArgumentException("'spark-swagger.info' configuration is required");
        }
        Config config = this.config.getConfig("spark-swagger.info");
        if (this.options.getVersion() == null) {
            if (config.hasPath("version")) {
                this.options.setVersion(config.getString("version"));
            } else if (config.hasPath("project.version")) {
                this.options.setVersion(config.getString("project.version"));
            }
        }
        if (config.hasPath("externalDoc")) {
            object2 = config.getConfig("externalDoc");
            object = ExternalDocs.newBuilder().withDescription(object2.getString("description")).withUrl(object2.getString("url")).build();
            this.swagger.setExternalDocs((ExternalDocs)object);
        }
        object2 = new Info();
        ((Info)object2).description(config.getString("description"));
        ((Info)object2).version(this.options.getVersion());
        ((Info)object2).title(config.getString("title"));
        ((Info)object2).termsOfService(config.getString("termsOfService"));
        if (config.hasPath("schemes")) {
            object = Optional.ofNullable(config.getStringList("schemes")).orElseThrow(() -> new IllegalArgumentException("'spark-swagger.info.schemes' configuration is required"));
            list = object.stream().filter(string -> Scheme.forValue(string) != null).map(Scheme::forValue).collect(Collectors.toList());
            if (list.isEmpty()) {
                throw new IllegalArgumentException("At least one Scheme mus be specified. Use 'spark-swagger.info.schemes' property. spark-swagger.info.schemes =[\"HTTP\"]");
            }
            this.swagger.schemes(list);
        }
        if (config.hasPath("contact")) {
            object = config.getConfig("contact");
            list = new Contact();
            ((Contact)((Object)list)).name(object.getString("name"));
            ((Contact)((Object)list)).email(object.getString("email"));
            ((Contact)((Object)list)).url(object.getString("url"));
            ((Info)object2).setContact((Contact)((Object)list));
        }
        if (config.hasPath("license")) {
            object = config.getConfig("license");
            list = new License();
            ((License)((Object)list)).name(object.getString("name"));
            ((License)((Object)list)).url(object.getString("url"));
            ((Info)object2).setLicense((License)((Object)list));
        }
        return object2;
    }
}

