/*
 * Decompiled with CFR 0.152.
 */
package com.synthbot.jasiohost;

import com.synthbot.jasiohost.AsioChannel;
import com.synthbot.jasiohost.AsioDriver;
import com.synthbot.jasiohost.AsioDriverListener;
import com.synthbot.jasiohost.AsioDriverState;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ExampleHost
extends JFrame
implements AsioDriverListener {
    private static final long serialVersionUID = 1L;
    private AsioDriver asioDriver;
    private Set<AsioChannel> activeChannels = new HashSet<AsioChannel>();
    private int sampleIndex;
    private int bufferSize;
    private double sampleRate;
    private float[] output;

    public ExampleHost() {
        super("JAsioHost Example");
        final JComboBox<Object> jComboBox = new JComboBox<Object>(AsioDriver.getDriverNames().toArray());
        JButton jButton = new JButton("Start");
        JButton jButton2 = new JButton("Stop");
        JButton jButton3 = new JButton("Control Panel");
        final ExampleHost exampleHost = this;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExampleHost.this.asioDriver == null) {
                    ExampleHost.this.asioDriver = AsioDriver.getDriver(jComboBox.getSelectedItem().toString());
                    ExampleHost.this.asioDriver.addAsioDriverListener(exampleHost);
                    ExampleHost.this.activeChannels.add(ExampleHost.this.asioDriver.getChannelOutput(0));
                    ExampleHost.this.activeChannels.add(ExampleHost.this.asioDriver.getChannelOutput(1));
                    ExampleHost.this.sampleIndex = 0;
                    ExampleHost.this.bufferSize = ExampleHost.this.asioDriver.getBufferPreferredSize();
                    ExampleHost.this.sampleRate = ExampleHost.this.asioDriver.getSampleRate();
                    ExampleHost.access$502(ExampleHost.this, new float[ExampleHost.this.bufferSize]);
                    ExampleHost.this.asioDriver.createBuffers(ExampleHost.this.activeChannels);
                    ExampleHost.this.asioDriver.start();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExampleHost.this.asioDriver != null) {
                    ExampleHost.this.asioDriver.shutdownAndUnloadDriver();
                    ExampleHost.this.activeChannels.clear();
                    ExampleHost.this.asioDriver = null;
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExampleHost.this.asioDriver != null && ExampleHost.this.asioDriver.getCurrentState().ordinal() >= AsioDriverState.INITIALIZED.ordinal()) {
                    ExampleHost.this.asioDriver.openControlPanel();
                }
            }
        });
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.add(jComboBox);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.add(jPanel);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (ExampleHost.this.asioDriver != null) {
                    ExampleHost.this.asioDriver.shutdownAndUnloadDriver();
                }
            }
        });
        this.setSize(240, 85);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void bufferSwitch(long l2, long l3, Set<AsioChannel> set) {
        int n2 = 0;
        while (n2 < this.bufferSize) {
            this.output[n2] = (float)Math.sin(Math.PI * 2 * (double)this.sampleIndex * 440.0 / this.sampleRate);
            ++n2;
            ++this.sampleIndex;
        }
        for (AsioChannel asioChannel : set) {
            asioChannel.write(this.output);
        }
    }

    @Override
    public void bufferSizeChanged(int n2) {
        System.out.println("bufferSizeChanged() callback received.");
    }

    @Override
    public void latenciesChanged(int n2, int n3) {
        System.out.println("latenciesChanged() callback received.");
    }

    @Override
    public void resetRequest() {
        new Thread(){

            @Override
            public void run() {
                System.out.println("resetRequest() callback received. Returning driver to INITIALIZED state.");
                ExampleHost.this.asioDriver.returnToState(AsioDriverState.INITIALIZED);
            }
        }.start();
    }

    @Override
    public void resyncRequest() {
        System.out.println("resyncRequest() callback received.");
    }

    @Override
    public void sampleRateDidChange(double d2) {
        System.out.println("sampleRateDidChange() callback received.");
    }

    public static void main(String[] stringArray) {
        ExampleHost exampleHost = new ExampleHost();
    }

    static /* synthetic */ float[] access$502(ExampleHost exampleHost, float[] fArray) {
        exampleHost.output = fArray;
        return fArray;
    }
}

