/*
 * Decompiled with CFR 0.152.
 */
package com.synthbot.jasiohost;

public enum AsioSampleType {
    ASIOSTInt16MSB(0),
    ASIOSTInt24MSB(1),
    ASIOSTInt32MSB(2),
    ASIOSTFloat32MSB(3),
    ASIOSTFloat64MSB(4),
    ASIOSTInt32MSB16(8),
    ASIOSTInt32MSB18(9),
    ASIOSTInt32MSB20(10),
    ASIOSTInt32MSB24(11),
    ASIOSTInt16LSB(16),
    ASIOSTInt24LSB(17),
    ASIOSTInt32LSB(18),
    ASIOSTFloat32LSB(19),
    ASIOSTFloat64LSB(20),
    ASIOSTInt32LSB16(24),
    ASIOSTInt32LSB18(25),
    ASIOSTInt32LSB20(26),
    ASIOSTInt32LSB24(27),
    ASIOSTDSDInt8LSB1(32),
    ASIOSTDSDInt8MSB1(33),
    ASIOSTDSDInt8NER8(40);

    private int nativeEnum;

    private AsioSampleType(int n3) {
        this.nativeEnum = n3;
    }

    public static AsioSampleType getSampleType(int n2) {
        for (AsioSampleType asioSampleType : AsioSampleType.values()) {
            if (asioSampleType.nativeEnum != n2) continue;
            return asioSampleType;
        }
        return null;
    }

    public int bitsPerSample() {
        switch (this) {
            case ASIOSTFloat64MSB: 
            case ASIOSTFloat64LSB: {
                return 64;
            }
            case ASIOSTFloat32MSB: 
            case ASIOSTFloat32LSB: 
            case ASIOSTInt32MSB: 
            case ASIOSTInt32LSB: {
                return 32;
            }
            case ASIOSTInt32MSB16: 
            case ASIOSTInt32LSB16: 
            case ASIOSTInt16MSB: 
            case ASIOSTInt16LSB: {
                return 16;
            }
            case ASIOSTInt32MSB18: 
            case ASIOSTInt32LSB18: {
                return 18;
            }
            case ASIOSTInt32MSB20: 
            case ASIOSTInt32LSB20: {
                return 20;
            }
            case ASIOSTInt32MSB24: 
            case ASIOSTInt32LSB24: 
            case ASIOSTInt24MSB: 
            case ASIOSTInt24LSB: {
                return 24;
            }
        }
        return 16;
    }

    public boolean formatIsInt() {
        switch (this) {
            case ASIOSTFloat64MSB: 
            case ASIOSTFloat64LSB: 
            case ASIOSTFloat32MSB: 
            case ASIOSTFloat32LSB: {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        switch (this) {
            case ASIOSTFloat64MSB: {
                return "Float64M";
            }
            case ASIOSTFloat64LSB: {
                return "Float64L";
            }
            case ASIOSTFloat32MSB: {
                return "Float32M";
            }
            case ASIOSTFloat32LSB: {
                return "Float32L";
            }
            case ASIOSTInt32MSB: {
                return "Int32M";
            }
            case ASIOSTInt32LSB: {
                return "Int32L";
            }
            case ASIOSTInt32MSB16: {
                return "Int32M16";
            }
            case ASIOSTInt32LSB16: {
                return "Int32L16";
            }
            case ASIOSTInt16MSB: {
                return "Int16M";
            }
            case ASIOSTInt16LSB: {
                return "Int16L";
            }
            case ASIOSTInt24MSB: {
                return "Int24M";
            }
            case ASIOSTInt24LSB: {
                return "Int24L";
            }
            case ASIOSTInt32MSB18: {
                return "Int32M18";
            }
            case ASIOSTInt32LSB18: {
                return "Int32L18";
            }
            case ASIOSTInt32MSB20: {
                return "Int32M20";
            }
            case ASIOSTInt32LSB20: {
                return "Int32L20";
            }
            case ASIOSTInt32MSB24: {
                return "Int32M24";
            }
            case ASIOSTInt32LSB24: {
                return "Int32L24";
            }
            case ASIOSTDSDInt8MSB1: {
                return "DSD8M1";
            }
            case ASIOSTDSDInt8LSB1: {
                return "DSD8L1";
            }
            case ASIOSTDSDInt8NER8: {
                return "DSD8N8";
            }
        }
        return "???";
    }
}

