/*
 * Decompiled with CFR 0.152.
 */
package com.synthbot.jasiohost;

import com.synthbot.jasiohost.AsioChannel;
import com.synthbot.jasiohost.AsioDriverInfo;
import com.synthbot.jasiohost.AsioDriverListener;
import com.synthbot.jasiohost.AsioDriverState;
import com.synthbot.jasiohost.AsioException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import roomeqwizard.WizardLogger;

public class AsioDriver {
    private AsioDriverState currentState;
    private final List<AsioDriverListener> listeners;
    private final Set<AsioChannel> activeChannels;
    private final AsioChannel[] inputChannels;
    private final AsioChannel[] outputChannels;
    private final AsioDriverInfo driverInfo;
    private static AsioDriver asioDriver;
    private static final Set<Thread> registeredThreads;

    private AsioDriver(String string) {
        int n2;
        AsioDriver.registerThreadIfNecessary();
        boolean bl = AsioDriver.loadDriver(string);
        if (!bl) {
            throw new AsioException("The driver was not successfully loaded into memory. The Steinberg ASIO API does not indicate why.");
        }
        this.driverInfo = this.ASIOInit();
        this.currentState = AsioDriverState.INITIALIZED;
        this.activeChannels = new HashSet<AsioChannel>();
        asioDriver = this;
        this.listeners = new ArrayList<AsioDriverListener>();
        this.inputChannels = new AsioChannel[AsioDriver.ASIOGetChannels(true)];
        for (n2 = 0; n2 < this.inputChannels.length; ++n2) {
            this.inputChannels[n2] = AsioDriver.ASIOGetChannelInfo(n2, true);
        }
        this.outputChannels = new AsioChannel[AsioDriver.ASIOGetChannels(false)];
        for (n2 = 0; n2 < this.outputChannels.length; ++n2) {
            this.outputChannels[n2] = AsioDriver.ASIOGetChannelInfo(n2, false);
        }
    }

    public static AsioDriver getDriver(String string) {
        if (string == null) {
            throw new NullPointerException("The driver name cannot be null.");
        }
        if (AsioDriver.isDriverLoaded()) {
            if (string.equals(asioDriver.getName())) {
                return asioDriver;
            }
            asioDriver.shutdownAndUnloadDriver();
        }
        if (AsioDriver.getDriverNames().contains(string)) {
            asioDriver = new AsioDriver(string);
            return asioDriver;
        }
        throw new AsioException("The given driver name does not exist in the system registry. Check AsioDriver.getDriverNames().");
    }

    private static void registerThreadIfNecessary() {
        if (registeredThreads.isEmpty()) {
            registeredThreads.add(Thread.currentThread());
        } else if (!registeredThreads.contains(Thread.currentThread())) {
            registeredThreads.add(Thread.currentThread());
            AsioDriver.registerThread();
        }
    }

    private static native void registerThread();

    public static AsioDriver getCurrentDriver() {
        return asioDriver;
    }

    public static boolean isDriverLoaded() {
        return asioDriver != null;
    }

    public static List<String> getDriverNames() {
        AsioDriver.registerThreadIfNecessary();
        String[] stringArray = new String[32];
        int n2 = AsioDriver.getDriverNames(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    private static native int getDriverNames(String[] var0);

    protected void finalize() throws Throwable {
        try {
            this.returnToState(AsioDriverState.UNLOADED);
        }
        finally {
            super.finalize();
        }
    }

    public String getName() {
        return this.driverInfo.getDriverName();
    }

    public int getVersion() {
        return this.driverInfo.getDriverVersion();
    }

    public int getAsioVersion() {
        return this.driverInfo.getAsioVersion();
    }

    public synchronized AsioDriverState getCurrentState() {
        return this.currentState;
    }

    private native AsioDriverInfo ASIOInit();

    public synchronized void exit() {
        if (!AsioDriverState.INITIALIZED.equals((Object)this.currentState)) {
            throw new IllegalStateException("AsioDriver must be in AsioDriverState.INITIALIZED state in order to be initialised. The current state is: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        this.ASIOExit();
        this.currentState = AsioDriverState.LOADED;
    }

    private native void ASIOExit();

    public synchronized void openControlPanel() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOControlPanel();
    }

    private static native void ASIOControlPanel();

    public int getNumChannelsInput() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        return this.inputChannels.length;
    }

    public int getNumChannelsOutput() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        return this.outputChannels.length;
    }

    private static native int ASIOGetChannels(boolean var0);

    public synchronized double getSampleRate() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetSampleRate();
    }

    private static native double ASIOGetSampleRate();

    public synchronized boolean canSampleRate(double d2) {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOCanSampleRate(d2);
    }

    private static native boolean ASIOCanSampleRate(double var0);

    public synchronized void setSampleRate(double d2) {
        if (this.currentState.ordinal() != AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOSetSampleRate(d2);
    }

    private static native void ASIOSetSampleRate(double var0);

    public synchronized int getBufferMinSize() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetBufferSize(0);
    }

    public synchronized int getBufferMaxSize() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetBufferSize(1);
    }

    public synchronized int getBufferPreferredSize() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetBufferSize(2);
    }

    public synchronized int getBufferGranularity() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetBufferSize(3);
    }

    private static native int ASIOGetBufferSize(int var0);

    public synchronized int getLatencyInput() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetLatencies(true);
    }

    public synchronized int getLatencyOutput() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetLatencies(false);
    }

    private static native int ASIOGetLatencies(boolean var0);

    public synchronized AsioChannel getChannelInput(int n2) {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        if (n2 < 0 || n2 >= this.inputChannels.length) {
            throw new IndexOutOfBoundsException("The input index must be in [0," + Integer.toString(this.inputChannels.length) + "): " + Integer.toString(n2));
        }
        return this.inputChannels[n2];
    }

    public synchronized AsioChannel getChannelOutput(int n2) {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        if (n2 < 0 || n2 >= this.outputChannels.length) {
            throw new IndexOutOfBoundsException("The output index must be in [0," + Integer.toString(this.outputChannels.length) + "): " + Integer.toString(n2));
        }
        return this.outputChannels[n2];
    }

    private static native AsioChannel ASIOGetChannelInfo(int var0, boolean var1);

    public synchronized void createBuffers(Set<AsioChannel> set) {
        if (!AsioDriverState.INITIALIZED.equals((Object)this.currentState)) {
            throw new IllegalStateException("The ASIO driver must be in the INITIALIZED state in order to createBuffers().");
        }
        if (set == null) {
            throw new NullPointerException("The set of channels to initialise may not be null.");
        }
        if (set.contains(null)) {
            throw new IllegalArgumentException("The set of channels to initialise may not contain a null value.");
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("The set of channels to initialise may not be empty.");
        }
        this.activeChannels.addAll(set);
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOCreateBuffers(this.activeChannels.toArray(new AsioChannel[0]), this.getBufferPreferredSize());
        this.currentState = AsioDriverState.PREPARED;
    }

    private static native void ASIOCreateBuffers(AsioChannel[] var0, int var1);

    public synchronized void disposeBuffers() {
        if (!AsioDriverState.PREPARED.equals((Object)this.currentState)) {
            throw new IllegalStateException("The ASIO driver must be in the PREPARED state in order to dispose of the audio buffers.");
        }
        for (AsioChannel asioChannel : this.activeChannels) {
            asioChannel.setByteBuffers(null, null);
        }
        this.activeChannels.clear();
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIODisposeBuffers();
        this.currentState = AsioDriverState.INITIALIZED;
    }

    private static native void ASIODisposeBuffers();

    public synchronized void start() {
        if (!AsioDriverState.PREPARED.equals((Object)this.currentState)) {
            throw new IllegalStateException(this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOStart();
        this.currentState = AsioDriverState.RUNNING;
    }

    private static native void ASIOStart();

    public synchronized void stop() {
        if (!AsioDriverState.RUNNING.equals((Object)this.currentState)) {
            throw new IllegalStateException(this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOStop();
        this.currentState = AsioDriverState.PREPARED;
    }

    private static native void ASIOStop();

    private static native boolean loadDriver(String var0);

    private synchronized void unloadDriver() {
        if (!AsioDriverState.LOADED.equals((Object)this.currentState)) {
            throw new IllegalStateException();
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.removeCurrentDriver();
        this.currentState = AsioDriverState.UNLOADED;
        asioDriver = null;
    }

    private static native void removeCurrentDriver();

    public synchronized void shutdownAndUnloadDriver() {
        this.returnToState(AsioDriverState.UNLOADED);
    }

    public synchronized void returnToState(AsioDriverState asioDriverState) {
        if (asioDriverState == null) {
            throw new NullPointerException("Target state may not be null.");
        }
        if (asioDriverState.ordinal() < this.currentState.ordinal()) {
            switch (this.currentState) {
                case RUNNING: {
                    this.stop();
                    if (this.currentState.equals((Object)asioDriverState)) break;
                }
                case PREPARED: {
                    this.disposeBuffers();
                    if (this.currentState.equals((Object)asioDriverState)) break;
                }
                case INITIALIZED: {
                    this.exit();
                    if (this.currentState.equals((Object)asioDriverState)) break;
                }
                case LOADED: {
                    this.unloadDriver();
                    break;
                }
            }
        }
    }

    public synchronized void addAsioDriverListener(AsioDriverListener asioDriverListener) {
        if (this.currentState.ordinal() < AsioDriverState.PREPARED.ordinal()) {
            if (!this.listeners.contains(asioDriverListener)) {
                this.listeners.add(asioDriverListener);
            }
        } else {
            throw new IllegalStateException("AsioDriverListeners can only be updated while the AsioDriver is in the LOADED or INITIALIZED state.");
        }
    }

    public synchronized void removeAsioDriverListener(AsioDriverListener asioDriverListener) {
        if (this.currentState.ordinal() >= AsioDriverState.PREPARED.ordinal()) {
            throw new IllegalStateException("AsioDriverListeners can only be updated while the AsioDriver is in the LOADED or INITIALIZED state.");
        }
        this.listeners.remove(asioDriverListener);
    }

    private void fireSampleRateDidChange(double d2) {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.sampleRateDidChange(d2);
        }
    }

    private void fireResetRequest() {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.resetRequest();
        }
    }

    private void fireResyncRequest() {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.resyncRequest();
        }
    }

    private void fireBufferSizeChanged(int n2) {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.bufferSizeChanged(n2);
        }
    }

    private void fireLatenciesChanged(int n2, int n3) {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.latenciesChanged(n2, n3);
        }
    }

    private void fireBufferSwitch(long l2, long l3, int n2) {
        for (AsioChannel asioChannel : this.activeChannels) {
            asioChannel.setBufferIndex(n2);
        }
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            this.listeners.get(i2).bufferSwitch(l2, l3, this.activeChannels);
        }
    }

    static {
        String string = System.getProperty("sun.arch.data.model");
        if (string.equals("64")) {
            System.loadLibrary("jasiohost64");
            WizardLogger.getLogger().log(Level.INFO, "Loaded jasiohost64.dll");
        } else {
            System.loadLibrary("jasiohost");
            WizardLogger.getLogger().log(Level.INFO, "Loaded jasiohost.dll");
        }
        registeredThreads = new HashSet<Thread>();
    }
}

