/*
 * Decompiled with CFR 0.152.
 */
package com.synthbot.jasiohost;

import com.synthbot.jasiohost.AsioSampleType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import roomeqwizard.sD;

public class AsioChannel {
    private final int index;
    private final boolean isInput;
    private volatile boolean isActive;
    private final int channelGroup;
    private final AsioSampleType sampleType;
    private final String name;
    private final ByteBuffer[] nativeBuffers;
    private volatile int bufferIndex;
    private boolean treat32As24 = false;
    private int firstWord;
    private int bitsChanged;
    private static final float MAX_INT16 = 32767.0f;
    private static final float MAX_INT18 = 131071.0f;
    private static final long MAX_INT20 = 524287L;
    private static final long MAX_INT24 = 0x7FFFFFL;
    private static final float INV_INT16 = 3.0517578E-5f;
    private static final float INV_INT18 = 7.6293945E-6f;
    private static final float INV_INT20 = 1.9073486E-6f;
    private static final float INV_INT24 = 1.1920929E-7f;
    private static final double INV_INT32 = 4.656612873077393E-10;
    private static int fpd = 17;

    static float ditherFloat(long l2, long l3, double d2, double d3) {
        d2 *= (double)l2;
        if (d3 > 0.0) {
            int n2;
            double d4;
            fpd ^= fpd << 13;
            fpd ^= fpd >>> 17;
            if ((d2 += d3 * (d4 = (double)(fpd ^= fpd << 5) * 6.8E-36 * Math.pow(2.0, (n2 = Math.getExponent(d2)) + 62))) > (double)l3) {
                d2 = l3;
            } else if (d2 < (double)(-l3)) {
                d2 = -l3;
            }
        }
        return (float)d2;
    }

    private AsioChannel(int n2, boolean bl, boolean bl2, int n3, AsioSampleType asioSampleType, String string) {
        this.index = n2;
        this.isInput = bl;
        this.isActive = bl2;
        this.channelGroup = n3;
        this.sampleType = asioSampleType;
        this.name = string;
        this.nativeBuffers = new ByteBuffer[2];
        this.firstWord = 0;
        this.bitsChanged = 0;
    }

    public int getBitDepth() {
        return 32 - (int)Math.round(Math.log(Integer.lowestOneBit(this.bitsChanged)) / Math.log(2.0));
    }

    public int getBitsChanged() {
        return this.bitsChanged;
    }

    public int getFirstWord() {
        return this.firstWord;
    }

    public void clearBitDetection() {
        this.firstWord = 0;
        this.bitsChanged = 0;
    }

    public void setTreat32As24(boolean bl) {
        this.treat32As24 = bl;
    }

    public boolean getTreat32As24() {
        return this.treat32As24;
    }

    public int getChannelIndex() {
        return this.index;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getChannelGroup() {
        return this.channelGroup;
    }

    public AsioSampleType getSampleType() {
        return this.sampleType;
    }

    public String getChannelName() {
        return this.name;
    }

    public ByteBuffer getByteBuffer() {
        return this.nativeBuffers[this.bufferIndex];
    }

    protected void setBufferIndex(int n2) {
        this.bufferIndex = n2;
        this.nativeBuffers[n2].rewind();
    }

    protected void setByteBuffers(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer == null || byteBuffer2 == null) {
            this.isActive = false;
            this.nativeBuffers[0] = null;
            this.nativeBuffers[1] = null;
        } else {
            this.nativeBuffers[0] = this.isInput ? byteBuffer.asReadOnlyBuffer() : byteBuffer;
            ByteBuffer byteBuffer3 = this.nativeBuffers[1] = this.isInput ? byteBuffer2.asReadOnlyBuffer() : byteBuffer2;
            if (this.sampleType.name().contains("MSB")) {
                this.nativeBuffers[0].order(ByteOrder.BIG_ENDIAN);
                this.nativeBuffers[1].order(ByteOrder.BIG_ENDIAN);
            } else {
                this.nativeBuffers[0].order(ByteOrder.LITTLE_ENDIAN);
                this.nativeBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
            }
            this.isActive = true;
        }
    }

    public void write(float[] fArray) {
        if (this.isInput) {
            throw new IllegalStateException("Only output channels can be written to.");
        }
        if (!this.isActive) {
            throw new IllegalStateException("This channel is not active: " + this.toString());
        }
        ByteBuffer byteBuffer = this.getByteBuffer();
        double d2 = sD._();
        switch (this.sampleType) {
            case ASIOSTFloat64MSB: 
            case ASIOSTFloat64LSB: {
                for (float f2 : fArray) {
                    byteBuffer.putDouble(f2);
                }
                break;
            }
            case ASIOSTFloat32MSB: 
            case ASIOSTFloat32LSB: {
                for (float f3 : fArray) {
                    byteBuffer.putFloat(f3);
                }
                break;
            }
            case ASIOSTInt32MSB: 
            case ASIOSTInt32LSB: {
                if (this.treat32As24) {
                    for (float f4 : fArray) {
                        byteBuffer.putInt((int)Math.rint(AsioChannel.ditherFloat(0x800000L, 0x7FFFFFL, f4, d2)) << 8);
                    }
                } else {
                    for (float f5 : fArray) {
                        byteBuffer.putInt((int)Math.rint(AsioChannel.ditherFloat(0x80000000L, Integer.MAX_VALUE, f5, d2)));
                    }
                }
                break;
            }
            case ASIOSTInt32MSB16: 
            case ASIOSTInt32LSB16: {
                for (float f6 : fArray) {
                    byteBuffer.putInt((int)(f6 * 32767.0f));
                }
                break;
            }
            case ASIOSTInt32MSB18: 
            case ASIOSTInt32LSB18: {
                for (float f7 : fArray) {
                    byteBuffer.putInt((int)(f7 * 131071.0f));
                }
                break;
            }
            case ASIOSTInt32MSB20: 
            case ASIOSTInt32LSB20: {
                for (float f8 : fArray) {
                    byteBuffer.putInt((int)Math.rint(f8 * 524287.0f));
                }
                break;
            }
            case ASIOSTInt32MSB24: 
            case ASIOSTInt32LSB24: {
                for (float f9 : fArray) {
                    byteBuffer.putInt((int)Math.rint(AsioChannel.ditherFloat(0x800000L, 0x7FFFFFL, f9, d2)));
                }
                break;
            }
            case ASIOSTInt16MSB: 
            case ASIOSTInt16LSB: {
                for (float f10 : fArray) {
                    byteBuffer.putShort((short)(f10 * 32767.0f));
                }
                break;
            }
            case ASIOSTInt24MSB: {
                for (float f11 : fArray) {
                    int n2 = (int)Math.rint(AsioChannel.ditherFloat(0x800000L, 0x7FFFFFL, f11, d2));
                    byteBuffer.put((byte)(n2 >> 16 & 0xFF));
                    byteBuffer.put((byte)(n2 >> 8 & 0xFF));
                    byteBuffer.put((byte)(n2 & 0xFF));
                }
                break;
            }
            case ASIOSTInt24LSB: {
                for (float f12 : fArray) {
                    int n3 = (int)Math.rint(AsioChannel.ditherFloat(0x800000L, 0x7FFFFFL, f12, d2));
                    byteBuffer.put((byte)(n3 & 0xFF));
                    byteBuffer.put((byte)(n3 >> 8 & 0xFF));
                    byteBuffer.put((byte)(n3 >> 16 & 0xFF));
                }
                break;
            }
            case ASIOSTDSDInt8MSB1: 
            case ASIOSTDSDInt8LSB1: 
            case ASIOSTDSDInt8NER8: {
                throw new IllegalStateException("The sample types ASIOSTDSDInt8MSB1, ASIOSTDSDInt8LSB1, and ASIOSTDSDInt8NER8 are not supported.");
            }
        }
    }

    public void read(float[] fArray) {
        if (!this.isInput) {
            throw new IllegalStateException("Only input channels can be read from.");
        }
        if (!this.isActive) {
            throw new IllegalStateException("This channel is not active: " + this.toString());
        }
        ByteBuffer byteBuffer = this.getByteBuffer();
        switch (this.sampleType) {
            case ASIOSTFloat64MSB: 
            case ASIOSTFloat64LSB: {
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    fArray[i2] = (float)byteBuffer.getDouble();
                }
                break;
            }
            case ASIOSTFloat32MSB: 
            case ASIOSTFloat32LSB: {
                for (int i3 = 0; i3 < fArray.length; ++i3) {
                    fArray[i3] = byteBuffer.getFloat();
                }
                break;
            }
            case ASIOSTInt32MSB: 
            case ASIOSTInt32LSB: {
                for (int i4 = 0; i4 < fArray.length; ++i4) {
                    int n2 = byteBuffer.getInt();
                    if (this.firstWord == 0 && n2 != 0) {
                        this.firstWord = n2;
                    }
                    if (this.firstWord != 0) {
                        this.bitsChanged |= n2 ^ this.firstWord;
                    }
                    fArray[i4] = (float)((double)n2 * 4.656612873077393E-10);
                }
                break;
            }
            case ASIOSTInt32MSB16: 
            case ASIOSTInt32LSB16: {
                for (int i5 = 0; i5 < fArray.length; ++i5) {
                    int n3 = byteBuffer.getInt() << 16;
                    if (this.firstWord == 0 && n3 != 0) {
                        this.firstWord = n3;
                    }
                    if (this.firstWord != 0) {
                        this.bitsChanged |= n3 ^ this.firstWord;
                    }
                    fArray[i5] = (float)((double)n3 * 4.656612873077393E-10);
                }
                break;
            }
            case ASIOSTInt32MSB18: 
            case ASIOSTInt32LSB18: {
                for (int i6 = 0; i6 < fArray.length; ++i6) {
                    int n4 = byteBuffer.getInt() << 14;
                    if (this.firstWord == 0 && n4 != 0) {
                        this.firstWord = n4;
                    }
                    if (this.firstWord != 0) {
                        this.bitsChanged |= n4 ^ this.firstWord;
                    }
                    fArray[i6] = (float)((double)n4 * 4.656612873077393E-10);
                }
                break;
            }
            case ASIOSTInt32MSB20: 
            case ASIOSTInt32LSB20: {
                for (int i7 = 0; i7 < fArray.length; ++i7) {
                    int n5 = byteBuffer.getInt() << 12;
                    if (this.firstWord == 0 && n5 != 0) {
                        this.firstWord = n5;
                    }
                    if (this.firstWord != 0) {
                        this.bitsChanged |= n5 ^ this.firstWord;
                    }
                    fArray[i7] = (float)((double)n5 * 4.656612873077393E-10);
                }
                break;
            }
            case ASIOSTInt32MSB24: 
            case ASIOSTInt32LSB24: {
                for (int i8 = 0; i8 < fArray.length; ++i8) {
                    int n6 = byteBuffer.getInt() << 8;
                    if (this.firstWord == 0 && n6 != 0) {
                        this.firstWord = n6;
                    }
                    if (this.firstWord != 0) {
                        this.bitsChanged |= n6 ^ this.firstWord;
                    }
                    fArray[i8] = (float)((double)n6 * 4.656612873077393E-10);
                }
                break;
            }
            case ASIOSTInt16MSB: 
            case ASIOSTInt16LSB: {
                for (int i9 = 0; i9 < fArray.length; ++i9) {
                    short s2 = byteBuffer.getShort();
                    if (this.firstWord == 0 && s2 != 0) {
                        this.firstWord = s2 << 16;
                    }
                    if (this.firstWord != 0) {
                        this.bitsChanged |= s2 << 16 ^ this.firstWord;
                    }
                    fArray[i9] = (float)s2 * 3.0517578E-5f;
                }
                break;
            }
            case ASIOSTInt24MSB: {
                for (int i10 = 0; i10 < fArray.length; ++i10) {
                    int n7 = byteBuffer.get() & 0xFFFF;
                    n7 <<= 8;
                    n7 |= byteBuffer.get() & 0xFF;
                    n7 <<= 8;
                    if (this.firstWord == 0 && (n7 |= byteBuffer.get() & 0xFF) != 0) {
                        this.firstWord = n7 << 8;
                    }
                    if (this.firstWord != 0) {
                        this.bitsChanged |= n7 << 8 ^ this.firstWord;
                    }
                    fArray[i10] = (float)n7 * 1.1920929E-7f;
                }
                break;
            }
            case ASIOSTInt24LSB: {
                for (int i11 = 0; i11 < fArray.length; ++i11) {
                    int n8 = byteBuffer.get() & 0xFF;
                    n8 |= (byteBuffer.get() & 0xFF) << 8;
                    if (this.firstWord == 0 && (n8 |= (byteBuffer.get() & 0xFFFF) << 16) != 0) {
                        this.firstWord = n8 << 8;
                    }
                    if (this.firstWord != 0) {
                        this.bitsChanged |= n8 << 8 ^ this.firstWord;
                    }
                    fArray[i11] = (float)n8 * 1.1920929E-7f;
                }
                break;
            }
            case ASIOSTDSDInt8MSB1: 
            case ASIOSTDSDInt8LSB1: 
            case ASIOSTDSDInt8NER8: {
                throw new IllegalStateException("The sample types ASIOSTDSDInt8MSB1, ASIOSTDSDInt8LSB1, and ASIOSTDSDInt8NER8 are not supported.");
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof AsioChannel)) {
            return false;
        }
        AsioChannel asioChannel = (AsioChannel)object;
        return asioChannel.getChannelIndex() == this.index && asioChannel.isInput() == this.isInput;
    }

    public int hashCode() {
        return this.isInput ? this.index : ~this.index + 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isInput ? "Input" : "Output");
        stringBuilder.append(" Channel ");
        stringBuilder.append(Integer.toString(this.index));
        stringBuilder.append(": ");
        stringBuilder.append(this.name);
        stringBuilder.append(", ");
        stringBuilder.append(this.sampleType.toString());
        stringBuilder.append(", group ");
        stringBuilder.append(Integer.toString(this.channelGroup));
        stringBuilder.append(", ");
        stringBuilder.append(this.isActive ? "active" : "inactive");
        return stringBuilder.toString();
    }
}

