/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import ca.odell.glazedlists.swing.TreeTableCellPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class TreeTableUtilities {
    static int rowAtPoint(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        return jTable.rowAtPoint(point);
    }

    public static TreeTableCellPanel prepareRenderer(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        int n2 = jTable.rowAtPoint(point);
        int n3 = jTable.columnAtPoint(point);
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        Rectangle rectangle = jTable.getCellRect(n2, n3, true);
        Component component = jTable.prepareRenderer(jTable.getCellRenderer(n2, n3), n2, n3);
        if (!(component instanceof TreeTableCellPanel)) {
            return null;
        }
        TreeTableCellPanel treeTableCellPanel = (TreeTableCellPanel)component;
        treeTableCellPanel.setBounds(rectangle);
        treeTableCellPanel.doLayout();
        return treeTableCellPanel;
    }

    static Runnable toggleExpansion(JTable jTable, TreeList treeList, int n2) {
        RestoreStateRunnable restoreStateRunnable = new RestoreStateRunnable(jTable);
        AdvancedListSelectionModel advancedListSelectionModel = restoreStateRunnable.getEventSelectionModel();
        if (advancedListSelectionModel != null) {
            advancedListSelectionModel.setEnabled(false);
        }
        jTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        treeList.toggleExpanded(n2);
        return restoreStateRunnable;
    }

    private static class RestoreStateRunnable
    implements Runnable {
        private final JTable table;
        private final Boolean autoStartsEdit;
        private final AdvancedListSelectionModel eventSelectionModel;
        private final boolean eventSelectionModelEnabled;

        public RestoreStateRunnable(JTable jTable) {
            this.table = jTable;
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            this.eventSelectionModel = listSelectionModel instanceof AdvancedListSelectionModel ? (AdvancedListSelectionModel)listSelectionModel : null;
            this.eventSelectionModelEnabled = this.eventSelectionModel != null && this.eventSelectionModel.getEnabled();
            this.autoStartsEdit = (Boolean)jTable.getClientProperty("JTable.autoStartsEdit");
        }

        public AdvancedListSelectionModel getEventSelectionModel() {
            return this.eventSelectionModel;
        }

        @Override
        public void run() {
            this.table.putClientProperty("JTable.autoStartsEdit", this.autoStartsEdit);
            if (this.eventSelectionModel != null) {
                this.eventSelectionModel.setEnabled(this.eventSelectionModelEnabled);
            }
        }
    }
}

