/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.TreeTableCellEditor;
import ca.odell.glazedlists.swing.TreeTableCellPanel;
import ca.odell.glazedlists.swing.TreeTableCellRenderer;
import ca.odell.glazedlists.swing.TreeTableUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class TreeTableSupport {
    private static final ListSelectionModel NOOP_SELECTION_MODEL = new NoopColumnSelectionModel();
    private static final ListEventListener SWING_THREAD_CHECKER = new EventDispathThreadChecker();
    private final JTable table;
    private final TreeList treeList;
    private final int hierarchyColumnModelIndex;
    private final KeyListener expandAndCollapseKeyListener = new ExpandAndCollapseKeyListener();
    private final KeyListener arrowKeyListener = new ArrowKeyListener();
    private boolean arrowKeyExpansionEnabled;
    private boolean spaceKeyExpansionEnabled = true;
    private ListSelectionModel originalColumnSelectionModel;
    private boolean showExpanderForEmptyParent;
    private TreeTableCellRenderer treeTableCellRenderer;
    private TreeTableCellEditor treeTableCellEditor;
    private final TableCellRenderer originalRenderer;
    private final TableCellEditor originalEditor;

    private TreeTableSupport(JTable jTable, TreeList treeList, int n2) {
        this.table = jTable;
        this.treeList = treeList;
        this.hierarchyColumnModelIndex = n2;
        int n3 = jTable.convertColumnIndexToView(n2);
        if (n3 == -1) {
            throw new IllegalArgumentException("Unable to locate a view index for the given model index: " + n2);
        }
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n3);
        this.originalRenderer = tableColumn.getCellRenderer();
        this.treeTableCellRenderer = new TreeTableCellRenderer(this.originalRenderer, treeList);
        tableColumn.setCellRenderer(this.treeTableCellRenderer);
        this.originalEditor = tableColumn.getCellEditor();
        this.treeTableCellEditor = new TreeTableCellEditor(this.originalEditor, treeList);
        tableColumn.setCellEditor(this.treeTableCellEditor);
        this.table.addKeyListener(this.arrowKeyListener);
        this.table.addKeyListener(this.expandAndCollapseKeyListener);
        this.decorateUIDelegateMouseListener(this.table);
        this.treeList.addListEventListener(SWING_THREAD_CHECKER);
    }

    private void decorateUIDelegateMouseListener(Component component) {
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        for (int i2 = mouseListenerArray.length - 1; i2 >= 0; --i2) {
            if (mouseListenerArray[i2].getClass().getName().indexOf("TableUI") == -1) continue;
            component.removeMouseListener(mouseListenerArray[i2]);
            component.addMouseListener(new ExpandAndCollapseMouseListener(mouseListenerArray[i2]));
            break;
        }
    }

    private void undecorateUIDelegateMouseListener(Component component) {
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        for (int i2 = 0; i2 < mouseListenerArray.length; ++i2) {
            if (!(mouseListenerArray[i2] instanceof ExpandAndCollapseMouseListener)) continue;
            component.removeMouseListener(mouseListenerArray[i2]);
            component.addMouseListener(((ExpandAndCollapseMouseListener)mouseListenerArray[i2]).getDelegate());
        }
    }

    public static TreeTableSupport install(JTable jTable, TreeList treeList, int n2) {
        TreeTableSupport.checkAccessThread();
        return new TreeTableSupport(jTable, treeList, n2);
    }

    public void uninstall() {
        TreeTableSupport.checkAccessThread();
        this.treeList.removeListEventListener(SWING_THREAD_CHECKER);
        this.setArrowKeyExpansionEnabled(false);
        this.table.removeKeyListener(this.arrowKeyListener);
        this.table.removeKeyListener(this.expandAndCollapseKeyListener);
        this.undecorateUIDelegateMouseListener(this.table);
        int n2 = this.table.convertColumnIndexToView(this.hierarchyColumnModelIndex);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellRenderer == this.treeTableCellRenderer) {
            tableColumn.setCellRenderer(this.originalRenderer);
        }
        if (tableCellEditor == this.treeTableCellEditor) {
            tableColumn.setCellEditor(this.originalEditor);
        }
        this.treeTableCellRenderer.dispose();
        this.treeTableCellEditor.dispose();
    }

    public void setShowExpanderForEmptyParent(boolean bl) {
        TreeTableSupport.checkAccessThread();
        if (this.showExpanderForEmptyParent == bl) {
            return;
        }
        this.showExpanderForEmptyParent = bl;
        this.treeTableCellRenderer.setShowExpanderForEmptyParent(bl);
        this.treeTableCellEditor.setShowExpanderForEmptyParent(bl);
        this.table.repaint();
    }

    public boolean getShowExpanderForEmptyParent() {
        return this.showExpanderForEmptyParent;
    }

    public void setArrowKeyExpansionEnabled(boolean bl) {
        TreeTableSupport.checkAccessThread();
        if (this.arrowKeyExpansionEnabled == bl) {
            return;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (bl) {
            this.originalColumnSelectionModel = tableColumnModel.getSelectionModel();
            tableColumnModel.setSelectionModel(NOOP_SELECTION_MODEL);
        } else {
            if (tableColumnModel.getSelectionModel() == NOOP_SELECTION_MODEL) {
                tableColumnModel.setSelectionModel(this.originalColumnSelectionModel);
            }
            this.originalColumnSelectionModel = null;
        }
        this.arrowKeyExpansionEnabled = bl;
    }

    public boolean getArrowKeyExpansionEnabled() {
        return this.arrowKeyExpansionEnabled;
    }

    public boolean getSpaceKeyExpansionEnabled() {
        return this.spaceKeyExpansionEnabled;
    }

    public void setSpaceKeyExpansionEnabled(boolean bl) {
        TreeTableSupport.checkAccessThread();
        this.spaceKeyExpansionEnabled = bl;
    }

    public void setRenderer(TreeTableCellRenderer treeTableCellRenderer) {
        TreeTableSupport.checkAccessThread();
        int n2 = this.table.convertColumnIndexToView(this.hierarchyColumnModelIndex);
        if (n2 == -1) {
            throw new IllegalArgumentException("Unable to locate a view index for the given model index: " + this.hierarchyColumnModelIndex);
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        this.treeTableCellRenderer.dispose();
        this.treeTableCellRenderer = treeTableCellRenderer;
        treeTableCellRenderer.setShowExpanderForEmptyParent(this.showExpanderForEmptyParent);
        tableColumn.setCellRenderer(treeTableCellRenderer);
    }

    public TreeTableCellRenderer getRenderer() {
        return this.treeTableCellRenderer;
    }

    public void setDelegateRenderer(TableCellRenderer tableCellRenderer) {
        TreeTableSupport.checkAccessThread();
        this.treeTableCellRenderer.setDelegate(tableCellRenderer);
    }

    public TableCellRenderer getDelegateRenderer() {
        return this.treeTableCellRenderer.getDelegate();
    }

    public void setEditor(TreeTableCellEditor treeTableCellEditor) {
        TreeTableSupport.checkAccessThread();
        int n2 = this.table.convertColumnIndexToView(this.hierarchyColumnModelIndex);
        if (n2 == -1) {
            throw new IllegalArgumentException("Unable to locate a view index for the given model index: " + this.hierarchyColumnModelIndex);
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        this.treeTableCellEditor.dispose();
        this.treeTableCellEditor = treeTableCellEditor;
        treeTableCellEditor.setShowExpanderForEmptyParent(this.showExpanderForEmptyParent);
        tableColumn.setCellEditor(treeTableCellEditor);
    }

    public TreeTableCellEditor getEditor() {
        return this.treeTableCellEditor;
    }

    public void setDelegateEditor(TableCellEditor tableCellEditor) {
        TreeTableSupport.checkAccessThread();
        this.treeTableCellEditor.setDelegate(tableCellEditor);
    }

    public TableCellEditor getDelegateEditor() {
        return this.treeTableCellEditor.getDelegate();
    }

    private static void checkAccessThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("TreeTableSupport must be accessed from the Swing Event Dispatch Thread, but was called on Thread \"" + Thread.currentThread().getName() + "\"");
        }
    }

    private static class NoopColumnSelectionModel
    implements ListSelectionModel {
        private NoopColumnSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int n2, int n3) {
        }

        @Override
        public void addSelectionInterval(int n2, int n3) {
        }

        @Override
        public void removeSelectionInterval(int n2, int n3) {
        }

        @Override
        public int getMinSelectionIndex() {
            return -1;
        }

        @Override
        public int getMaxSelectionIndex() {
            return -1;
        }

        @Override
        public boolean isSelectedIndex(int n2) {
            return false;
        }

        @Override
        public int getAnchorSelectionIndex() {
            return -1;
        }

        @Override
        public void setAnchorSelectionIndex(int n2) {
        }

        @Override
        public int getLeadSelectionIndex() {
            return -1;
        }

        @Override
        public void setLeadSelectionIndex(int n2) {
        }

        @Override
        public void clearSelection() {
        }

        @Override
        public boolean isSelectionEmpty() {
            return true;
        }

        @Override
        public void insertIndexInterval(int n2, int n3, boolean bl) {
        }

        @Override
        public void removeIndexInterval(int n2, int n3) {
        }

        @Override
        public void setValueIsAdjusting(boolean bl) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }

        @Override
        public void setSelectionMode(int n2) {
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        @Override
        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        }
    }

    private static class EventDispathThreadChecker
    implements ListEventListener {
        private EventDispathThreadChecker() {
        }

        public void listChanged(ListEvent listEvent) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("TreeTableSupport has detected that its underlying TreeList was changed on a Thread that is NOT the Swing Event Dispatch Thread. This can cause unreliable results including sporadic exceptions since the TreeList is read from the EDT. Two solutions exist for this problem:\n\na) ensure each and every write to the EventList pipeline occurs on the Swing EDT\nb) wrap the source EventList of TreeList in a Swing Thread Proxy List using GlazedListsSwing.swingThreadProxyList(...) before passing it to the TreeList constructor");
            }
        }
    }

    private class ArrowKeyListener
    extends KeyAdapter {
        private ArrowKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            if (!TreeTableSupport.this.arrowKeyExpansionEnabled) {
                return;
            }
            if (!TreeTableSupport.this.table.isEnabled()) {
                return;
            }
            if (TreeTableSupport.this.table.getColumnSelectionAllowed()) {
                return;
            }
            int n2 = keyEvent.getKeyCode();
            boolean bl2 = n2 == 37;
            boolean bl3 = bl = n2 == 39;
            if (!bl2 && !bl || keyEvent.getModifiers() != 0) {
                return;
            }
            int n3 = TreeTableSupport.this.table.getSelectionModel().getLeadSelectionIndex();
            if (n3 == -1) {
                return;
            }
            TreeTableSupport.this.treeList.getReadWriteLock().writeLock().lock();
            try {
                boolean bl4;
                if (TreeTableSupport.this.treeList.getAllowsChildren(n3) && ((bl4 = TreeTableSupport.this.treeList.isExpanded(n3)) && bl2 || !bl4 && bl)) {
                    TreeTableUtilities.toggleExpansion(TreeTableSupport.this.table, TreeTableSupport.this.treeList, n3).run();
                }
            }
            finally {
                TreeTableSupport.this.treeList.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    private class ExpandAndCollapseKeyListener
    extends KeyAdapter {
        private Runnable restoreStateRunnable;

        private ExpandAndCollapseKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!TreeTableSupport.this.getSpaceKeyExpansionEnabled()) {
                return;
            }
            if (!TreeTableSupport.this.table.isEnabled()) {
                return;
            }
            if (!TreeTableSupport.this.table.isFocusOwner()) {
                return;
            }
            if (keyEvent.getKeyCode() != 32 || keyEvent.getModifiers() != 0) {
                return;
            }
            int n2 = TreeTableSupport.this.table.getSelectionModel().getLeadSelectionIndex();
            int n3 = TreeTableSupport.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n2 == -1) {
                return;
            }
            if (n3 != -1 && TreeTableSupport.this.table.convertColumnIndexToModel(n3) != TreeTableSupport.this.hierarchyColumnModelIndex) {
                return;
            }
            TreeTableSupport.this.treeList.getReadWriteLock().writeLock().lock();
            try {
                if (TreeTableSupport.this.treeList.getAllowsChildren(n2)) {
                    Runnable runnable = TreeTableUtilities.toggleExpansion(TreeTableSupport.this.table, TreeTableSupport.this.treeList, n2);
                    if (this.restoreStateRunnable == null) {
                        this.restoreStateRunnable = runnable;
                    }
                }
            }
            finally {
                TreeTableSupport.this.treeList.getReadWriteLock().writeLock().unlock();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.restoreStateRunnable != null) {
                this.restoreStateRunnable.run();
                this.restoreStateRunnable = null;
            }
        }
    }

    private class ExpandAndCollapseMouseListener
    implements MouseListener {
        private final MouseListener delegate;

        public ExpandAndCollapseMouseListener(MouseListener mouseListener) {
            if (mouseListener == null) {
                throw new IllegalArgumentException("delegate may not be null");
            }
            this.delegate = mouseListener;
        }

        public MouseListener getDelegate() {
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!TreeTableSupport.this.table.isEnabled()) {
                return;
            }
            JTable jTable = (JTable)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n2 = jTable.rowAtPoint(point);
            int n3 = jTable.columnAtPoint(point);
            if (n2 == -1 || n3 == -1) {
                return;
            }
            Rectangle rectangle = jTable.getCellRect(n2, n3, true);
            point.translate(-rectangle.x, -rectangle.y);
            TreeTableCellPanel treeTableCellPanel = TreeTableUtilities.prepareRenderer(mouseEvent);
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && treeTableCellPanel != null && treeTableCellPanel.isPointOverExpanderButton(point)) {
                TreeTableSupport.this.treeList.getReadWriteLock().writeLock().lock();
                try {
                    if (TreeTableSupport.this.treeList.getAllowsChildren(n2)) {
                        TreeTableUtilities.toggleExpansion(jTable, TreeTableSupport.this.treeList, n2).run();
                    }
                }
                finally {
                    TreeTableSupport.this.treeList.getReadWriteLock().writeLock().unlock();
                }
                return;
            }
            this.delegate.mousePressed(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.delegate.mouseClicked(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.delegate.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.delegate.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.delegate.mouseExited(mouseEvent);
        }
    }
}

