/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.swing.TreeNodeData;
import ca.odell.glazedlists.swing.TreeTableCellPanel;
import ca.odell.glazedlists.swing.TreeTableNodeDataRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TreeTableCellRenderer
implements TableCellRenderer {
    private final TreeTableCellPanel component = new TreeTableCellPanel();
    private TableCellRenderer delegate;
    private TreeList treeList;
    private boolean showExpanderForEmptyParent;
    private final TreeNodeData treeNodeData = new TreeNodeData();

    public TreeTableCellRenderer(TableCellRenderer tableCellRenderer, TreeList treeList) {
        this.delegate = tableCellRenderer == null ? this.createDelegateRenderer() : tableCellRenderer;
        this.treeList = treeList;
    }

    protected TableCellRenderer createDelegateRenderer() {
        return new DefaultTableCellRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        this.treeList.getReadWriteLock().readLock().lock();
        try {
            this.treeNodeData.setDepth(this.treeList.depth(n2));
            this.treeNodeData.setExpanded(this.treeList.isExpanded(n2));
            this.treeNodeData.setHasChildren(this.treeList.hasChildren(n2));
            this.treeNodeData.setAllowsChildren(this.treeList.getAllowsChildren(n2));
        }
        finally {
            this.treeList.getReadWriteLock().readLock().unlock();
        }
        if (this.delegate instanceof TreeTableNodeDataRenderer) {
            ((TreeTableNodeDataRenderer)this.delegate).setTreeNodeData(this.treeNodeData);
        }
        Component component = this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
        int n4 = this.getIndent(this.treeNodeData, this.showExpanderForEmptyParent);
        int n5 = this.getSpacer(this.treeNodeData, this.showExpanderForEmptyParent);
        this.component.configure(this.treeNodeData, this.showExpanderForEmptyParent, component, bl2, n4, n5);
        return this.component;
    }

    protected int getIndent(TreeNodeData treeNodeData, boolean bl) {
        return UIManager.getIcon("Tree.expandedIcon").getIconWidth() * treeNodeData.getDepth();
    }

    protected int getSpacer(TreeNodeData treeNodeData, boolean bl) {
        return 2;
    }

    void setShowExpanderForEmptyParent(boolean bl) {
        this.showExpanderForEmptyParent = bl;
    }

    void setDelegate(TableCellRenderer tableCellRenderer) {
        this.delegate = tableCellRenderer;
    }

    public TableCellRenderer getDelegate() {
        return this.delegate;
    }

    public void dispose() {
        this.delegate = null;
        this.treeList = null;
    }
}

