/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.swing.TreeNodeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TreeTableCellPanel
extends JPanel {
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private final Map<Integer, Component> spacerComponentsCache = new HashMap<Integer, Component>();
    private final JButton expanderButton = new JButton();
    private Component nodeComponent;

    public TreeTableCellPanel() {
        super(new TreeTableCellLayout());
        this.expanderButton.setBorder(BorderFactory.createEmptyBorder());
        this.expanderButton.setContentAreaFilled(false);
        this.expanderButton.setFocusable(false);
    }

    public void configure(TreeNodeData treeNodeData, boolean bl, Component component, boolean bl2, int n2, int n3) {
        boolean bl3;
        boolean bl4 = bl3 = treeNodeData.hasChildren() || treeNodeData.allowsChildren() && bl;
        if (bl3) {
            this.expanderButton.setIcon(UIManager.getIcon(treeNodeData.isExpanded() ? "Tree.expandedIcon" : "Tree.collapsedIcon"));
        }
        super.setBackground(component.getBackground());
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            this.setToolTipText(jComponent.getToolTipText());
            this.setBorder(bl2 ? jComponent.getBorder() : NO_FOCUS_BORDER);
            jComponent.setBorder(NO_FOCUS_BORDER);
        }
        this.removeAll();
        this.add(this.getSpacer(n2), TreeTableCellLayout.INDENTER);
        this.add(bl3 ? this.expanderButton : TreeTableCellPanel.createSpacer(UIManager.getIcon("Tree.expandedIcon").getIconWidth()), TreeTableCellLayout.EXPANDER);
        this.add(this.getSpacer(n3), TreeTableCellLayout.SPACER);
        this.add(component, TreeTableCellLayout.NODE_COMPONENT);
        this.nodeComponent = component;
        super.setBackground(component.getBackground());
        super.setForeground(component.getForeground());
        super.setFont(component.getFont());
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.nodeComponent != null) {
            this.nodeComponent.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.nodeComponent != null) {
            this.nodeComponent.setForeground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.nodeComponent != null) {
            this.nodeComponent.setFont(font);
        }
    }

    public Component getNodeComponent() {
        return this.nodeComponent;
    }

    public boolean isPointOverExpanderButton(Point point) {
        return this.expanderButton.isVisible() && SwingUtilities.getDeepestComponentAt(this, point.x, point.y) == this.expanderButton;
    }

    public boolean isPointOverNodeComponent(Point point) {
        return this.nodeComponent != null && this.nodeComponent.isVisible() && SwingUtilities.getDeepestComponentAt(this, point.x, point.y) == this.nodeComponent;
    }

    private Component getSpacer(int n2) {
        Integer n3 = new Integer(n2);
        Component component = this.spacerComponentsCache.get(n3);
        if (component == null) {
            component = TreeTableCellPanel.createSpacer(n2);
            this.spacerComponentsCache.put(n3, component);
        }
        return component;
    }

    private static Component createSpacer(int n2) {
        return Box.createHorizontalStrut(n2);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl) {
        if (!this.nodeComponent.hasFocus()) {
            SwingUtilities.invokeLater(new RequestFocusAndDispatchKeyEventRunnable(keyEvent, this.nodeComponent));
        }
        return super.processKeyBinding(keyStroke, keyEvent, n2, bl);
    }

    @Override
    public void setNextFocusableComponent(Component component) {
        super.setNextFocusableComponent(component);
        if (this.nodeComponent instanceof JComponent) {
            ((JComponent)this.nodeComponent).setNextFocusableComponent(component);
        }
    }

    private static class TreeTableCellLayout
    implements LayoutManager2 {
        public static final Object INDENTER = new Object();
        public static final Object EXPANDER = new Object();
        public static final Object SPACER = new Object();
        public static final Object NODE_COMPONENT = new Object();
        private Component indenter;
        private Component expander;
        private Component spacer;
        private Component nodeComponent;

        private TreeTableCellLayout() {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            if (object == INDENTER) {
                this.indenter = component;
            } else if (object == EXPANDER) {
                this.expander = component;
            } else if (object == SPACER) {
                this.spacer = component;
            } else if (object == NODE_COMPONENT) {
                this.nodeComponent = component;
            } else {
                throw new IllegalArgumentException("Unexpected constraints object: " + object);
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (component == this.indenter) {
                this.indenter = null;
            }
            if (component == this.expander) {
                this.expander = null;
            }
            if (component == this.spacer) {
                this.spacer = null;
            }
            if (component == this.nodeComponent) {
                this.nodeComponent = null;
            }
        }

        @Override
        public void layoutContainer(Container container) {
            int n2;
            int n3;
            int n4;
            int n5;
            Insets insets = container.getInsets();
            int n6 = container.getWidth() - insets.left - insets.right;
            int n7 = container.getHeight() - insets.top - insets.bottom;
            int n8 = n6;
            if (n7 <= 0) {
                return;
            }
            if (n8 > 0 && this.indenter != null) {
                n5 = this.indenter.getPreferredSize().width;
                this.indenter.setBounds(0, 0, n5, n7);
                n8 -= n5;
            }
            if (n8 > 0 && this.expander != null) {
                n5 = n6 - n8;
                n4 = insets.top;
                n3 = this.expander.getPreferredSize().width;
                n2 = this.expander.getPreferredSize().height;
                if (n2 > n7) {
                    n2 = n7;
                } else if (n2 < n7) {
                    n4 += (n7 - n2) / 2;
                }
                this.expander.setBounds(n5, n4, n3, n2);
                n8 -= n3;
            }
            if (n8 > 0 && this.spacer != null) {
                n5 = n6 - n8;
                n4 = this.spacer.getPreferredSize().width;
                this.spacer.setBounds(n5, 0, n4, n7);
                n8 -= n4;
            }
            if (n8 > 0 && this.nodeComponent != null) {
                n5 = n6 - n8;
                n4 = insets.top;
                n3 = n8;
                n2 = this.nodeComponent.getPreferredSize().height;
                if (n2 > n7) {
                    n2 = n7;
                } else if (n2 < n7) {
                    n4 += (n7 - n2) / 2;
                }
                this.nodeComponent.setBounds(n5, n4, n3, n2);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = new Dimension(0, 0);
            if (this.indenter != null) {
                cloneable = this.indenter.getPreferredSize();
                dimension.height = Math.max(dimension.height, cloneable.height);
                dimension.width += cloneable.width;
            }
            if (this.expander != null) {
                cloneable = this.expander.getPreferredSize();
                dimension.height = Math.max(dimension.height, cloneable.height);
                dimension.width += cloneable.width;
            }
            if (this.spacer != null) {
                cloneable = this.spacer.getPreferredSize();
                dimension.height = Math.max(dimension.height, cloneable.height);
                dimension.width += cloneable.width;
            }
            if (this.nodeComponent != null) {
                cloneable = this.nodeComponent.getPreferredSize();
                dimension.height = Math.max(dimension.height, cloneable.height);
                dimension.width += cloneable.width;
            }
            cloneable = container.getInsets();
            dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            return dimension;
        }

        @Override
        public void invalidateLayout(Container container) {
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class RequestFocusAndDispatchKeyEventRunnable
    implements Runnable {
        private final KeyEvent keyEvent;
        private final Component component;

        public RequestFocusAndDispatchKeyEventRunnable(KeyEvent keyEvent, Component component) {
            this.keyEvent = keyEvent;
            this.component = component;
        }

        @Override
        public void run() {
            this.component.requestFocus();
            this.component.dispatchEvent(this.keyEvent);
        }
    }
}

