/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.swing.TreeNodeData;
import ca.odell.glazedlists.swing.TreeTableCellPanel;
import ca.odell.glazedlists.swing.TreeTableNodeDataEditor;
import ca.odell.glazedlists.swing.TreeTableUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class TreeTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final TreeTableCellPanel component = new TreeTableCellPanel();
    private TreeList treeList;
    private TableCellEditor delegate;
    private boolean showExpanderForEmptyParent;
    private final CellEditorListener delegateListener = new DelegateTableCellEditorListener();
    private final TreeNodeData treeNodeData = new TreeNodeData();

    public TreeTableCellEditor(TableCellEditor tableCellEditor, TreeList treeList) {
        this.delegate = tableCellEditor == null ? this.createDelegateEditor() : tableCellEditor;
        this.delegate.addCellEditorListener(this.delegateListener);
        this.treeList = treeList;
    }

    protected TableCellEditor createDelegateEditor() {
        JTextField jTextField = new JTextField();
        jTextField.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        return new DefaultCellEditor(jTextField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        this.treeList.getReadWriteLock().readLock().lock();
        try {
            this.treeNodeData.setDepth(this.treeList.depth(n2));
            this.treeNodeData.setExpanded(this.treeList.isExpanded(n2));
            this.treeNodeData.setHasChildren(this.treeList.hasChildren(n2));
            this.treeNodeData.setAllowsChildren(this.treeList.getAllowsChildren(n2));
        }
        finally {
            this.treeList.getReadWriteLock().readLock().unlock();
        }
        if (this.delegate instanceof TreeTableNodeDataEditor) {
            ((TreeTableNodeDataEditor)this.delegate).setTreeNodeData(this.treeNodeData);
        }
        Component component = this.delegate.getTableCellEditorComponent(jTable, object, bl, n2, n3);
        int n4 = this.getIndent(this.treeNodeData, this.showExpanderForEmptyParent);
        int n5 = this.getSpacer(this.treeNodeData, this.showExpanderForEmptyParent);
        this.component.configure(this.treeNodeData, this.showExpanderForEmptyParent, component, false, n4, n5);
        return this.component;
    }

    protected int getIndent(TreeNodeData treeNodeData, boolean bl) {
        return UIManager.getIcon("Tree.expandedIcon").getIconWidth() * treeNodeData.getDepth();
    }

    protected int getSpacer(TreeNodeData treeNodeData, boolean bl) {
        return 2;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            JTable jTable = (JTable)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n2 = jTable.rowAtPoint(point);
            int n3 = jTable.columnAtPoint(point);
            Rectangle rectangle = jTable.getCellRect(n2, n3, true);
            point.translate(-rectangle.x, -rectangle.y);
            TreeTableCellPanel treeTableCellPanel = TreeTableUtilities.prepareRenderer(mouseEvent);
            if (treeTableCellPanel != null && treeTableCellPanel.isPointOverNodeComponent(point)) {
                Rectangle rectangle2 = treeTableCellPanel.getNodeComponent().getBounds();
                MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - rectangle2.x, mouseEvent.getY() - rectangle2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                return this.delegate.isCellEditable(mouseEvent2);
            }
            return false;
        }
        return super.isCellEditable(eventObject);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    void setShowExpanderForEmptyParent(boolean bl) {
        this.showExpanderForEmptyParent = bl;
    }

    void setDelegate(TableCellEditor tableCellEditor) {
        this.delegate = tableCellEditor;
    }

    public TableCellEditor getDelegate() {
        return this.delegate;
    }

    public void dispose() {
        this.delegate.removeCellEditorListener(this.delegateListener);
        this.delegate = null;
        this.treeList = null;
    }

    private class DelegateTableCellEditorListener
    implements CellEditorListener {
        private DelegateTableCellEditorListener() {
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            TreeTableCellEditor.this.cancelCellEditing();
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            TreeTableCellEditor.this.stopCellEditing();
        }
    }
}

