/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextComponentMatcherEditor<E>
extends TextMatcherEditor<E> {
    private Document document;
    private final JTextComponent textComponent;
    private boolean live;
    private final FilterHandler filterHandler = new FilterHandler();

    public TextComponentMatcherEditor(JTextComponent jTextComponent, TextFilterator<? super E> textFilterator) {
        this(jTextComponent, textFilterator, true);
    }

    public TextComponentMatcherEditor(JTextComponent jTextComponent, TextFilterator<? super E> textFilterator, boolean bl) {
        this(jTextComponent, jTextComponent.getDocument(), textFilterator, bl);
    }

    public TextComponentMatcherEditor(Document document, TextFilterator<? super E> textFilterator) {
        this(null, document, textFilterator, true);
    }

    private TextComponentMatcherEditor(JTextComponent jTextComponent, Document document, TextFilterator<? super E> textFilterator, boolean bl) {
        super(textFilterator);
        this.textComponent = jTextComponent;
        this.document = document;
        this.live = bl;
        this.registerListeners(bl);
        this.refilter();
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean bl) {
        if (bl == this.live) {
            return;
        }
        this.deregisterListeners(this.live);
        this.live = bl;
        this.registerListeners(this.live);
    }

    private void registerListeners(boolean bl) {
        if (bl) {
            this.document.addDocumentListener(this.filterHandler);
        } else {
            if (this.textComponent == null) {
                throw new IllegalArgumentException("Non-live filtering supported only for JTextField (document provided)");
            }
            if (!(this.textComponent instanceof JTextField)) {
                throw new IllegalArgumentException("Non-live filtering supported only for JTextField (argument class " + this.textComponent.getClass().getName() + ")");
            }
            JTextField jTextField = (JTextField)this.textComponent;
            jTextField.addActionListener(this.filterHandler);
        }
        if (this.textComponent != null) {
            this.textComponent.addPropertyChangeListener(this.filterHandler);
        }
    }

    private void deregisterListeners(boolean bl) {
        if (bl) {
            this.document.removeDocumentListener(this.filterHandler);
        } else {
            JTextField jTextField = (JTextField)this.textComponent;
            jTextField.removeActionListener(this.filterHandler);
        }
        if (this.textComponent != null) {
            this.textComponent.removePropertyChangeListener(this.filterHandler);
        }
    }

    public void dispose() {
        this.deregisterListeners(this.live);
    }

    private void refilter() {
        try {
            String[] stringArray;
            int n2 = this.getMode();
            String string = this.document.getText(0, this.document.getLength());
            if (n2 == 0) {
                stringArray = string.split("[ \t]");
            } else if (n2 == 1 || n2 == 2 || n2 == 3) {
                stringArray = new String[]{string};
            } else {
                throw new IllegalStateException("Unknown mode: " + n2);
            }
            this.setFilterText(stringArray);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    private class FilterHandler
    implements DocumentListener,
    ActionListener,
    PropertyChangeListener {
        private FilterHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            TextComponentMatcherEditor.this.refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            TextComponentMatcherEditor.this.refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            TextComponentMatcherEditor.this.refilter();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextComponentMatcherEditor.this.refilter();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document" == propertyChangeEvent.getPropertyName()) {
                TextComponentMatcherEditor.this.deregisterListeners(TextComponentMatcherEditor.this.live);
                TextComponentMatcherEditor.this.document = TextComponentMatcherEditor.this.textComponent.getDocument();
                TextComponentMatcherEditor.this.registerListeners(TextComponentMatcherEditor.this.live);
                TextComponentMatcherEditor.this.refilter();
            }
        }
    }
}

