/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.SortIconFactory;
import ca.odell.glazedlists.impl.gui.SortingStrategy;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.SortableRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TableComparatorChooser<E>
extends AbstractTableComparatorChooser<E> {
    private SortArrowHeaderRenderer sortArrowHeaderRenderer;
    private final TableHeaderUIHandler tableHeaderUIHandler = new TableHeaderUIHandler();
    private final TableModelHandler tableModelHandler = new TableModelHandler();
    private JTable table;
    private ActionListener sortListener;
    private static Icon[] icons = SortIconFactory.loadIcons();
    private final HeaderClickHandler headerClickHandler;

    @Deprecated
    public TableComparatorChooser(JTable jTable, SortedList<E> sortedList, boolean bl) {
        this(jTable, sortedList, bl ? MULTIPLE_COLUMN_MOUSE : SINGLE_COLUMN);
    }

    @Deprecated
    public TableComparatorChooser(JTable jTable, SortedList<E> sortedList, Object object) {
        this(jTable, sortedList, object, ((AdvancedTableModel)jTable.getModel()).getTableFormat());
    }

    protected TableComparatorChooser(JTable jTable, SortedList<E> sortedList, Object object, TableFormat<? super E> tableFormat) {
        super(sortedList, tableFormat);
        TableComparatorChooser.validateSortingStrategy(object);
        this.table = jTable;
        this.table.addPropertyChangeListener("model", this.tableModelHandler);
        this.table.getTableHeader().addPropertyChangeListener("UI", this.tableHeaderUIHandler);
        this.wrapDefaultTableHeaderRenderer();
        jTable.getModel().addTableModelListener(this.tableModelHandler);
        this.headerClickHandler = new HeaderClickHandler(jTable, (SortingStrategy)object);
    }

    private void wrapDefaultTableHeaderRenderer() {
        Class<?> clazz;
        TableCellRenderer tableCellRenderer = this.table.getTableHeader().getDefaultRenderer();
        Class<?> clazz2 = clazz = tableCellRenderer == null ? null : tableCellRenderer.getClass();
        if (clazz != SortArrowHeaderRenderer.class && clazz != null) {
            this.sortArrowHeaderRenderer = new SortArrowHeaderRenderer(tableCellRenderer);
            this.table.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer);
        }
    }

    public static <E> TableComparatorChooser<E> install(JTable jTable, SortedList<E> sortedList, Object object) {
        return TableComparatorChooser.install(jTable, sortedList, object, ((AdvancedTableModel)jTable.getModel()).getTableFormat());
    }

    public static <E> TableComparatorChooser<E> install(JTable jTable, SortedList<E> sortedList, Object object, TableFormat<? super E> tableFormat) {
        return new TableComparatorChooser<E>(jTable, sortedList, object, tableFormat);
    }

    private static void validateSortingStrategy(Object object) {
        if (!(object instanceof SortingStrategy)) {
            throw new IllegalArgumentException("Unrecognized sorting strategy, \"" + object + "\", use one of AbstractTableComparatorChooser.SINGLE_COLUMN, AbstractTableComparatorChooser.MULTIPLE_COLUMN_MOUSE, or AbstractTableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD");
        }
    }

    public void addSortActionListener(ActionListener actionListener) {
        this.sortListener = AWTEventMulticaster.add(this.sortListener, actionListener);
    }

    public void removeSortActionListener(ActionListener actionListener) {
        this.sortListener = AWTEventMulticaster.remove(this.sortListener, actionListener);
    }

    public TableCellRenderer createSortArrowHeaderRenderer(TableCellRenderer tableCellRenderer) {
        return new SortArrowHeaderRenderer(tableCellRenderer);
    }

    @Override
    protected void redetectComparator(Comparator<? super E> comparator) {
        super.redetectComparator(comparator);
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
    }

    @Override
    protected final void rebuildComparator() {
        super.rebuildComparator();
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
        if (this.sortListener != null) {
            this.sortListener.actionPerformed(new ActionEvent(this, 0, "sort"));
        }
    }

    @Override
    protected final int getSortingStyle(int n2) {
        return super.getSortingStyle(this.table.convertColumnIndexToModel(n2));
    }

    protected boolean isSortingMouseEvent(MouseEvent mouseEvent) {
        return mouseEvent.getButton() == 1;
    }

    public static void setIconPath(String string) {
        icons = SortIconFactory.loadIcons(string);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.headerClickHandler.dispose();
        if (this.table.getTableHeader().getDefaultRenderer() == this.sortArrowHeaderRenderer) {
            this.table.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer.getDelegateRenderer());
        }
        this.table.getModel().removeTableModelListener(this.tableModelHandler);
        this.table.removePropertyChangeListener("model", this.tableModelHandler);
        this.table.getTableHeader().removePropertyChangeListener("UI", this.tableHeaderUIHandler);
        this.table = null;
    }

    private class HeaderClickHandler
    extends MouseAdapter {
        private final JTable table;
        private final SortingStrategy delegate;
        private boolean mouseEventIsPerformingPopupTrigger = false;

        public HeaderClickHandler(JTable jTable, SortingStrategy sortingStrategy) {
            this.table = jTable;
            this.delegate = sortingStrategy;
            jTable.getTableHeader().addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.mouseEventIsPerformingPopupTrigger) {
                return;
            }
            if (this.table.getTableHeader().getCursor() == Cursor.getPredefinedCursor(11)) {
                return;
            }
            if (!TableComparatorChooser.this.isSortingMouseEvent(mouseEvent)) {
                return;
            }
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n3 = this.table.convertColumnIndexToModel(n2);
            int n4 = mouseEvent.getClickCount();
            if (n4 >= 1 && n3 != -1) {
                boolean bl = mouseEvent.isShiftDown();
                boolean bl2 = mouseEvent.isControlDown() || mouseEvent.isMetaDown();
                this.delegate.columnClicked(TableComparatorChooser.this.sortingState, n3, n4, bl, bl2);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseEventIsPerformingPopupTrigger = mouseEvent.isPopupTrigger();
        }

        public void dispose() {
            this.table.getTableHeader().removeMouseListener(this);
        }
    }

    class SortArrowHeaderRenderer
    implements TableCellRenderer,
    UIResource {
        private TableCellRenderer delegateRenderer;

        public SortArrowHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.delegateRenderer = tableCellRenderer;
        }

        public TableCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            Component component;
            if (n3 < 0) {
                return this.getDelegateTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
            }
            Icon icon = icons[TableComparatorChooser.this.getSortingStyle(n3)];
            if (this.delegateRenderer instanceof SortableRenderer) {
                ((SortableRenderer)((Object)this.delegateRenderer)).setSortIcon(icon);
                component = this.getDelegateTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
            } else {
                component = this.getDelegateTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setIcon(icon);
                    jLabel.setHorizontalTextPosition(10);
                }
            }
            return component;
        }

        private Component getDelegateTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            try {
                return this.delegateRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
            }
            catch (RuntimeException runtimeException) {
                this.delegateRenderer = new DefaultTableCellRenderer();
                return this.delegateRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener,
    PropertyChangeListener {
        private TableModelHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AdvancedTableModel advancedTableModel;
            AdvancedTableModel advancedTableModel2 = propertyChangeEvent.getOldValue() instanceof AdvancedTableModel ? (AdvancedTableModel)propertyChangeEvent.getOldValue() : null;
            AdvancedTableModel advancedTableModel3 = advancedTableModel = propertyChangeEvent.getNewValue() instanceof AdvancedTableModel ? (AdvancedTableModel)propertyChangeEvent.getNewValue() : null;
            if (advancedTableModel2 != null) {
                advancedTableModel2.removeTableModelListener(this);
            }
            if (advancedTableModel != null) {
                advancedTableModel.addTableModelListener(this);
                TableComparatorChooser.this.setTableFormat(advancedTableModel.getTableFormat());
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            Comparator comparator;
            if (tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && TableComparatorChooser.this.table.getModel() instanceof AdvancedTableModel) {
                TableComparatorChooser.this.setTableFormat(((AdvancedTableModel)TableComparatorChooser.this.table.getModel()).getTableFormat());
            }
            if ((comparator = TableComparatorChooser.this.sortedList.getComparator()) != TableComparatorChooser.this.sortedListComparator) {
                TableComparatorChooser.this.redetectComparator(comparator);
            }
        }
    }

    private class TableHeaderUIHandler
    implements PropertyChangeListener {
        private TableHeaderUIHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TableComparatorChooser.this.wrapDefaultTableHeaderRenderer();
        }
    }
}

