/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ThresholdList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.swing.DefaultTableModelEventAdapterFactory;
import ca.odell.glazedlists.impl.swing.LowerThresholdRangeModel;
import ca.odell.glazedlists.impl.swing.ManyToOneTableModelEventAdapterFactory;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.impl.swing.UpperThresholdRangeModel;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.DefaultEventComboBoxModel;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.TableModelEventAdapter;
import javax.swing.BoundedRangeModel;

public final class GlazedListsSwing {
    private GlazedListsSwing() {
        throw new UnsupportedOperationException();
    }

    public static <E> TransformedList<E, E> swingThreadProxyList(EventList<E> eventList) {
        return new SwingThreadProxyEventList<E>(eventList);
    }

    public static boolean isSwingThreadProxyList(EventList eventList) {
        return eventList instanceof SwingThreadProxyEventList;
    }

    public static BoundedRangeModel lowerRangeModel(ThresholdList thresholdList) {
        return new LowerThresholdRangeModel(thresholdList);
    }

    public static BoundedRangeModel upperRangeModel(ThresholdList thresholdList) {
        return new UpperThresholdRangeModel(thresholdList);
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> eventList, TableFormat<? super E> tableFormat) {
        return new DefaultEventTableModel<E>(eventList, tableFormat);
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> eventList, TableFormat<? super E> tableFormat) {
        EventList<E> eventList2 = GlazedListsSwing.createSwingThreadProxyList(eventList);
        return new DefaultEventTableModel<E>(eventList2, true, tableFormat);
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> eventList, TableFormat<? super E> tableFormat, TableModelEventAdapter.Factory<E> factory) {
        DefaultEventTableModel<E> defaultEventTableModel = new DefaultEventTableModel<E>(eventList, tableFormat);
        TableModelEventAdapter<E> tableModelEventAdapter = factory.create(defaultEventTableModel);
        defaultEventTableModel.setEventAdapter(tableModelEventAdapter);
        return defaultEventTableModel;
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> eventList, TableFormat<? super E> tableFormat, TableModelEventAdapter.Factory<E> factory) {
        EventList<E> eventList2 = GlazedListsSwing.createSwingThreadProxyList(eventList);
        DefaultEventTableModel<E> defaultEventTableModel = new DefaultEventTableModel<E>(eventList2, true, tableFormat);
        TableModelEventAdapter<E> tableModelEventAdapter = factory.create(defaultEventTableModel);
        defaultEventTableModel.setEventAdapter(tableModelEventAdapter);
        return defaultEventTableModel;
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> eventList, String[] stringArray, String[] stringArray2, boolean[] blArray) {
        return GlazedListsSwing.eventTableModel(eventList, GlazedLists.tableFormat(stringArray, stringArray2, blArray));
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> eventList, String[] stringArray, String[] stringArray2, boolean[] blArray) {
        return GlazedListsSwing.eventTableModelWithThreadProxyList(eventList, GlazedLists.tableFormat(stringArray, stringArray2, blArray));
    }

    public static <E> TableModelEventAdapter.Factory<E> defaultEventAdapterFactory() {
        return DefaultTableModelEventAdapterFactory.getInstance();
    }

    public static <E> TableModelEventAdapter.Factory<E> manyToOneEventAdapterFactory() {
        return ManyToOneTableModelEventAdapterFactory.getInstance();
    }

    public static <E> AdvancedListSelectionModel<E> eventSelectionModel(EventList<E> eventList) {
        return new DefaultEventSelectionModel<E>(eventList);
    }

    public static <E> AdvancedListSelectionModel<E> eventSelectionModelWithThreadProxyList(EventList<E> eventList) {
        EventList<E> eventList2 = GlazedListsSwing.createSwingThreadProxyList(eventList);
        return new DefaultEventSelectionModel<E>(eventList2, true);
    }

    public static <E> DefaultEventListModel<E> eventListModel(EventList<E> eventList) {
        return new DefaultEventListModel<E>(eventList);
    }

    public static <E> DefaultEventListModel<E> eventListModelWithThreadProxyList(EventList<E> eventList) {
        EventList<E> eventList2 = GlazedListsSwing.createSwingThreadProxyList(eventList);
        return new DefaultEventListModel<E>(eventList2, true);
    }

    public static <E> DefaultEventComboBoxModel<E> eventComboBoxModel(EventList<E> eventList) {
        return new DefaultEventComboBoxModel<E>(eventList);
    }

    public static <E> DefaultEventComboBoxModel<E> eventComboBoxModelWithThreadProxyList(EventList<E> eventList) {
        EventList<E> eventList2 = GlazedListsSwing.createSwingThreadProxyList(eventList);
        return new DefaultEventComboBoxModel<E>(eventList2, true);
    }

    private static <E> EventList<E> createSwingThreadProxyList(EventList<E> eventList) {
        TransformedList<E, E> transformedList;
        eventList.getReadWriteLock().readLock().lock();
        try {
            transformedList = GlazedListsSwing.swingThreadProxyList(eventList);
        }
        finally {
            eventList.getReadWriteLock().readLock().unlock();
        }
        return transformedList;
    }
}

