/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class EventTreeModel<E>
implements TreeModel,
ListEventListener<E> {
    protected TransformedList swingThreadSource;
    private final boolean disposeSwingThreadSource;
    private TreeList<E> treeList;
    private final Object treeRoot = new Object();
    protected List<TreeModelListener> listenerList = new ArrayList<TreeModelListener>();

    public EventTreeModel(TreeList<E> treeList) {
        treeList.getReadWriteLock().readLock().lock();
        try {
            this.disposeSwingThreadSource = !GlazedListsSwing.isSwingThreadProxyList(treeList);
            this.swingThreadSource = this.disposeSwingThreadSource ? GlazedListsSwing.swingThreadProxyList(treeList) : treeList;
            this.swingThreadSource.addListEventListener(this);
        }
        finally {
            treeList.getReadWriteLock().readLock().unlock();
        }
        this.treeList = treeList;
    }

    @Override
    public Object getRoot() {
        return this.treeRoot;
    }

    @Override
    public Object getChild(Object object, int n2) {
        if (object == this.treeRoot) {
            return this.treeList.getRoots().get(n2);
        }
        TreeList.Node node = (TreeList.Node)object;
        return node.getChildren().get(n2);
    }

    @Override
    public int getChildCount(Object object) {
        if (object == this.treeRoot) {
            return this.treeList.getRoots().size();
        }
        TreeList.Node node = (TreeList.Node)object;
        return node.getChildren().size();
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object == this.treeRoot) {
            return this.treeList.isEmpty();
        }
        TreeList.Node node = (TreeList.Node)object;
        return node.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == this.treeRoot) {
            return this.treeList.getRoots().indexOf(object2);
        }
        TreeList.Node node = (TreeList.Node)object;
        return node.getChildren().indexOf(object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(treeModelListener);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        for (TreeModelListener treeModelListener : this.listenerList) {
            treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.treeRoot}));
        }
    }

    public void dispose() {
        this.swingThreadSource.removeListEventListener(this);
        if (this.disposeSwingThreadSource) {
            this.swingThreadSource.dispose();
        }
        this.swingThreadSource = null;
    }
}

