/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.IteratorAsEnumeration;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class EventTableColumnModel<T extends TableColumn>
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
ListEventListener<T> {
    protected TransformedList<T, T> swingThreadSource;
    private final boolean disposeSwingThreadSource;
    private final EventListenerList listenerList = new EventListenerList();
    private final transient ChangeEvent changeEvent = new ChangeEvent(this);
    private ListSelectionModel selectionModel;
    private boolean columnSelectionAllowed;
    private int columnMargin;
    private int totalColumnWidth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTableColumnModel(EventList<T> eventList) {
        this.setSelectionModel(this.createSelectionModel());
        this.setColumnMargin(1);
        this.invalidateWidthCache();
        this.setColumnSelectionAllowed(false);
        eventList.getReadWriteLock().readLock().lock();
        try {
            int n2;
            int n3 = eventList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                if (eventList.get(n2) != null) continue;
                throw new IllegalStateException("null TableColumn objects are not allowed in EventTableColumnModel");
            }
            n3 = eventList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ((TableColumn)eventList.get(n2)).addPropertyChangeListener(this);
            }
            this.disposeSwingThreadSource = !GlazedListsSwing.isSwingThreadProxyList(eventList);
            this.swingThreadSource = this.disposeSwingThreadSource ? GlazedListsSwing.swingThreadProxyList(eventList) : (TransformedList)eventList;
            this.swingThreadSource.addListEventListener(this);
        }
        finally {
            eventList.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.swingThreadSource.add(tableColumn);
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            this.swingThreadSource.remove(tableColumn);
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveColumn(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("columnIndex out of range");
        }
        if (n3 < 0 || n3 >= this.getColumnCount()) {
            throw new IllegalArgumentException("newIndex out of range");
        }
        if (n2 == n3) {
            this.fireColumnMoved(new TableColumnModelEvent(this, n2, n3));
            return;
        }
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.selectionModel.isSelectedIndex(n2);
            this.swingThreadSource.add(n3, this.swingThreadSource.remove(n2));
            if (bl) {
                this.selectionModel.addSelectionInterval(n3, n3);
            }
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void setColumnMargin(int n2) {
        if (n2 != this.columnMargin) {
            this.columnMargin = n2;
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public int getColumnMargin() {
        return this.columnMargin;
    }

    @Override
    public int getColumnCount() {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.swingThreadSource.size();
            return n2;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return new IteratorAsEnumeration<TableColumn>(this.swingThreadSource.iterator());
    }

    @Override
    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("identifier is null");
        }
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.swingThreadSource.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!object.equals(((TableColumn)this.swingThreadSource.get(i2)).getIdentifier())) continue;
                int n3 = i2;
                return n3;
            }
            throw new IllegalArgumentException("Identifier not found");
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public TableColumn getColumn(int n2) {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            TableColumn tableColumn = (TableColumn)this.swingThreadSource.get(n2);
            return tableColumn;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnIndexAtX(int n2) {
        if (n2 < 0) {
            return -1;
        }
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            int n3 = this.swingThreadSource.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                TableColumn tableColumn = (TableColumn)this.swingThreadSource.get(i2);
                if ((n2 -= tableColumn.getWidth()) >= 0) continue;
                int n4 = i2;
                return n4;
            }
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    private void recalcWidthCache() {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            this.totalColumnWidth = 0;
            int n2 = this.swingThreadSource.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.totalColumnWidth += ((TableColumn)this.swingThreadSource.get(i2)).getWidth();
            }
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        this.columnSelectionAllowed = bl;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public int[] getSelectedColumns() {
        if (this.selectionModel != null) {
            int n2 = this.selectionModel.getMinSelectionIndex();
            int n3 = this.selectionModel.getMaxSelectionIndex();
            if (n2 == -1 || n3 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n3 - n2)];
            int n4 = 0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.selectionModel.isSelectedIndex(i2)) continue;
                nArray[n4++] = i2;
            }
            int[] nArray2 = new int[n4];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            return nArray2;
        }
        return new int[0];
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.selectionModel != null) {
            int n2 = this.selectionModel.getMinSelectionIndex();
            int n3 = this.selectionModel.getMaxSelectionIndex();
            int n4 = 0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.selectionModel.isSelectedIndex(i2)) continue;
                ++n4;
            }
            return n4;
        }
        return 0;
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("newModel may not be null");
        }
        if (listSelectionModel != this.selectionModel) {
            if (this.selectionModel != null) {
                this.selectionModel.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            this.selectionModel.addListSelectionListener(this);
        }
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.add(TableColumnModelListener.class, tableColumnModelListener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.remove(TableColumnModelListener.class, tableColumnModelListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "width" || string == "preferredWidth") {
            this.invalidateWidthCache();
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }

    @Override
    public void listChanged(ListEvent<T> listEvent) {
        this.invalidateWidthCache();
        while (listEvent.next()) {
            TableColumn tableColumn;
            int n2 = listEvent.getIndex();
            int n3 = listEvent.getType();
            if (n3 == 0) {
                if (this.selectionModel != null) {
                    this.selectionModel.removeIndexInterval(n2, n2);
                }
                tableColumn = (TableColumn)listEvent.getOldValue();
                tableColumn.removePropertyChangeListener(this);
                this.fireColumnRemoved(new TableColumnModelEvent(this, n2, 0));
                continue;
            }
            if (n3 == 2) {
                tableColumn = (TableColumn)listEvent.getSourceList().get(n2);
                if (tableColumn == null) {
                    throw new IllegalStateException("null TableColumn objects are not allowed in EventTableColumnModel");
                }
                tableColumn.addPropertyChangeListener(this);
                this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
                continue;
            }
            if (n3 != 1) continue;
            tableColumn = (TableColumn)listEvent.getOldValue();
            TableColumn tableColumn2 = (TableColumn)listEvent.getSourceList().get(n2);
            if (tableColumn2 == null) {
                throw new IllegalStateException("null TableColumn objects are not allowed in EventTableColumnModel");
            }
            if (tableColumn != tableColumn2) {
                tableColumn.removePropertyChangeListener(this);
                tableColumn2.addPropertyChangeListener(this);
            }
            this.fireColumnMoved(new TableColumnModelEvent(this, n2, n2));
        }
    }

    public void dispose() {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.swingThreadSource.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((TableColumn)this.swingThreadSource.get(i2)).removePropertyChangeListener(this);
            }
            this.swingThreadSource.removeListEventListener(this);
            if (this.disposeSwingThreadSource) {
                this.swingThreadSource.dispose();
            }
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
        this.swingThreadSource = null;
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnAdded(tableColumnModelEvent);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnRemoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnMoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnSelectionChanged(listSelectionEvent);
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnMarginChanged(this.changeEvent);
        }
    }
}

