/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableModelEventAdapter;
import javax.swing.table.AbstractTableModel;

public class DefaultEventTableModel<E>
extends AbstractTableModel
implements AdvancedTableModel<E>,
ListEventListener<E> {
    protected EventList<E> source;
    private boolean disposeSource;
    private TableFormat<? super E> tableFormat;
    private TableModelEventAdapter<E> eventAdapter = GlazedListsSwing.defaultEventAdapterFactory().create(this);

    public DefaultEventTableModel(EventList<E> eventList, TableFormat<? super E> tableFormat) {
        this(eventList, false, tableFormat);
    }

    public DefaultEventTableModel(EventList<E> eventList, boolean bl, TableFormat<? super E> tableFormat) {
        this.source = eventList;
        this.disposeSource = bl;
        this.tableFormat = tableFormat;
        eventList.addListEventListener(this);
    }

    @Override
    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    @Override
    public void setTableFormat(TableFormat<? super E> tableFormat) {
        this.tableFormat = tableFormat;
        this.eventAdapter.fireTableStructureChanged();
    }

    @Override
    public E getElementAt(int n2) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object e2 = this.source.get(n2);
            return e2;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        this.handleListChange(listEvent);
    }

    protected void handleListChange(ListEvent<E> listEvent) {
        this.eventAdapter.listChanged(listEvent);
    }

    @Override
    public String getColumnName(int n2) {
        return this.tableFormat.getColumnName(n2);
    }

    @Override
    public int getRowCount() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.source.size();
            return n2;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        if (this.tableFormat instanceof AdvancedTableFormat) {
            return ((AdvancedTableFormat)this.tableFormat).getColumnClass(n2);
        }
        return super.getColumnClass(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n2, int n3) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object object = this.tableFormat.getColumnValue(this.source.get(n2), n3);
            return object;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int n2, int n3) {
        if (!(this.tableFormat instanceof WritableTableFormat)) {
            return false;
        }
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object e2 = this.source.get(n2);
            boolean bl = ((WritableTableFormat)this.tableFormat).isEditable(e2, n3);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n2, int n3) {
        if (!(this.tableFormat instanceof WritableTableFormat)) {
            throw new UnsupportedOperationException("Unexpected setValueAt() on read-only table");
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            Object e2 = this.source.get(n2);
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            Object e3 = writableTableFormat.setColumnValue(e2, object, n3);
            if (e3 != null) {
                boolean bl;
                boolean bl2 = bl = n2 < this.getRowCount() && this.source.get(n2) == e2;
                if (bl) {
                    this.source.set(n2, e3);
                }
            }
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
        if (this.disposeSource) {
            this.source.dispose();
        }
        this.source = null;
    }

    public final TableModelEventAdapter<E> getEventAdapter() {
        return this.eventAdapter;
    }

    public final void setEventAdapter(TableModelEventAdapter<E> tableModelEventAdapter) {
        this.eventAdapter = tableModelEventAdapter;
    }
}

