/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.ListSelection;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class DefaultEventSelectionModel<E>
implements AdvancedListSelectionModel<E> {
    private ListSelection<E> listSelection;
    private EventList<E> source;
    private boolean disposeSource;
    private boolean enabled = true;
    private final ListSelection.Listener selectionListener = new SwingSelectionListener();
    private final List<ListSelectionListener> listeners = new ArrayList<ListSelectionListener>();
    private boolean valueIsAdjusting = false;
    private int fullChangeStart = -1;
    private int fullChangeFinish = -1;

    public DefaultEventSelectionModel(EventList<E> eventList) {
        this(eventList, false);
    }

    public DefaultEventSelectionModel(EventList<E> eventList, boolean bl) {
        eventList.getReadWriteLock().readLock().lock();
        try {
            this.source = eventList;
            this.listSelection = new ListSelection<E>(eventList);
            this.listSelection.addSelectionListener(this.selectionListener);
        }
        finally {
            eventList.getReadWriteLock().readLock().unlock();
        }
        this.disposeSource = bl;
    }

    @Override
    public EventList<E> getSelected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.listSelection.getSelected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public EventList<E> getTogglingSelected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.listSelection.getTogglingSelected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public EventList<E> getDeselected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.listSelection.getDeselected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public EventList<E> getTogglingDeselected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.listSelection.getTogglingDeselected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    private void fireSelectionChanged(int n2, int n3) {
        if (this.valueIsAdjusting) {
            if (this.fullChangeStart == -1 || n2 < this.fullChangeStart) {
                this.fullChangeStart = n2;
            }
            if (this.fullChangeFinish == -1 || n3 > this.fullChangeFinish) {
                this.fullChangeFinish = n3;
            }
        }
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n2, n3, this.valueIsAdjusting);
        int n4 = this.listeners.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            this.listeners.get(i2).valueChanged(listSelectionEvent);
        }
    }

    @Override
    public void invertSelection() {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.invertSelection();
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void setSelectionInterval(int n2, int n3) {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setSelection(n2, n3);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void addSelectionInterval(int n2, int n3) {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.select(n2, n3);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void removeSelectionInterval(int n2, int n3) {
        if (!this.enabled) {
            return;
        }
        if (n2 == 0 && n3 == 0 && this.source.isEmpty()) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.deselect(n2, n3);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public boolean isSelectedIndex(int n2) {
        return this.listSelection.isSelected(n2);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.listSelection.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int n2) {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setAnchorSelectionIndex(n2);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.listSelection.getLeadSelectionIndex();
    }

    @Override
    public void setLeadSelectionIndex(int n2) {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setLeadSelectionIndex(n2);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public int getMinSelectionIndex() {
        return this.listSelection.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.listSelection.getMaxSelectionIndex();
    }

    @Override
    public void clearSelection() {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.deselectAll();
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public boolean isSelectionEmpty() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.listSelection.getSelected().isEmpty();
            return bl;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void insertIndexInterval(int n2, int n3, boolean bl) {
    }

    @Override
    public void removeIndexInterval(int n2, int n3) {
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this.valueIsAdjusting = bl;
        if (!bl && this.fullChangeStart != -1 && this.fullChangeFinish != -1) {
            this.source.getReadWriteLock().writeLock().lock();
            try {
                this.fireSelectionChanged(this.fullChangeStart, this.fullChangeFinish);
                this.fullChangeStart = -1;
                this.fullChangeFinish = -1;
            }
            finally {
                this.source.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    @Override
    public void setSelectionMode(int n2) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setSelectionMode(n2);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public int getSelectionMode() {
        return this.listSelection.getSelectionMode();
    }

    @Override
    public void addValidSelectionMatcher(Matcher<E> matcher) {
        this.listSelection.addValidSelectionMatcher(matcher);
    }

    @Override
    public void removeValidSelectionMatcher(Matcher<E> matcher) {
        this.listSelection.removeValidSelectionMatcher(matcher);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listeners.add(listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listeners.remove(listSelectionListener);
    }

    @Override
    public void dispose() {
        this.listSelection.removeSelectionListener(this.selectionListener);
        this.listSelection.dispose();
        if (this.disposeSource) {
            this.source.dispose();
        }
    }

    private class SwingSelectionListener
    implements ListSelection.Listener {
        private SwingSelectionListener() {
        }

        @Override
        public void selectionChanged(int n2, int n3) {
            DefaultEventSelectionModel.this.fireSelectionChanged(n2, n3);
        }
    }
}

