/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.MutableListDataEvent;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefaultEventListModel<E>
implements ListEventListener<E>,
ListModel<E> {
    protected EventList<E> source;
    private boolean disposeSource;
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    protected final MutableListDataEvent listDataEvent = new MutableListDataEvent(this);

    public DefaultEventListModel(EventList<E> eventList) {
        this(eventList, false);
    }

    public DefaultEventListModel(EventList<E> eventList, boolean bl) {
        this.source = eventList;
        this.disposeSource = bl;
        this.source.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Events to " + this.getClass().getSimpleName() + " must arrive on the EDT - consider adding GlazedListsSwing.swingThreadProxyList(source) somewhere in your list pipeline");
        }
        listEvent.nextBlock();
        int n2 = listEvent.getBlockStartIndex();
        int n3 = listEvent.getBlockEndIndex();
        this.listDataEvent.setRange(n2, n3);
        int n4 = listEvent.getType();
        switch (n4) {
            case 2: {
                this.listDataEvent.setType(1);
                break;
            }
            case 0: {
                this.listDataEvent.setType(2);
                break;
            }
            case 1: {
                this.listDataEvent.setType(0);
            }
        }
        if (listEvent.nextBlock()) {
            this.listDataEvent.setRange(0, Integer.MAX_VALUE);
            this.listDataEvent.setType(0);
        }
        this.fireListDataEvent(this.listDataEvent);
    }

    @Override
    public E getElementAt(int n2) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object e2 = this.source.get(n2);
            return e2;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int getSize() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.source.size();
            return n2;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    protected void fireListDataEvent(ListDataEvent listDataEvent) {
        int n2 = this.listeners.size();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            ListDataListener listDataListener = this.listeners.get(i2);
            switch (listDataEvent.getType()) {
                case 0: {
                    listDataListener.contentsChanged(listDataEvent);
                    continue block5;
                }
                case 1: {
                    listDataListener.intervalAdded(listDataEvent);
                    continue block5;
                }
                case 2: {
                    listDataListener.intervalRemoved(listDataEvent);
                }
            }
        }
    }

    public void dispose() {
        this.source.removeListEventListener(this);
        if (this.disposeSource) {
            this.source.dispose();
        }
        this.source = null;
    }
}

