/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CompositeList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import ca.odell.glazedlists.impl.swing.ComboBoxPopupLocationFix;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public final class AutoCompleteSupport<E> {
    private static final ParsePosition PARSE_POSITION = new ParsePosition(0);
    private static final Class[] VALUE_OF_SIGNATURE = new Class[]{String.class};
    private static final Object NOT_FOUND = new Object();
    private boolean correctsCase = true;
    private boolean strict = false;
    private boolean beepOnStrictViolation = true;
    private boolean selectsTextOnFocusGain = true;
    private boolean hidesPopupOnFocusLost = true;
    private JComboBox<E> comboBox;
    private JPopupMenu popupMenu;
    private ComboPopup popup;
    private JButton arrowButton;
    private final AutoCompleteComboBoxModel comboBoxModel;
    private final ListCellRenderer<Object> renderer;
    private final EventList<E> items;
    private final FilterList<E> filteredItems;
    private final EventList<E> firstItem;
    private final CompositeList<E> allItemsFiltered;
    private final CompositeList<E> allItemsUnfiltered;
    private final Format format;
    private final TextMatcherEditor<E> filterMatcherEditor;
    private FormatComboBoxEditor comboBoxEditor;
    private JTextField comboBoxEditorComponent;
    private AbstractDocument document;
    private final AutoCompleteFilter documentFilter = new AutoCompleteFilter();
    private UserInputFilter filterMatcher;
    private boolean isFiltering = false;
    private final boolean isTableCellEditor;
    private ArrowButtonMouseListener arrowButtonMouseListener;
    private final ListDataListener listDataHandler = new ListDataHandler();
    private final PopupMenuListener popupSizerHandler = new PopupSizer();
    private ComboBoxPopupLocationFix popupLocationFix;
    private final MouseListener popupMouseHandler = new PopupMouseHandler();
    private final KeyListener strictModeBackspaceHandler = new AutoCompleteKeyHandler();
    private final FocusListener selectTextOnFocusGainHandler = new ComboBoxEditorFocusHandler();
    private final DocumentWatcher documentWatcher = new DocumentWatcher();
    private final ModelWatcher modelWatcher = new ModelWatcher();
    private final UIWatcher uiWatcher = new UIWatcher();
    private boolean doNotPostProcessDocumentChanges = false;
    private boolean doNotFilter = false;
    private boolean doNotChangeDocument = false;
    private boolean doNotAutoComplete = false;
    private boolean doNotTogglePopup;
    private boolean doNotClearFilterOnPopupHide = false;
    private final boolean originalComboBoxEditable;
    private ComboBoxModel<E> originalModel;
    private ListCellRenderer<? super E> originalRenderer;
    private Action originalSelectNextAction;
    private Action originalSelectPreviousAction;
    private Action originalSelectNext2Action;
    private Action originalSelectPrevious2Action;
    private Action originalAquaSelectNextAction;
    private Action originalAquaSelectPreviousAction;
    private static final String GL_ENABLE_NON_STRICT_CONTAINS_SELECTION = "GL:SelectContains";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AutoCompleteSupport(JComboBox<E> jComboBox, EventList<E> eventList, TextFilterator<? super E> defaultTextFilterator, Format format) {
        this.comboBox = jComboBox;
        this.originalComboBoxEditable = jComboBox.isEditable();
        this.originalModel = jComboBox.getModel();
        this.items = eventList;
        this.format = format;
        boolean bl = jComboBox.getRenderer() instanceof UIResource;
        this.renderer = format != null && bl ? new StringFunctionRenderer() : null;
        this.isTableCellEditor = Boolean.TRUE.equals(jComboBox.getClientProperty("JComboBox.isTableCellEditor"));
        this.doNotTogglePopup = !this.isTableCellEditor;
        eventList.getReadWriteLock().readLock().lock();
        try {
            this.filterMatcherEditor = new TextMatcherEditor(defaultTextFilterator == null ? new DefaultTextFilterator() : defaultTextFilterator);
            this.filterMatcherEditor.setMode(1);
            this.filterMatcher = new PrefixFilter();
            this.filteredItems = new FilterList<E>(eventList, this.filterMatcherEditor);
            this.firstItem = new BasicEventList(eventList.getPublisher(), eventList.getReadWriteLock());
            this.allItemsFiltered = new CompositeList(eventList.getPublisher(), eventList.getReadWriteLock());
            this.allItemsFiltered.addMemberList(this.firstItem);
            this.allItemsFiltered.addMemberList(this.filteredItems);
            this.comboBoxModel = new AutoCompleteComboBoxModel(this.allItemsFiltered);
            this.allItemsUnfiltered = new CompositeList(eventList.getPublisher(), eventList.getReadWriteLock());
            this.allItemsUnfiltered.addMemberList(this.firstItem);
            this.allItemsUnfiltered.addMemberList(this.items);
        }
        finally {
            eventList.getReadWriteLock().readLock().unlock();
        }
        this.comboBox.setModel(this.comboBoxModel);
        this.comboBox.setEditable(true);
        this.decorateCurrentUI();
        this.comboBox.addPropertyChangeListener("UI", this.uiWatcher);
        this.comboBox.addPropertyChangeListener("model", this.modelWatcher);
        this.comboBoxEditorComponent.addPropertyChangeListener("document", this.documentWatcher);
    }

    private static void checkAccessThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("AutoCompleteSupport must be accessed from the Swing Event Dispatch Thread, but was called on Thread \"" + Thread.currentThread().getName() + "\"");
        }
    }

    private static ActionListener[] unregisterAllActionListeners(JComboBox<?> jComboBox) {
        ActionListener[] actionListenerArray = jComboBox.getActionListeners();
        for (int i2 = 0; i2 < actionListenerArray.length; ++i2) {
            jComboBox.removeActionListener(actionListenerArray[i2]);
        }
        return actionListenerArray;
    }

    private static void registerAllActionListeners(JComboBox<?> jComboBox, ActionListener[] actionListenerArray) {
        for (int i2 = 0; i2 < actionListenerArray.length; ++i2) {
            jComboBox.addActionListener(actionListenerArray[i2]);
        }
    }

    private static JButton findArrowButton(JComboBox<?> jComboBox) {
        int n2 = jComboBox.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = jComboBox.getComponent(i2);
            if (!(component instanceof JButton)) continue;
            return (JButton)component;
        }
        return null;
    }

    private void decorateCurrentUI() {
        this.originalRenderer = this.comboBox.getRenderer();
        this.popupMenu = (JPopupMenu)this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
        this.popup = (ComboPopup)((Object)this.popupMenu);
        this.arrowButton = AutoCompleteSupport.findArrowButton(this.comboBox);
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.popup.getMouseListener());
            this.arrowButtonMouseListener = new ArrowButtonMouseListener(this.popup.getMouseListener());
            this.arrowButton.addMouseListener(this.arrowButtonMouseListener);
        }
        this.comboBox.getModel().addListDataListener(this.listDataHandler);
        this.popupMenu.addPopupMenuListener(this.popupSizerHandler);
        this.popupLocationFix = ComboBoxPopupLocationFix.install(this.comboBox);
        this.popup.getList().addMouseListener(this.popupMouseHandler);
        ActionMap actionMap = this.comboBox.getActionMap();
        this.originalSelectNextAction = actionMap.get("selectNext");
        this.originalSelectPreviousAction = actionMap.get("selectPrevious");
        this.originalSelectNext2Action = actionMap.get("selectNext2");
        this.originalSelectPrevious2Action = actionMap.get("selectPrevious2");
        this.originalAquaSelectNextAction = actionMap.get("aquaSelectNext");
        this.originalAquaSelectPreviousAction = actionMap.get("aquaSelectPrevious");
        MoveAction moveAction = new MoveAction(-1);
        MoveAction moveAction2 = new MoveAction(1);
        actionMap.put("selectPrevious", moveAction);
        actionMap.put("selectNext", moveAction2);
        actionMap.put("selectPrevious2", moveAction);
        actionMap.put("selectNext2", moveAction2);
        actionMap.put("aquaSelectPrevious", moveAction);
        actionMap.put("aquaSelectNext", moveAction2);
        this.comboBoxEditor = new FormatComboBoxEditor(this.comboBox.getEditor());
        this.comboBox.setEditor(this.comboBoxEditor);
        this.comboBoxEditorComponent = (JTextField)this.comboBox.getEditor().getEditorComponent();
        this.document = (AbstractDocument)this.comboBoxEditorComponent.getDocument();
        this.document.setDocumentFilter(this.documentFilter);
        if (this.renderer != null) {
            this.comboBox.setRenderer(this.renderer);
        }
        this.comboBoxEditorComponent.addKeyListener(this.strictModeBackspaceHandler);
        this.comboBoxEditorComponent.addFocusListener(this.selectTextOnFocusGainHandler);
    }

    private void undecorateOriginalUI() {
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.arrowButtonMouseListener);
            this.arrowButton.addMouseListener(this.arrowButtonMouseListener.getDecorated());
        }
        this.comboBox.getModel().removeListDataListener(this.listDataHandler);
        this.document.setDocumentFilter(null);
        if (this.comboBox.getEditor() == this.comboBoxEditor) {
            this.comboBox.setEditor(this.comboBoxEditor.getDelegate());
        }
        this.popupMenu.removePopupMenuListener(this.popupSizerHandler);
        this.popupLocationFix.uninstall();
        this.popup.getList().removeMouseListener(this.popupMouseHandler);
        ActionMap actionMap = this.comboBox.getActionMap();
        actionMap.put("selectPrevious", this.originalSelectPreviousAction);
        actionMap.put("selectNext", this.originalSelectNextAction);
        actionMap.put("selectPrevious2", this.originalSelectPrevious2Action);
        actionMap.put("selectNext2", this.originalSelectNext2Action);
        actionMap.put("aquaSelectPrevious", this.originalAquaSelectPreviousAction);
        actionMap.put("aquaSelectNext", this.originalAquaSelectNextAction);
        this.comboBoxEditorComponent.removeKeyListener(this.strictModeBackspaceHandler);
        this.comboBoxEditorComponent.removeFocusListener(this.selectTextOnFocusGainHandler);
        if (this.comboBox.getRenderer() == this.renderer) {
            this.comboBox.setRenderer(this.originalRenderer);
        }
        this.originalRenderer = null;
        this.comboBoxEditor = null;
        this.comboBoxEditorComponent = null;
        this.document = null;
        this.popupMenu = null;
        this.popup = null;
        this.arrowButton = null;
    }

    public static <E> AutoCompleteSupport<E> install(JComboBox<E> jComboBox, EventList<E> eventList) {
        return AutoCompleteSupport.install(jComboBox, eventList, null);
    }

    public static <E> AutoCompleteSupport<E> install(JComboBox<E> jComboBox, EventList<E> eventList, TextFilterator<? super E> textFilterator) {
        return AutoCompleteSupport.install(jComboBox, eventList, textFilterator, null);
    }

    public static <E> AutoCompleteSupport<E> install(JComboBox<E> jComboBox, EventList<E> eventList, TextFilterator<? super E> textFilterator, Format format) {
        AutoCompleteSupport.checkAccessThread();
        Component component = jComboBox.getEditor().getEditorComponent();
        if (!(component instanceof JTextField)) {
            throw new IllegalArgumentException("comboBox must use a JTextField as its editor component");
        }
        if (!(((JTextField)component).getDocument() instanceof AbstractDocument)) {
            throw new IllegalArgumentException("comboBox must use a JTextField backed by an AbstractDocument as its editor component");
        }
        if (jComboBox.getModel().getClass() == AutoCompleteComboBoxModel.class) {
            throw new IllegalArgumentException("comboBox is already configured for autocompletion");
        }
        return new AutoCompleteSupport<E>(jComboBox, eventList, textFilterator, format);
    }

    private void throwIllegalStateException(String string) {
        String string2 = string + "\nIn order for AutoCompleteSupport to continue to work, the following invariants must be maintained after AutoCompleteSupport.install() has been called:\n* the ComboBoxModel may not be removed\n* the AbstractDocument behind the JTextField can be changed but must be changed to some subclass of AbstractDocument\n* the DocumentFilter on the AbstractDocument behind the JTextField may not be removed\n";
        this.uninstall();
        throw new IllegalStateException(string2);
    }

    private String convertToString(Object object) {
        if (object == NOT_FOUND) {
            return "NOT_FOUND";
        }
        if (this.format != null) {
            return this.format.format(object);
        }
        return object == null ? "" : object.toString();
    }

    public JComboBox<E> getComboBox() {
        return this.comboBox;
    }

    public TextFilterator<? super E> getTextFilterator() {
        return this.filterMatcherEditor.getFilterator();
    }

    public EventList<E> getItemList() {
        return this.filteredItems;
    }

    public boolean getCorrectsCase() {
        return this.correctsCase;
    }

    public void setCorrectsCase(boolean bl) {
        AutoCompleteSupport.checkAccessThread();
        this.correctsCase = bl;
    }

    public boolean isStrict() {
        return this.strict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrict(boolean bl) {
        AutoCompleteSupport.checkAccessThread();
        if (this.strict == bl) {
            return;
        }
        this.strict = bl;
        if (bl) {
            String string = this.comboBoxEditorComponent.getText();
            Object object = this.findAutoCompleteTerm(string);
            String string2 = this.convertToString(object);
            boolean bl2 = object == this.comboBox.getSelectedItem();
            boolean bl3 = Objects.equals(string2, string);
            if (object == NOT_FOUND && !this.allItemsUnfiltered.isEmpty()) {
                object = this.allItemsUnfiltered.get(0);
                string2 = this.convertToString(object);
                bl2 = object == this.comboBox.getSelectedItem();
                bl3 = Objects.equals(string2, string);
            }
            this.applyFilter("");
            this.doNotPostProcessDocumentChanges = true;
            try {
                if (!bl3) {
                    this.comboBoxEditorComponent.setText(string2);
                }
                if (!bl2 || this.comboBox.getSelectedIndex() == -1) {
                    this.comboBox.setSelectedItem(object);
                }
            }
            finally {
                this.doNotPostProcessDocumentChanges = false;
            }
        }
    }

    public boolean getBeepOnStrictViolation() {
        return this.beepOnStrictViolation;
    }

    public void setBeepOnStrictViolation(boolean bl) {
        AutoCompleteSupport.checkAccessThread();
        this.beepOnStrictViolation = bl;
    }

    public boolean getSelectsTextOnFocusGain() {
        return this.selectsTextOnFocusGain;
    }

    public void setSelectsTextOnFocusGain(boolean bl) {
        AutoCompleteSupport.checkAccessThread();
        this.selectsTextOnFocusGain = bl;
    }

    public boolean getHidesPopupOnFocusLost() {
        return this.hidesPopupOnFocusLost;
    }

    public void setHidesPopupOnFocusLost(boolean bl) {
        AutoCompleteSupport.checkAccessThread();
        this.hidesPopupOnFocusLost = bl;
    }

    public int getFilterMode() {
        return this.filterMatcherEditor.getMode();
    }

    public void setFilterMode(int n2) {
        AutoCompleteSupport.checkAccessThread();
        this.doNotChangeDocument = true;
        try {
            this.filterMatcherEditor.setMode(n2);
            this.filterMatcher = n2 == 0 ? new ContainsFilter() : new PrefixFilter();
        }
        finally {
            this.doNotChangeDocument = false;
        }
    }

    public void setTextMatchingStrategy(Object object) {
        AutoCompleteSupport.checkAccessThread();
        this.doNotChangeDocument = true;
        try {
            this.filterMatcherEditor.setStrategy(object);
        }
        finally {
            this.doNotChangeDocument = false;
        }
    }

    public Object getTextMatchingStrategy() {
        return this.filterMatcherEditor.getStrategy();
    }

    public void setFirstItem(E e2) {
        AutoCompleteSupport.checkAccessThread();
        this.doNotChangeDocument = true;
        this.firstItem.getReadWriteLock().writeLock().lock();
        try {
            if (this.firstItem.isEmpty()) {
                this.firstItem.add(e2);
            } else {
                this.firstItem.set(0, e2);
            }
        }
        finally {
            this.firstItem.getReadWriteLock().writeLock().unlock();
            this.doNotChangeDocument = false;
        }
    }

    public E getFirstItem() {
        this.firstItem.getReadWriteLock().readLock().lock();
        try {
            E e2 = this.firstItem.isEmpty() ? null : (E)this.firstItem.get(0);
            return e2;
        }
        finally {
            this.firstItem.getReadWriteLock().readLock().unlock();
        }
    }

    public E removeFirstItem() {
        AutoCompleteSupport.checkAccessThread();
        this.doNotChangeDocument = true;
        this.firstItem.getReadWriteLock().writeLock().lock();
        try {
            E e2 = this.firstItem.isEmpty() ? null : (E)this.firstItem.remove(0);
            return e2;
        }
        finally {
            this.firstItem.getReadWriteLock().writeLock().unlock();
            this.doNotChangeDocument = false;
        }
    }

    public boolean isInstalled() {
        AutoCompleteSupport.checkAccessThread();
        return this.comboBox != null;
    }

    public void uninstall() {
        AutoCompleteSupport.checkAccessThread();
        if (this.comboBox == null) {
            throw new IllegalStateException("This AutoCompleteSupport has already been uninstalled");
        }
        this.items.getReadWriteLock().readLock().lock();
        try {
            this.comboBox.removePropertyChangeListener("UI", this.uiWatcher);
            this.comboBox.removePropertyChangeListener("model", this.modelWatcher);
            this.comboBoxEditorComponent.removePropertyChangeListener("document", this.documentWatcher);
            this.undecorateOriginalUI();
            this.comboBox.setModel(this.originalModel);
            this.originalModel = null;
            this.comboBox.setEditable(this.originalComboBoxEditable);
            this.comboBoxModel.dispose();
            this.allItemsFiltered.dispose();
            this.allItemsUnfiltered.dispose();
            this.filteredItems.dispose();
            this.comboBox = null;
        }
        finally {
            this.items.getReadWriteLock().readLock().unlock();
        }
    }

    private void applyFilter(String string) {
        if (this.doNotFilter) {
            return;
        }
        this.doNotChangeDocument = true;
        ActionListener[] actionListenerArray = AutoCompleteSupport.unregisterAllActionListeners(this.comboBox);
        this.isFiltering = true;
        try {
            this.filterMatcherEditor.setFilterText(new String[]{string});
        }
        finally {
            this.isFiltering = false;
            AutoCompleteSupport.registerAllActionListeners(this.comboBox, actionListenerArray);
            this.doNotChangeDocument = false;
        }
    }

    private void togglePopup() {
        if (this.doNotTogglePopup) {
            return;
        }
        if (this.comboBoxModel.getSize() == 0) {
            this.comboBox.hidePopup();
        } else if (this.comboBox.isShowing() && !this.comboBox.isPopupVisible() && this.comboBoxEditorComponent.hasFocus()) {
            this.comboBox.showPopup();
        }
    }

    private Object findAutoCompleteTerm(String string) {
        boolean bl = "".equals(string);
        TextMatcher<String> textMatcher = new TextMatcher<String>(new SearchTerm[]{new SearchTerm(string)}, GlazedLists.toStringTextFilterator(), this.getFilterMode(), this.getTextMatchingStrategy());
        Object object = NOT_FOUND;
        int n2 = this.allItemsUnfiltered.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = this.allItemsUnfiltered.get(i2);
            String string2 = this.convertToString(e2);
            if (string.equals(string2)) {
                return e2;
            }
            if (object != NOT_FOUND || !(bl ? "".equals(string2) : textMatcher.matches(string2))) continue;
            object = e2;
        }
        return object;
    }

    private boolean isSelectNSContains() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty(GL_ENABLE_NON_STRICT_CONTAINS_SELECTION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectPossibleValue(int n2) {
        Object object;
        block20: {
            boolean bl;
            if (this.isStrict()) {
                if (n2 < 0) {
                    n2 = this.comboBox.getModel().getSize() - 1;
                }
                if (n2 > this.comboBox.getModel().getSize() - 1) {
                    n2 = 0;
                }
            } else if (n2 == -2) {
                n2 = this.comboBox.getModel().getSize() - 1;
            }
            boolean bl2 = bl = n2 >= 0 && n2 < this.comboBox.getModel().getSize();
            if (!bl) {
                n2 = -1;
            }
            this.doNotPostProcessDocumentChanges = true;
            try {
                if (this.isTableCellEditor) {
                    object = AutoCompleteSupport.unregisterAllActionListeners(this.comboBox);
                    try {
                        this.comboBox.setSelectedIndex(n2);
                    }
                    finally {
                        AutoCompleteSupport.registerAllActionListeners(this.comboBox, object);
                    }
                } else {
                    this.comboBox.setSelectedIndex(n2);
                }
                if (bl) break block20;
                this.comboBoxEditorComponent.setText(this.filterMatcher.input);
                this.doNotClearFilterOnPopupHide = true;
                try {
                    this.comboBox.hidePopup();
                }
                finally {
                    this.doNotClearFilterOnPopupHide = false;
                }
                this.comboBox.showPopup();
            }
            finally {
                this.doNotPostProcessDocumentChanges = false;
            }
        }
        object = this.comboBoxEditorComponent.getText();
        this.filterMatcher.findInputInString("");
        if (!this.isSelectNSContains() && !this.isStrict() && this.getFilterMode() == 0) {
            TextMatcher<ActionListener[]> textMatcher = new TextMatcher<ActionListener[]>(new SearchTerm[]{new SearchTerm(this.filterMatcher.input)}, GlazedLists.toStringTextFilterator(), 1, this.getTextMatchingStrategy());
            if (textMatcher.matches((ActionListener[])object)) {
                this.comboBoxEditorComponent.select(this.filterMatcher.input.length(), this.document.getLength());
            }
            return;
        }
        if (this.filterMatcher.matches((String)object)) {
            this.filterMatcher.findInputInString((String)object);
            this.filterMatcher.visualizeUserInputText();
        }
    }

    public static <E> AutoCompleteCellEditor<E> createTableCellEditor(TableFormat<E> tableFormat, EventList<E> eventList, int n2) {
        return AutoCompleteSupport.createTableCellEditor(GlazedLists.comparableComparator(), tableFormat, eventList, n2);
    }

    public static <E> AutoCompleteCellEditor<E> createTableCellEditor(Comparator comparator, TableFormat<E> tableFormat, EventList<E> eventList, int n2) {
        TableColumnValueFunction<E> tableColumnValueFunction = new TableColumnValueFunction<E>(tableFormat, n2);
        FunctionList functionList = new FunctionList(eventList, tableColumnValueFunction);
        UniqueList uniqueList = new UniqueList(functionList, comparator);
        return AutoCompleteSupport.createTableCellEditor(uniqueList);
    }

    public static <E> AutoCompleteCellEditor<E> createTableCellEditor(EventList<E> eventList) {
        TableCellComboBox tableCellComboBox = new TableCellComboBox();
        tableCellComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        AutoCompleteSupport autoCompleteSupport = AutoCompleteSupport.install(tableCellComboBox, eventList);
        autoCompleteSupport.setSelectsTextOnFocusGain(false);
        AutoCompleteCellEditor autoCompleteCellEditor = new AutoCompleteCellEditor(autoCompleteSupport);
        autoCompleteCellEditor.setClickCountToStart(2);
        return autoCompleteCellEditor;
    }

    private static final class TableColumnValueFunction<E>
    implements FunctionList.Function<E, Object> {
        private final TableFormat<E> tableFormat;
        private final int columnIndex;

        public TableColumnValueFunction(TableFormat<E> tableFormat, int n2) {
            this.tableFormat = tableFormat;
            this.columnIndex = n2;
        }

        @Override
        public Object evaluate(E e2) {
            return this.tableFormat.getColumnValue(e2, this.columnIndex);
        }
    }

    private static final class TableCellComboBox<E>
    extends JComboBox<E>
    implements FocusListener {
        public TableCellComboBox() {
            this.setEditor(new TableCellComboBoxEditor());
            TableCellComboBox.replaceUIDelegateFocusListener(this.getEditor().getEditorComponent(), this);
            TableCellComboBox.replaceUIDelegateFocusListener(this, this);
        }

        private static void replaceUIDelegateFocusListener(Component component, FocusListener focusListener) {
            FocusListener[] focusListenerArray = component.getFocusListeners();
            for (int i2 = 0; i2 < focusListenerArray.length; ++i2) {
                if (focusListenerArray[i2].getClass().getName().indexOf("ComboBoxUI") == -1) continue;
                component.removeFocusListener(focusListenerArray[i2]);
            }
            component.addFocusListener(focusListener);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ComboBoxEditor comboBoxEditor = this.getEditor();
            if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() != focusEvent.getSource()) {
                this.repaint();
                if (this.isEditable()) {
                    comboBoxEditor.getEditorComponent().requestFocus();
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Object object;
            ComboBoxEditor comboBoxEditor = this.getEditor();
            if (!focusEvent.isTemporary() && comboBoxEditor != null && comboBoxEditor.getEditorComponent() == focusEvent.getSource() && (object = comboBoxEditor.getItem()) != null && !object.equals(this.getSelectedItem())) {
                this.fireActionPerformed(comboBoxEditor);
            }
            this.repaint();
        }

        private void fireActionPerformed(ComboBoxEditor comboBoxEditor) {
            this.actionPerformed(new ActionEvent(comboBoxEditor, 0, "", EventQueue.getMostRecentEventTime(), 0));
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl) {
            TableCellTextField tableCellTextField = (TableCellTextField)this.getEditor().getEditorComponent();
            tableCellTextField.processKeyBinding(keyStroke, keyEvent, n2, bl);
            if (!tableCellTextField.hasFocus()) {
                tableCellTextField.requestFocus();
            }
            return super.processKeyBinding(keyStroke, keyEvent, n2, bl);
        }

        @Override
        public void setNextFocusableComponent(Component component) {
            super.setNextFocusableComponent(component);
            ((JComponent)this.getEditor().getEditorComponent()).setNextFocusableComponent(component);
        }

        private static class TableCellTextField
        extends JTextField {
            public TableCellTextField() {
                super("", 9);
            }

            @Override
            public void setText(String string) {
                if (!this.equalsText(string)) {
                    super.setText(string);
                }
            }

            private boolean equalsText(String string) {
                String string2 = this.getText();
                return string2 == null ? string == null : string2.equals(string);
            }

            @Override
            public void setBorder(Border border) {
            }

            @Override
            public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl) {
                return super.processKeyBinding(keyStroke, keyEvent, n2, bl);
            }
        }

        private static final class TableCellComboBoxEditor
        extends BasicComboBoxEditor {
            public TableCellComboBoxEditor() {
                this.editor = new TableCellTextField();
            }
        }
    }

    public static class AutoCompleteCellEditor<E>
    extends DefaultCellEditor {
        private final AutoCompleteSupport<E> autoCompleteSupport;

        public AutoCompleteCellEditor(AutoCompleteSupport<E> autoCompleteSupport) {
            super(autoCompleteSupport.getComboBox());
            this.autoCompleteSupport = autoCompleteSupport;
        }

        public AutoCompleteSupport<E> getAutoCompleteSupport() {
            return this.autoCompleteSupport;
        }
    }

    class DefaultTextFilterator
    implements TextFilterator<E> {
        DefaultTextFilterator() {
        }

        @Override
        public void getFilterStrings(List<String> list, E e2) {
            list.add(AutoCompleteSupport.this.convertToString(e2));
        }
    }

    private class FormatComboBoxEditor
    implements ComboBoxEditor,
    UIResource {
        private final ComboBoxEditor delegate;
        private Object oldValue;

        public FormatComboBoxEditor(ComboBoxEditor comboBoxEditor) {
            this.delegate = comboBoxEditor;
        }

        public ComboBoxEditor getDelegate() {
            return this.delegate;
        }

        @Override
        public void setItem(Object object) {
            this.oldValue = object;
            ((JTextField)this.getEditorComponent()).setText(AutoCompleteSupport.this.convertToString(object));
        }

        @Override
        public Object getItem() {
            String string;
            String string2 = AutoCompleteSupport.this.convertToString(this.oldValue);
            if (Objects.equals(string2, string = ((JTextField)this.getEditorComponent()).getText())) {
                return this.oldValue;
            }
            if (AutoCompleteSupport.this.format != null) {
                return AutoCompleteSupport.this.format.parseObject(string, PARSE_POSITION);
            }
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                try {
                    Method method = this.oldValue.getClass().getMethod("valueOf", VALUE_OF_SIGNATURE);
                    return method.invoke(this.oldValue, string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string;
        }

        @Override
        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        @Override
        public void selectAll() {
            this.delegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.delegate.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.delegate.removeActionListener(actionListener);
        }
    }

    private class StringFunctionRenderer
    extends DefaultListCellRenderer {
        private StringFunctionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n2, boolean bl, boolean bl2) {
            String string = AutoCompleteSupport.this.convertToString(object);
            if (string.length() == 0) {
                string = " ";
            }
            return super.getListCellRendererComponent(jList, string, n2, bl, bl2);
        }
    }

    private class DocumentWatcher
    implements PropertyChangeListener {
        private DocumentWatcher() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Document document = (Document)propertyChangeEvent.getNewValue();
            if (!(document instanceof AbstractDocument)) {
                AutoCompleteSupport.this.throwIllegalStateException("The Document behind the JTextField was changed to no longer be an AbstractDocument. It was changed to: " + document);
            }
            AutoCompleteSupport.this.document.setDocumentFilter(null);
            AutoCompleteSupport.this.document = (AbstractDocument)document;
            AutoCompleteSupport.this.document.setDocumentFilter(AutoCompleteSupport.this.documentFilter);
        }
    }

    private class ModelWatcher
    implements PropertyChangeListener {
        private ModelWatcher() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AutoCompleteSupport.this.throwIllegalStateException("The ComboBoxModel cannot be changed. It was changed to: " + propertyChangeEvent.getNewValue());
        }
    }

    private class UIWatcher
    implements PropertyChangeListener {
        private UIWatcher() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AutoCompleteSupport.this.undecorateOriginalUI();
            AutoCompleteSupport.this.decorateCurrentUI();
        }
    }

    private class ComboBoxEditorFocusHandler
    extends FocusAdapter {
        private ComboBoxEditorFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (AutoCompleteSupport.this.getSelectsTextOnFocusGain()) {
                AutoCompleteSupport.this.comboBoxEditorComponent.select(0, AutoCompleteSupport.this.comboBoxEditorComponent.getText().length());
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (AutoCompleteSupport.this.comboBox.isPopupVisible() && AutoCompleteSupport.this.getHidesPopupOnFocusLost()) {
                AutoCompleteSupport.this.comboBox.setPopupVisible(false);
            }
        }
    }

    private class AutoCompleteKeyHandler
    extends KeyAdapter {
        private ActionListener[] actionListeners;

        private AutoCompleteKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!AutoCompleteSupport.this.isTableCellEditor) {
                AutoCompleteSupport.this.doNotTogglePopup = false;
            }
            if (keyEvent.getKeyChar() == '\n') {
                AutoCompleteSupport.this.doNotChangeDocument = true;
                this.actionListeners = AutoCompleteSupport.unregisterAllActionListeners(AutoCompleteSupport.this.comboBox);
            }
            if (this.isTrigger(keyEvent)) {
                AutoCompleteSupport.this.doNotChangeDocument = true;
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.isTrigger(keyEvent)) {
                if (AutoCompleteSupport.this.comboBoxEditorComponent.getText().length() == 0) {
                    return;
                }
                int n2 = Math.min(AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionStart(), AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionEnd());
                if (n2 == 0) {
                    if (AutoCompleteSupport.this.getBeepOnStrictViolation()) {
                        UIManager.getLookAndFeel().provideErrorFeedback(AutoCompleteSupport.this.comboBoxEditorComponent);
                    }
                    return;
                }
                AutoCompleteSupport.this.comboBoxEditorComponent.setCaretPosition(AutoCompleteSupport.this.comboBoxEditorComponent.getText().length());
                AutoCompleteSupport.this.comboBoxEditorComponent.moveCaretPosition(--n2);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.isTrigger(keyEvent)) {
                AutoCompleteSupport.this.doNotChangeDocument = false;
            }
            if (keyEvent.getKeyChar() == '\n') {
                AutoCompleteSupport.this.filterMatcher.updateFilter(AutoCompleteSupport.this.comboBoxEditorComponent.getText());
                AutoCompleteSupport.this.filterMatcher.findInputInString("");
                if (this.actionListeners != null) {
                    AutoCompleteSupport.registerAllActionListeners(AutoCompleteSupport.this.comboBox, this.actionListeners);
                    AutoCompleteSupport.this.comboBox.actionPerformed(new ActionEvent(keyEvent.getSource(), keyEvent.getID(), null));
                }
                this.actionListeners = null;
                AutoCompleteSupport.this.doNotChangeDocument = false;
            }
            if (!AutoCompleteSupport.this.isTableCellEditor) {
                AutoCompleteSupport.this.doNotTogglePopup = true;
            }
        }

        private boolean isTrigger(KeyEvent keyEvent) {
            return AutoCompleteSupport.this.isStrict() && keyEvent.getKeyChar() == '\b';
        }
    }

    private class ArrowButtonMouseListener
    implements MouseListener {
        private final MouseListener decorated;

        public ArrowButtonMouseListener(MouseListener mouseListener) {
            this.decorated = mouseListener;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            AutoCompleteSupport.this.applyFilter("");
            this.decorated.mousePressed(mouseEvent);
        }

        public MouseListener getDecorated() {
            return this.decorated;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.decorated.mouseClicked(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.decorated.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.decorated.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.decorated.mouseExited(mouseEvent);
        }
    }

    private class PopupMouseHandler
    extends MouseAdapter {
        private PopupMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            AutoCompleteSupport.this.doNotAutoComplete = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            AutoCompleteSupport.this.doNotAutoComplete = false;
        }
    }

    private class PopupSizer
    implements PopupMenuListener {
        private PopupSizer() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Object e2 = AutoCompleteSupport.this.comboBox.getPrototypeDisplayValue();
            if (e2 == null) {
                return;
            }
            JComponent jComponent = (JComponent)popupMenuEvent.getSource();
            if (jComponent.getComponent(0) instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)jComponent.getComponent(0);
                Dimension dimension = jScrollPane.getPreferredSize();
                Dimension dimension2 = this.getPrototypeSize(e2);
                dimension2.width += jScrollPane.getVerticalScrollBar().getPreferredSize().width;
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                    jScrollPane.setMaximumSize(dimension);
                    jScrollPane.setPreferredSize(dimension);
                    jScrollPane.setMinimumSize(dimension);
                }
            }
        }

        private Dimension getPrototypeSize(E e2) {
            DefaultListCellRenderer defaultListCellRenderer = AutoCompleteSupport.this.comboBox.getRenderer();
            if (defaultListCellRenderer == null) {
                defaultListCellRenderer = new DefaultListCellRenderer();
            }
            Component component = defaultListCellRenderer.getListCellRendererComponent(AutoCompleteSupport.this.popup.getList(), e2, -1, false, false);
            component.setFont(AutoCompleteSupport.this.comboBox.getFont());
            return component.getPreferredSize();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (AutoCompleteSupport.this.doNotClearFilterOnPopupHide) {
                return;
            }
            AutoCompleteSupport.this.applyFilter("");
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class ListDataHandler
    implements ListDataListener {
        private int previousItemCount = -1;
        private final Runnable checkStrictModeInvariantRunnable = new CheckStrictModeInvariantRunnable();

        private ListDataHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            int n2;
            int n3 = AutoCompleteSupport.this.comboBox.getItemCount();
            if (this.previousItemCount != n3) {
                n2 = AutoCompleteSupport.this.comboBox.getMaximumRowCount();
                if (AutoCompleteSupport.this.popupMenu.isShowing()) {
                    if (AutoCompleteSupport.this.comboBox.isShowing()) {
                        if (n3 < n2 || this.previousItemCount < n2) {
                            AutoCompleteSupport.this.doNotClearFilterOnPopupHide = true;
                            try {
                                AutoCompleteSupport.this.comboBox.hidePopup();
                            }
                            finally {
                                AutoCompleteSupport.this.doNotClearFilterOnPopupHide = false;
                            }
                            AutoCompleteSupport.this.comboBox.showPopup();
                        }
                    } else {
                        AutoCompleteSupport.this.comboBox.hidePopup();
                    }
                }
                this.previousItemCount = n3;
            }
            int n4 = n2 = listDataEvent.getIndex0() == -1 || listDataEvent.getIndex1() == -1 ? 1 : 0;
            if (AutoCompleteSupport.this.isStrict() && n2 == 0 && !AutoCompleteSupport.this.isFiltering) {
                SwingUtilities.invokeLater(this.checkStrictModeInvariantRunnable);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        private class CheckStrictModeInvariantRunnable
        implements Runnable {
            private CheckStrictModeInvariantRunnable() {
            }

            @Override
            public void run() {
                Object object;
                String string;
                String string2;
                JTextField jTextField = AutoCompleteSupport.this.comboBoxEditorComponent;
                if (jTextField != null && !(string2 = jTextField.getText()).equals(string = AutoCompleteSupport.this.convertToString(object = AutoCompleteSupport.this.findAutoCompleteTerm(string2)))) {
                    if (object == NOT_FOUND && !AutoCompleteSupport.this.allItemsUnfiltered.isEmpty()) {
                        string = AutoCompleteSupport.this.convertToString(AutoCompleteSupport.this.allItemsUnfiltered.get(0));
                    }
                    jTextField.setText(string);
                }
            }
        }
    }

    private class MoveAction
    extends AbstractAction {
        private final int offset;

        public MoveAction(int n2) {
            this.offset = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompleteSupport.this.comboBox.isShowing()) {
                if (AutoCompleteSupport.this.comboBox.isPopupVisible()) {
                    AutoCompleteSupport.this.selectPossibleValue(AutoCompleteSupport.this.comboBox.getSelectedIndex() + this.offset);
                } else {
                    AutoCompleteSupport.this.applyFilter(((AutoCompleteSupport)AutoCompleteSupport.this).filterMatcher.input);
                    AutoCompleteSupport.this.comboBox.showPopup();
                }
            }
        }
    }

    private class AutoCompleteFilter
    extends DocumentFilter {
        private AutoCompleteFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl;
            if (AutoCompleteSupport.this.doNotChangeDocument) {
                return;
            }
            String string2 = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            int n4 = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionStart();
            int n5 = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionEnd();
            boolean bl2 = bl = n2 == 0 && AutoCompleteSupport.this.document.getLength() == n3;
            if (bl && string2.equals(string)) {
                return;
            }
            super.replace(filterBypass, n2, n3, string, attributeSet);
            this.postProcessDocumentChange(filterBypass, attributeSet, string2, n4, n5, true);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (AutoCompleteSupport.this.doNotChangeDocument) {
                return;
            }
            String string2 = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            int n3 = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionStart();
            int n4 = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionEnd();
            super.insertString(filterBypass, n2, string, attributeSet);
            this.postProcessDocumentChange(filterBypass, attributeSet, string2, n3, n4, true);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n2, int n3) throws BadLocationException {
            if (AutoCompleteSupport.this.doNotChangeDocument) {
                return;
            }
            String string = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            int n4 = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionStart();
            int n5 = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionEnd();
            super.remove(filterBypass, n2, n3);
            this.postProcessDocumentChange(filterBypass, null, string, n4, n5, AutoCompleteSupport.this.isStrict());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postProcessDocumentChange(DocumentFilter.FilterBypass filterBypass, AttributeSet attributeSet, String string, int n2, int n3, boolean bl) throws BadLocationException {
            if (AutoCompleteSupport.this.doNotPostProcessDocumentChanges) {
                return;
            }
            String string2 = AutoCompleteSupport.this.filterMatcher.determineInput();
            if (AutoCompleteSupport.this.isStrict() && AutoCompleteSupport.this.findAutoCompleteTerm(string2) == NOT_FOUND && !AutoCompleteSupport.this.allItemsUnfiltered.isEmpty()) {
                if (AutoCompleteSupport.this.getBeepOnStrictViolation()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(AutoCompleteSupport.this.comboBoxEditorComponent);
                }
                AutoCompleteSupport.this.doNotPostProcessDocumentChanges = true;
                try {
                    AutoCompleteSupport.this.comboBoxEditorComponent.setText(string);
                }
                finally {
                    AutoCompleteSupport.this.doNotPostProcessDocumentChanges = false;
                }
                AutoCompleteSupport.this.comboBoxEditorComponent.select(n2, n3);
                return;
            }
            Object object = AutoCompleteSupport.this.comboBox.getSelectedItem();
            AutoCompleteSupport.this.filterMatcher.updateFilter(string2);
            AutoCompleteSupport.this.applyFilter(((AutoCompleteSupport)AutoCompleteSupport.this).filterMatcher.input);
            this.selectAutoCompleteTerm(filterBypass, attributeSet, object, bl);
            AutoCompleteSupport.this.togglePopup();
        }

        private void selectAutoCompleteTerm(DocumentFilter.FilterBypass filterBypass, AttributeSet attributeSet, Object object, boolean bl) throws BadLocationException {
            int n2;
            if (AutoCompleteSupport.this.doNotAutoComplete) {
                return;
            }
            String string = ((AutoCompleteSupport)AutoCompleteSupport.this).filterMatcher.input;
            boolean bl2 = string.isEmpty();
            int n3 = AutoCompleteSupport.this.comboBoxEditorComponent.getCaretPosition();
            String string2 = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            boolean bl3 = false;
            int n4 = AutoCompleteSupport.this.comboBoxModel.getSize();
            for (n2 = 0; n2 < n4; ++n2) {
                int n5;
                String string3 = AutoCompleteSupport.this.convertToString(AutoCompleteSupport.this.comboBoxModel.getElementAt(n2));
                if (bl2 ? !string3.isEmpty() : !AutoCompleteSupport.this.filterMatcher.matches(string3)) continue;
                int n6 = n2;
                String string4 = string3;
                int n7 = 0;
                String string5 = null;
                TextMatcher<String> textMatcher = null;
                if (AutoCompleteSupport.this.getFilterMode() == 0) {
                    textMatcher = new TextMatcher<String>(new SearchTerm[]{new SearchTerm(string)}, GlazedLists.toStringTextFilterator(), 1, AutoCompleteSupport.this.getTextMatchingStrategy());
                }
                for (n5 = n2; n5 < n4; ++n5) {
                    string3 = AutoCompleteSupport.this.convertToString(AutoCompleteSupport.this.comboBoxModel.getElementAt(n5));
                    if (string.equals(string3)) {
                        n6 = n5;
                        string4 = string3;
                        bl3 = true;
                        break;
                    }
                    if (textMatcher == null || string5 != null || !textMatcher.matches(string3)) continue;
                    n7 = n5;
                    string5 = string3;
                }
                if (!bl && !string.equals(string3)) {
                    return;
                }
                if (!AutoCompleteSupport.this.isSelectNSContains() && !AutoCompleteSupport.this.isStrict() && AutoCompleteSupport.this.getFilterMode() == 0 && string5 == null && !bl3) break;
                if (!bl3 && string5 != null) {
                    n6 = n7;
                    string4 = string5;
                }
                AutoCompleteSupport.this.filterMatcher.findInputInString(string4);
                if (AutoCompleteSupport.this.getCorrectsCase() || AutoCompleteSupport.this.isStrict()) {
                    filterBypass.replace(0, AutoCompleteSupport.this.document.getLength(), string4, attributeSet);
                } else {
                    int n8;
                    n5 = AutoCompleteSupport.this.filterMatcher.getInputOffset();
                    if (n5 + (n8 = string.length()) <= string4.length()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(string4.substring(0, n5)).append(string).append(string4.substring(n5 + n8));
                        filterBypass.replace(0, AutoCompleteSupport.this.document.getLength(), stringBuilder.toString(), attributeSet);
                    } else {
                        filterBypass.replace(0, AutoCompleteSupport.this.document.getLength(), string4, attributeSet);
                    }
                }
                n5 = AutoCompleteSupport.this.isTableCellEditor || Objects.equals(object, string4) ? 1 : 0;
                this.selectItem(n6, n5 != 0);
                if (bl3 && string2.equals(string)) {
                    AutoCompleteSupport.this.comboBoxEditorComponent.setCaretPosition(n3);
                } else {
                    AutoCompleteSupport.this.filterMatcher.visualizeUserInputText();
                }
                return;
            }
            if (!string2.equals(string)) {
                filterBypass.replace(0, AutoCompleteSupport.this.document.getLength(), string, attributeSet);
            }
            n2 = AutoCompleteSupport.this.isTableCellEditor || object == null ? 1 : 0;
            this.selectItem(-1, n2 != 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void selectItem(int n2, boolean bl) {
            Object var3_3;
            Object v0 = var3_3 = n2 == -1 ? null : AutoCompleteSupport.this.comboBoxModel.getElementAt(n2);
            if (Objects.equals(AutoCompleteSupport.this.comboBoxModel.getSelectedItem(), var3_3)) {
                return;
            }
            AutoCompleteSupport.this.doNotChangeDocument = true;
            try {
                if (bl) {
                    AutoCompleteSupport.this.comboBoxModel.setSelectedItem(var3_3);
                } else {
                    AutoCompleteSupport.this.comboBox.setSelectedItem(var3_3);
                }
            }
            finally {
                AutoCompleteSupport.this.doNotChangeDocument = false;
            }
        }
    }

    private class AutoCompleteComboBoxModel
    extends EventComboBoxModel<E> {
        public AutoCompleteComboBoxModel(EventList<E> eventList) {
            super(eventList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSelectedItem(Object object) {
            AutoCompleteSupport.this.doNotFilter = true;
            AutoCompleteSupport.this.doNotAutoComplete = true;
            ActionListener[] actionListenerArray = AutoCompleteSupport.unregisterAllActionListeners(AutoCompleteSupport.this.comboBox);
            try {
                super.setSelectedItem(object);
                if (AutoCompleteSupport.this.comboBoxEditorComponent != null) {
                    int n2 = AutoCompleteSupport.this.comboBoxEditorComponent.getCaretPosition();
                    AutoCompleteSupport.this.comboBoxEditorComponent.select(n2, n2);
                }
            }
            finally {
                AutoCompleteSupport.registerAllActionListeners(AutoCompleteSupport.this.comboBox, actionListenerArray);
                AutoCompleteSupport.this.doNotFilter = false;
                AutoCompleteSupport.this.doNotAutoComplete = false;
            }
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            AutoCompleteSupport.this.doNotChangeDocument = true;
            try {
                super.listChanged(listEvent);
            }
            finally {
                AutoCompleteSupport.this.doNotChangeDocument = false;
            }
        }
    }

    private class ContainsFilter
    extends UserInputFilter {
        private int inputOffset;

        private ContainsFilter() {
        }

        @Override
        void updateFilter(String string) {
            this.updateFilterCommon(string, 0);
        }

        @Override
        String determineInput() {
            String string = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            if (string.length() <= this.inputOffset) {
                this.inputOffset = 0;
            } else {
                string = string.substring(this.inputOffset);
            }
            return string;
        }

        @Override
        void visualizeUserInputText() {
            AutoCompleteSupport.this.comboBoxEditorComponent.select(this.inputOffset + this.input.length(), AutoCompleteSupport.this.document.getLength());
        }

        @Override
        void findInputInString(String string) {
            int n2 = this.indexOf(string);
            this.inputOffset = n2 < 0 ? 0 : n2;
        }

        @Override
        int getInputOffset() {
            return this.inputOffset;
        }
    }

    private class PrefixFilter
    extends UserInputFilter {
        private PrefixFilter() {
        }

        @Override
        void updateFilter(String string) {
            this.updateFilterCommon(string, 1);
        }

        @Override
        String determineInput() {
            return AutoCompleteSupport.this.comboBoxEditorComponent.getText();
        }

        @Override
        void visualizeUserInputText() {
            AutoCompleteSupport.this.comboBoxEditorComponent.select(this.input.length(), AutoCompleteSupport.this.document.getLength());
        }

        @Override
        void findInputInString(String string) {
        }

        @Override
        int getInputOffset() {
            return 0;
        }
    }

    private abstract class UserInputFilter {
        protected Matcher<String> filterMatcher = Matchers.trueMatcher();
        protected String input = "";

        private UserInputFilter() {
        }

        abstract void updateFilter(String var1);

        boolean matches(String string) {
            return this.filterMatcher.matches(string);
        }

        abstract String determineInput();

        abstract void visualizeUserInputText();

        abstract void findInputInString(String var1);

        abstract int getInputOffset();

        protected void updateFilterCommon(String string, int n2) {
            this.input = string;
            this.filterMatcher = this.input.isEmpty() ? Matchers.trueMatcher() : new TextMatcher<String>(new SearchTerm[]{new SearchTerm(this.input)}, GlazedLists.toStringTextFilterator(), n2, AutoCompleteSupport.this.getTextMatchingStrategy());
        }

        protected int indexOf(String string) {
            Object object = AutoCompleteSupport.this.getTextMatchingStrategy();
            if (object instanceof TextSearchStrategy.Factory) {
                TextSearchStrategy textSearchStrategy = ((TextSearchStrategy.Factory)object).create(AutoCompleteSupport.this.getFilterMode(), this.input);
                textSearchStrategy.setSubtext(this.input);
                return textSearchStrategy.indexOf(string);
            }
            return -1;
        }
    }
}

