/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Comparator;

public class ThresholdMatcherEditor<E, T>
extends AbstractMatcherEditor<E> {
    public static final MatchOperation GREATER_THAN = new MatchOperation(1, false);
    public static final MatchOperation GREATER_THAN_OR_EQUAL = new MatchOperation(1, true);
    public static final MatchOperation LESS_THAN = new MatchOperation(-1, false);
    public static final MatchOperation LESS_THAN_OR_EQUAL = new MatchOperation(-1, true);
    public static final MatchOperation EQUAL = new MatchOperation(0, true);
    public static final MatchOperation NOT_EQUAL = new MatchOperation(0, false);
    private MatchOperation currentMatcher;
    private Comparator<T> comparator;
    private MatchOperation operation;
    private T threshold;
    private FunctionList.Function<E, T> function;

    public ThresholdMatcherEditor() {
        this(null);
    }

    public ThresholdMatcherEditor(T t2) {
        this(t2, null);
    }

    public ThresholdMatcherEditor(T t2, MatchOperation matchOperation) {
        this(t2, matchOperation, null);
    }

    public ThresholdMatcherEditor(T t2, MatchOperation matchOperation, Comparator<T> comparator) {
        this(t2, matchOperation, comparator, null);
    }

    public ThresholdMatcherEditor(T t2, MatchOperation matchOperation, Comparator<T> comparator, FunctionList.Function<E, T> function) {
        if (matchOperation == null) {
            matchOperation = GREATER_THAN;
        }
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        if (function == null) {
            function = GlazedListsImpl.identityFunction();
        }
        this.operation = matchOperation;
        this.comparator = comparator;
        this.threshold = t2;
        this.function = function;
        this.currentMatcher = matchOperation.instance(comparator, t2, function);
        this.fireChanged(this.currentMatcher);
    }

    public void setThreshold(T t2) {
        this.threshold = t2;
        this.rebuildMatcher();
    }

    public T getThreshold() {
        return this.threshold;
    }

    public void setMatchOperation(MatchOperation matchOperation) {
        if (matchOperation == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        this.operation = matchOperation;
        this.rebuildMatcher();
    }

    public MatchOperation getMatchOperation() {
        return this.operation;
    }

    public void setComparator(Comparator<T> comparator) {
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        this.comparator = comparator;
        this.rebuildMatcher();
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    private void rebuildMatcher() {
        MatchOperation matchOperation = this.operation.instance(this.comparator, this.threshold, this.function);
        boolean bl = matchOperation.isMoreStrict(this.currentMatcher);
        boolean bl2 = this.currentMatcher.isMoreStrict(matchOperation);
        if (!bl && !bl2) {
            return;
        }
        this.currentMatcher = matchOperation;
        if (bl && bl2) {
            this.fireChanged(this.currentMatcher);
        } else if (bl) {
            this.fireConstrained(this.currentMatcher);
        } else {
            this.fireRelaxed(this.currentMatcher);
        }
    }

    private static class MatchOperation<E, T>
    implements Matcher<E> {
        protected final Comparator<T> comparator;
        protected final T threshold;
        private final int polarity;
        private final boolean inclusive;
        private final FunctionList.Function<E, T> function;

        private MatchOperation(Comparator<T> comparator, T t2, int n2, boolean bl, FunctionList.Function<E, T> function) {
            this.comparator = comparator;
            this.threshold = t2;
            this.polarity = n2;
            this.inclusive = bl;
            this.function = function;
        }

        private MatchOperation(int n2, boolean bl) {
            this(null, null, n2, bl, GlazedListsImpl.identityFunction());
        }

        private MatchOperation<E, T> instance(Comparator<T> comparator, T t2, FunctionList.Function<E, T> function) {
            return new MatchOperation<E, T>(comparator, t2, this.polarity, this.inclusive, function);
        }

        boolean isMoreStrict(MatchOperation<E, T> matchOperation) {
            if (matchOperation.polarity != this.polarity) {
                return true;
            }
            if (matchOperation.comparator != this.comparator) {
                return true;
            }
            if (matchOperation.threshold == this.threshold) {
                if (this.polarity == 0) {
                    return matchOperation.inclusive != this.inclusive;
                }
                return matchOperation.inclusive && !this.inclusive;
            }
            if (this.polarity == 0) {
                return true;
            }
            return !this.matchesThreshold(matchOperation.threshold);
        }

        @Override
        public boolean matches(E e2) {
            return this.matchesThreshold(this.function.evaluate(e2));
        }

        public boolean matchesThreshold(T t2) {
            int n2 = this.comparator.compare(t2, this.threshold);
            if (n2 == 0) {
                return this.inclusive;
            }
            if (this.polarity == 0) {
                return !this.inclusive;
            }
            return n2 < 0 == this.polarity < 0;
        }
    }
}

