/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.matchers.AbstractMatcherEditorListenerSupport;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public class ThreadedMatcherEditor<E>
extends AbstractMatcherEditorListenerSupport<E> {
    private static final Executor DEFAULT_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable, "MatcherQueueThread").start();
        }
    };
    private final MatcherEditor<E> source;
    private final List<MatcherEditor.Event<E>> matcherEventQueue = new LinkedList<MatcherEditor.Event<E>>();
    private MatcherEditor.Listener<E> queuingMatcherEditorListener = new QueuingMatcherEditorListener();
    private boolean isDrainingQueue = false;
    private Runnable drainMatcherEventQueueRunnable = new DrainMatcherEventQueueRunnable();
    private Executor executor;

    public ThreadedMatcherEditor(MatcherEditor<E> matcherEditor) {
        this(matcherEditor, DEFAULT_EXECUTOR);
    }

    public ThreadedMatcherEditor(MatcherEditor<E> matcherEditor, Executor executor) {
        if (matcherEditor == null) {
            throw new NullPointerException("source may not be null");
        }
        if (executor == null) {
            throw new NullPointerException("executor may not be null");
        }
        this.source = matcherEditor;
        this.executor = executor;
        this.source.addMatcherEditorListener(this.queuingMatcherEditorListener);
    }

    @Override
    public Matcher<E> getMatcher() {
        return this.source.getMatcher();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    protected MatcherEditor.Event<E> coalesceMatcherEvents(List<MatcherEditor.Event<E>> list) {
        boolean bl = false;
        MatcherEditor.Event<E> event = list.get(list.size() - 1);
        int n2 = event.getType();
        if (n2 != 0 && n2 != 1) {
            boolean bl2 = false;
            boolean bl3 = false;
            Iterator<MatcherEditor.Event<E>> iterator = list.iterator();
            while (iterator.hasNext()) {
                switch (iterator.next().getType()) {
                    case 0: {
                        bl3 = true;
                        break;
                    }
                    case 1: {
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        bl3 = true;
                        break;
                    }
                    case 2: {
                        bl2 = true;
                        break;
                    }
                    case 4: {
                        bl3 = true;
                        bl2 = true;
                    }
                }
            }
            bl = bl2 && bl3;
        }
        return new MatcherEditor.Event<E>(this, bl ? 4 : n2, event.getMatcher());
    }

    protected void executeMatcherEventQueueRunnable(Runnable runnable) {
        this.executor.execute(runnable);
    }

    private class DrainMatcherEventQueueRunnable
    implements Runnable {
        private DrainMatcherEventQueueRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                MatcherEditor.Event event;
                List list = ThreadedMatcherEditor.this.matcherEventQueue;
                synchronized (list) {
                    if (ThreadedMatcherEditor.this.matcherEventQueue.isEmpty()) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                        return;
                    }
                    event = ThreadedMatcherEditor.this.coalesceMatcherEvents(ThreadedMatcherEditor.this.matcherEventQueue);
                    ThreadedMatcherEditor.this.matcherEventQueue.clear();
                }
                try {
                    ThreadedMatcherEditor.this.fireChangedMatcher(event);
                }
                catch (Error error) {
                    List list2 = ThreadedMatcherEditor.this.matcherEventQueue;
                    synchronized (list2) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                    }
                    throw error;
                }
                catch (RuntimeException runtimeException) {
                    List list3 = ThreadedMatcherEditor.this.matcherEventQueue;
                    synchronized (list3) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                    }
                    throw runtimeException;
                }
            }
        }
    }

    private class QueuingMatcherEditorListener
    implements MatcherEditor.Listener<E> {
        private QueuingMatcherEditorListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changedMatcher(MatcherEditor.Event<E> event) {
            List list = ThreadedMatcherEditor.this.matcherEventQueue;
            synchronized (list) {
                ThreadedMatcherEditor.this.matcherEventQueue.add(event);
                if (!ThreadedMatcherEditor.this.isDrainingQueue) {
                    ThreadedMatcherEditor.this.isDrainingQueue = true;
                    ThreadedMatcherEditor.this.executeMatcherEventQueueRunnable(ThreadedMatcherEditor.this.drainMatcherEventQueueRunnable);
                }
            }
        }
    }
}

