/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.filter.BoyerMooreCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.ExactCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.RegularExpressionTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.SingleCharacterCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.StartsWithCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.filter.TextMatchers;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;

public class TextMatcherEditor<E>
extends AbstractMatcherEditor<E> {
    public static final int CONTAINS = 0;
    public static final int STARTS_WITH = 1;
    public static final int REGULAR_EXPRESSION = 2;
    public static final int EXACT = 3;
    public static final Object IDENTICAL_STRATEGY = new IdenticalStrategyFactory();
    public static final Object NORMALIZED_STRATEGY = new NormalizedStrategyFactory();
    private TextFilterator<? super E> filterator;
    private int mode = 0;
    private TextSearchStrategy.Factory strategy = (TextSearchStrategy.Factory)IDENTICAL_STRATEGY;

    public TextMatcherEditor() {
        this(null);
    }

    public TextMatcherEditor(TextFilterator<? super E> textFilterator) {
        this.filterator = textFilterator;
    }

    public TextFilterator<? super E> getFilterator() {
        return this.filterator;
    }

    public void setFilterator(TextFilterator<? super E> textFilterator) {
        if (textFilterator == this.filterator) {
            return;
        }
        this.filterator = textFilterator;
        TextMatcher<? super E> textMatcher = this.getCurrentTextMatcher();
        if (textMatcher == null) {
            return;
        }
        this.fireChanged(textMatcher.newFilterator(textFilterator));
    }

    public void setMode(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("mode must be one of: TextMatcherEditor.CONTAINS, STARTS_WITH, REGULAR_EXPRESSION or EXACT");
        }
        if (n2 == this.mode) {
            return;
        }
        int n3 = this.mode;
        this.mode = n2;
        TextMatcher<E> textMatcher = this.getCurrentTextMatcher();
        if (textMatcher == null) {
            return;
        }
        if (n3 == 0 && n2 == 1) {
            this.fireConstrained(textMatcher.newMode(n2));
        } else if (n3 == 1 && n2 == 0) {
            this.fireRelaxed(textMatcher.newMode(n2));
        } else {
            this.fireChanged(textMatcher.newMode(n2));
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setStrategy(Object object) {
        if (object == this.strategy) {
            return;
        }
        if (!(object instanceof TextSearchStrategy.Factory)) {
            throw new IllegalArgumentException();
        }
        this.strategy = (TextSearchStrategy.Factory)object;
        TextMatcher<E> textMatcher = this.getCurrentTextMatcher();
        if (textMatcher == null) {
            return;
        }
        this.fireChanged(textMatcher.newStrategy(object));
    }

    public Object getStrategy() {
        return this.strategy;
    }

    protected TextMatcher<E> getCurrentTextMatcher() {
        Matcher matcher = this.getMatcher();
        if (matcher instanceof TextMatcher) {
            return (TextMatcher)matcher;
        }
        return null;
    }

    public void setFilterText(String[] stringArray) {
        SearchTerm[] searchTermArray = new SearchTerm[stringArray.length];
        for (int i2 = 0; i2 < searchTermArray.length; ++i2) {
            searchTermArray[i2] = new SearchTerm(stringArray[i2]);
        }
        this.setTextMatcher(new TextMatcher<E>(searchTermArray, this.getFilterator(), this.getMode(), this.getStrategy()));
    }

    protected void setTextMatcher(TextMatcher<E> textMatcher) {
        TextMatcher<E> textMatcher2 = this.getCurrentTextMatcher();
        if (textMatcher.equals(textMatcher2)) {
            return;
        }
        if (textMatcher.getSearchTerms().length == 0) {
            if (!this.isCurrentlyMatchingAll()) {
                this.fireMatchAll();
            }
            return;
        }
        if (this.isCurrentlyMatchingAll()) {
            this.fireConstrained(textMatcher);
        } else if (TextMatchers.isMatcherRelaxed(textMatcher2, textMatcher)) {
            this.fireRelaxed(textMatcher);
        } else if (TextMatchers.isMatcherConstrained(textMatcher2, textMatcher)) {
            this.fireConstrained(textMatcher);
        } else {
            this.fireChanged(textMatcher);
        }
    }

    private static class NormalizedStrategyFactory
    extends IdenticalStrategyFactory {
        private NormalizedStrategyFactory() {
        }

        @Override
        public TextSearchStrategy create(int n2, String string) {
            TextSearchStrategy textSearchStrategy = super.create(n2, string);
            textSearchStrategy.setCharacterMap(GlazedListsImpl.getLatinDiacriticsStripper());
            return textSearchStrategy;
        }
    }

    private static class IdenticalStrategyFactory
    implements TextSearchStrategy.Factory {
        private IdenticalStrategyFactory() {
        }

        @Override
        public TextSearchStrategy create(int n2, String string) {
            if (n2 == 0) {
                if (string.length() == 1) {
                    return new SingleCharacterCaseInsensitiveTextSearchStrategy();
                }
                return new BoyerMooreCaseInsensitiveTextSearchStrategy();
            }
            if (n2 == 1) {
                return new StartsWithCaseInsensitiveTextSearchStrategy();
            }
            if (n2 == 2) {
                return new RegularExpressionTextSearchStrategy();
            }
            if (n2 == 3) {
                return new ExactCaseInsensitiveTextSearchStrategy();
            }
            throw new IllegalArgumentException("unrecognized mode: " + n2);
        }
    }
}

