/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.impl.Preconditions;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public final class SetMatcherEditor<E, O>
extends AbstractMatcherEditor<E> {
    private static final Logger L = Logger.getLogger(SetMatcherEditor.class.toString());
    private final FunctionList.Function<E, O> function;
    private Mode mode;

    public static <E, O> SetMatcherEditor<E, O> create(Mode mode, FunctionList.Function<E, O> function) {
        return new SetMatcherEditor<E, O>(mode, function);
    }

    private SetMatcherEditor(Mode mode, FunctionList.Function<E, O> function) {
        this.function = Preconditions.checkNotNull(function);
        this.mode = Preconditions.checkNotNull(mode);
        Preconditions.checkState(this.isCurrentlyMatchingAll());
        if (mode == Mode.WHITELIST_EMPTY_MATCH_NONE) {
            this.fireMatchNone();
        }
    }

    public void setMatchSet(Set<O> set) {
        Preconditions.checkNotNull(set);
        Set set2 = this.getMatcher() instanceof SetMatcher ? ((SetMatcher)this.getMatcher()).matchSet : new HashSet();
        if (set2.equals(set)) {
            L.fine("new set equals old -> no change to filter");
        } else if (set.isEmpty()) {
            if (this.mode == Mode.WHITELIST_EMPTY_MATCH_NONE) {
                L.fine("empty set (" + (Object)((Object)this.mode) + ") -> firing matchNone");
                this.fireMatchNone();
            } else {
                L.fine("empty set (" + (Object)((Object)this.mode) + ") -> firing matchAll");
                this.fireMatchAll();
            }
        } else if (set2.isEmpty()) {
            L.fine("old set was empty, new set is not -> firing change");
            this.fireChanged(new SetMatcher(set, this.mode, this.function));
        } else if (set2.containsAll(set)) {
            if (this.mode == Mode.BLACKLIST) {
                L.fine("old set contains new set (blacklist) -> firing relaxed");
                this.fireRelaxed(new SetMatcher(set, this.mode, this.function));
            } else {
                L.fine("old set contains new set (whitelist) -> firing constrained");
                this.fireConstrained(new SetMatcher(set, this.mode, this.function));
            }
        } else if (set.containsAll(set2)) {
            if (this.mode == Mode.BLACKLIST) {
                L.fine("new set contains old set (blacklist) -> firing constrained");
                this.fireConstrained(new SetMatcher(set, this.mode, this.function));
            } else {
                L.fine("new set contains old set (whitelist) -> firing relaxed");
                this.fireRelaxed(new SetMatcher(set, this.mode, this.function));
            }
        } else {
            L.fine("old and new set differ -> firing change");
            this.fireChanged(new SetMatcher(set, this.mode, this.function));
        }
    }

    private static final class SetMatcher<E, O>
    implements Matcher<E> {
        private final Set<O> matchSet;
        private final FunctionList.Function<E, O> fn;
        private final Mode mode;

        private SetMatcher(Set<O> set, Mode mode, FunctionList.Function<E, O> function) {
            this.matchSet = new HashSet<O>(set);
            this.mode = mode;
            this.fn = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean matches(E e2) {
            boolean bl = this.matchSet.contains(this.fn.evaluate(e2));
            return this.mode == Mode.BLACKLIST ? !bl : bl;
        }
    }

    public static enum Mode {
        BLACKLIST,
        WHITELIST_EMPTY_MATCH_NONE,
        WHITELIST_EMPTY_MATCH_ALL;

    }
}

