/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.filter.TextMatchers;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class SearchEngineTextMatcherEditor<E>
extends TextMatcherEditor<E> {
    private final Set<Field<E>> fields = new HashSet<Field<E>>();

    public SearchEngineTextMatcherEditor() {
    }

    public SearchEngineTextMatcherEditor(TextFilterator<? super E> textFilterator) {
        super(textFilterator);
    }

    public void setFields(Set<Field<E>> set) {
        this.fields.clear();
        this.fields.addAll(set);
    }

    public Set<Field<E>> getFields() {
        return new HashSet<Field<E>>(this.fields);
    }

    public void refilter(String string) {
        SearchTerm[] searchTermArray = TextMatchers.parse(string, this.getFields());
        this.setTextMatcher(new TextMatcher(searchTermArray, this.getFilterator(), this.getMode(), this.getStrategy()));
    }

    public static final class Field<E>
    implements Serializable {
        private final String name;
        private final TextFilterator<? super E> textFilterator;

        public Field(String string, TextFilterator<? super E> textFilterator) {
            if (string == null) {
                throw new IllegalArgumentException("name may not be null");
            }
            if (textFilterator == null) {
                throw new IllegalArgumentException("textFilterator may not be null");
            }
            this.name = string;
            this.textFilterator = textFilterator;
        }

        public String getName() {
            return this.name;
        }

        public TextFilterator<? super E> getTextFilterator() {
            return this.textFilterator;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Field field = (Field)object;
            return this.name.equals(field.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

