/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;

public class RangeMatcherEditor<D extends Comparable, E>
extends AbstractMatcherEditor<E> {
    private final Filterator<D, E> filterator;
    private D currentRangeStart;
    private D currentRangeEnd;

    public RangeMatcherEditor() {
        this(null);
    }

    public RangeMatcherEditor(Filterator<D, E> filterator) {
        this.filterator = filterator;
    }

    public Filterator<D, E> getFilterator() {
        return this.filterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(D d2, D d3) {
        if (d2 != null && d3 != null && d2.compareTo(d3) > 0) {
            D d4 = d3;
            d3 = d2;
            d2 = d4;
        }
        try {
            if (d2 == null && d3 == null) {
                if (this.currentRangeStart != null || this.currentRangeEnd != null) {
                    this.fireMatchAll();
                }
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            int n2 = RangeMatcherEditor.compare(d2, this.currentRangeStart, true);
            bl |= n2 < 0;
            bl2 |= n2 > 0;
            int n3 = RangeMatcherEditor.compare(d3, this.currentRangeEnd, false);
            Matcher<E> matcher = Matchers.rangeMatcher(d2, d3, this.filterator);
            if ((bl |= n3 > 0) && (bl2 |= n3 < 0)) {
                this.fireChanged(matcher);
            } else if (bl) {
                this.fireRelaxed(matcher);
            } else if (bl2) {
                this.fireConstrained(matcher);
            }
        }
        finally {
            this.currentRangeStart = d2;
            this.currentRangeEnd = d3;
        }
    }

    private static int compare(Comparable comparable, Comparable comparable2, boolean bl) {
        if (comparable == null && comparable2 == null) {
            return 0;
        }
        if (comparable == null) {
            return bl ? -1 : 1;
        }
        if (comparable2 == null) {
            return bl ? 1 : -1;
        }
        return comparable.compareTo(comparable2);
    }
}

