/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.impl.matchers.AndMatcher;
import ca.odell.glazedlists.impl.matchers.BeanPropertyMatcher;
import ca.odell.glazedlists.impl.matchers.FalseMatcher;
import ca.odell.glazedlists.impl.matchers.NonNullAndNonEmptyStringMatcher;
import ca.odell.glazedlists.impl.matchers.NotMatcher;
import ca.odell.glazedlists.impl.matchers.NotNullMatcher;
import ca.odell.glazedlists.impl.matchers.NullMatcher;
import ca.odell.glazedlists.impl.matchers.OrMatcher;
import ca.odell.glazedlists.impl.matchers.PropertyEventNameMatcher;
import ca.odell.glazedlists.impl.matchers.RangeMatcher;
import ca.odell.glazedlists.impl.matchers.TrueMatcher;
import ca.odell.glazedlists.impl.matchers.TypeMatcher;
import ca.odell.glazedlists.impl.matchers.WeakReferenceMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class Matchers {
    private Matchers() {
        throw new UnsupportedOperationException();
    }

    public static <E> MatcherEditor<E> weakReferenceProxy(MatcherEditor<E> matcherEditor) {
        return new WeakReferenceMatcherEditor<E>(matcherEditor);
    }

    public static <E> Matcher<E> trueMatcher() {
        return TrueMatcher.getInstance();
    }

    public static <E> Matcher<E> falseMatcher() {
        return FalseMatcher.getInstance();
    }

    public static <E> Matcher<E> invert(Matcher<E> matcher) {
        return new NotMatcher<E>(matcher);
    }

    public static <E> Matcher<E> isNull() {
        return NullMatcher.getInstance();
    }

    public static <E> Matcher<E> isNotNull() {
        return NotNullMatcher.getInstance();
    }

    public static Matcher<String> nonNullAndNonEmptyString() {
        return NonNullAndNonEmptyStringMatcher.getInstance();
    }

    public static <E> Matcher<E> beanPropertyMatcher(Class<E> clazz, String string, Object object) {
        return new BeanPropertyMatcher<E>(clazz, string, object);
    }

    public static <D extends Comparable, E> Matcher<E> rangeMatcher(D d2, D d3) {
        return new RangeMatcher(d2, d3);
    }

    public static <D extends Comparable, E> Matcher<E> rangeMatcher(D d2, D d3, Filterator<D, E> filterator) {
        return new RangeMatcher<D, E>(d2, d3, filterator);
    }

    public static Matcher<PropertyChangeEvent> propertyEventNameMatcher(boolean bl, String ... stringArray) {
        return new PropertyEventNameMatcher(bl, stringArray);
    }

    public static <E> int count(Collection<E> collection, Matcher<? super E> matcher) {
        int n2 = 0;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!matcher.matches(iterator.next())) continue;
            ++n2;
        }
        return n2;
    }

    public static <E> boolean filter(Collection<E> collection, Matcher<? super E> matcher) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (matcher.matches(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static <E> E[] select(E[] EArray, Matcher<? super E> matcher) {
        Collection<E> collection = Matchers.select(Arrays.asList(EArray), matcher);
        return collection.toArray((Object[])Array.newInstance(EArray.getClass().getComponentType(), collection.size()));
    }

    public static <E> Collection<? super E> select(Collection<E> collection, Matcher<? super E> matcher) {
        return Matchers.select(collection, matcher, new ArrayList());
    }

    public static <E> Collection<? super E> select(Collection<E> collection, Matcher<? super E> matcher, Collection<? super E> collection2) {
        for (E e2 : collection) {
            if (!matcher.matches(e2)) continue;
            collection2.add(e2);
        }
        return collection2;
    }

    public static <E> boolean contains(Collection<E> collection, Matcher<? super E> matcher) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!matcher.matches(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static <E> int indexOf(List<E> list, Matcher<? super E> matcher) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!matcher.matches(list.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    @SafeVarargs
    public static <E> Matcher<E> or(Matcher<? super E> ... matcherArray) {
        return new OrMatcher<E>(matcherArray);
    }

    @SafeVarargs
    public static <E> Matcher<E> and(Matcher<? super E> ... matcherArray) {
        return new AndMatcher<E>(matcherArray);
    }

    public static <E> Matcher<E> types(Class ... classArray) {
        return new TypeMatcher(classArray);
    }
}

