/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeMatcherEditor<E>
extends AbstractMatcherEditor<E> {
    public static final int AND = 42;
    public static final int OR = 24;
    private EventList<MatcherEditor<E>> matcherEditors;
    private int mode = 42;
    private List<DelegateMatcherEditorListener> matcherEditorListeners = new ArrayList<DelegateMatcherEditorListener>();

    public CompositeMatcherEditor(EventList<MatcherEditor<E>> eventList) {
        this.matcherEditors = eventList;
        Iterator iterator = eventList.iterator();
        while (iterator.hasNext()) {
            this.matcherEditorListeners.add(new DelegateMatcherEditorListener((MatcherEditor)iterator.next()));
        }
        eventList.addListEventListener(new MatcherEditorsListListener());
        this.fireChanged(this.rebuildMatcher());
    }

    public CompositeMatcherEditor() {
        this(new BasicEventList<MatcherEditor<E>>());
    }

    public EventList<MatcherEditor<E>> getMatcherEditors() {
        return this.matcherEditors;
    }

    private Matcher<E> rebuildMatcher() {
        Matcher[] matcherArray = new Matcher[this.matcherEditors.size()];
        int n2 = this.matcherEditors.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            matcherArray[i2] = ((MatcherEditor)this.matcherEditors.get(i2)).getMatcher();
        }
        if (this.mode == 42) {
            return Matchers.and(matcherArray);
        }
        if (this.mode == 24) {
            return Matchers.or(matcherArray);
        }
        throw new IllegalStateException();
    }

    public void setMode(int n2) {
        if (this.mode == n2) {
            return;
        }
        int n3 = this.mode;
        this.mode = n2;
        if (n3 == 42 && n2 == 24) {
            if (this.matcherEditors.isEmpty()) {
                this.fireMatchNone();
            } else if (this.matcherEditors.size() > 1) {
                this.fireRelaxed(this.rebuildMatcher());
            }
        } else if (n3 == 24 && n2 == 42) {
            if (this.matcherEditors.isEmpty()) {
                this.fireMatchAll();
            } else if (this.matcherEditors.size() > 1) {
                this.fireConstrained(this.rebuildMatcher());
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int getMode() {
        return this.mode;
    }

    private class DelegateMatcherEditorListener
    implements MatcherEditor.Listener<E> {
        private MatcherEditor<E> source;

        @Override
        public void changedMatcher(MatcherEditor.Event<E> event) {
            switch (event.getType()) {
                case 2: {
                    this.constrained();
                    break;
                }
                case 3: {
                    this.relaxed();
                    break;
                }
                case 4: {
                    this.changed();
                    break;
                }
                case 0: {
                    this.matchAll();
                    break;
                }
                case 1: {
                    this.matchNone();
                }
            }
        }

        private DelegateMatcherEditorListener(MatcherEditor<E> matcherEditor) {
            this.source = matcherEditor;
            matcherEditor.addMatcherEditorListener(this);
        }

        private void matchAll() {
            if (CompositeMatcherEditor.this.matcherEditors.size() == 1) {
                CompositeMatcherEditor.this.fireMatchAll();
            } else {
                CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
            }
        }

        private void matchNone() {
            if (CompositeMatcherEditor.this.matcherEditors.size() == 1) {
                CompositeMatcherEditor.this.fireMatchNone();
            } else {
                CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
            }
        }

        private void changed() {
            CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
        }

        private void constrained() {
            CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
        }

        private void relaxed() {
            CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
        }

        public void setMatcherEditor(MatcherEditor<E> matcherEditor) {
            if (this.source == matcherEditor) {
                return;
            }
            this.stopListening();
            this.source = matcherEditor;
            matcherEditor.addMatcherEditorListener(this);
        }

        public void stopListening() {
            this.source.removeMatcherEditorListener(this);
        }
    }

    private class MatcherEditorsListListener
    implements ListEventListener<MatcherEditor<E>> {
        private MatcherEditorsListListener() {
        }

        @Override
        public void listChanged(ListEvent<MatcherEditor<E>> listEvent) {
            int n2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = CompositeMatcherEditor.this.matcherEditorListeners.isEmpty();
            while (listEvent.next()) {
                Object object;
                n2 = listEvent.getIndex();
                int n3 = listEvent.getType();
                if (n3 == 2) {
                    object = (MatcherEditor)CompositeMatcherEditor.this.matcherEditors.get(n2);
                    CompositeMatcherEditor.this.matcherEditorListeners.add(new DelegateMatcherEditorListener((MatcherEditor)object));
                    bl = true;
                    continue;
                }
                if (n3 == 0) {
                    object = (DelegateMatcherEditorListener)CompositeMatcherEditor.this.matcherEditorListeners.remove(n2);
                    ((DelegateMatcherEditorListener)object).stopListening();
                    bl2 = true;
                    continue;
                }
                if (n3 != 1) continue;
                object = (MatcherEditor)CompositeMatcherEditor.this.matcherEditors.get(n2);
                DelegateMatcherEditorListener delegateMatcherEditorListener = (DelegateMatcherEditorListener)CompositeMatcherEditor.this.matcherEditorListeners.get(n2);
                delegateMatcherEditorListener.setMatcherEditor(object);
                bl = true;
                bl2 = true;
            }
            n2 = CompositeMatcherEditor.this.matcherEditorListeners.isEmpty() ? 1 : 0;
            if (CompositeMatcherEditor.this.mode == 42) {
                if (bl && bl2) {
                    CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (bl) {
                    CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (bl2) {
                    if (n2 != 0) {
                        CompositeMatcherEditor.this.fireMatchAll();
                    } else {
                        CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                }
            } else if (CompositeMatcherEditor.this.mode == 24) {
                if (bl && bl2) {
                    CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (bl) {
                    if (bl3) {
                        CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                    } else {
                        CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                } else if (bl2) {
                    if (n2 != 0) {
                        CompositeMatcherEditor.this.fireMatchAll();
                    } else {
                        CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

