/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.testing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.List;

public class ListConsistencyListener<E> {
    private List<E> expected;
    private String name;
    private EventList<E> source;
    private boolean verbose = false;
    private boolean previousElementTracked = true;
    private List<Integer> changeCounts = new ArrayList<Integer>();
    private List<Boolean> reorderings = new ArrayList<Boolean>();

    private ListConsistencyListener(EventList<E> eventList, String string, boolean bl) {
        this.source = eventList;
        this.name = string != null ? string : eventList.getClass().getName();
        this.verbose = bl;
        this.expected = new ArrayList<E>(eventList);
        eventList.addListEventListener(new ListChangeHandler());
    }

    public static <E> ListConsistencyListener<E> install(EventList<E> eventList, String string, boolean bl) {
        return new ListConsistencyListener<E>(eventList, string, bl);
    }

    public static <E> ListConsistencyListener<E> install(EventList<E> eventList) {
        return ListConsistencyListener.install(eventList, null, false);
    }

    public int getEventCount() {
        return this.changeCounts.size();
    }

    public int getChangeCount(int n2) {
        return this.changeCounts.get(n2);
    }

    public boolean isReordering(int n2) {
        return this.reorderings.get(n2);
    }

    public void assertConsistent() {
        this.assertTrue(this.expected.size() == this.source.size());
        for (int i2 = 0; i2 < this.expected.size(); ++i2) {
            this.assertTrue("Different elements at " + i2 + " (expected=" + this.expected.get(i2) + ", is=" + this.source.get(i2), this.expected.get(i2) == this.source.get(i2));
        }
    }

    public void assertTrue(boolean bl) {
        if (!bl) {
            System.out.println("");
        }
        this.assertTrue("Assertion failed", bl);
    }

    public void assertTrue(String string, boolean bl) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public void setPreviousElementTracked(boolean bl) {
        this.previousElementTracked = bl;
    }

    public static void assertEventsInIncreasingOrder(ListEvent listEvent) {
        listEvent.reset();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        int n3 = 0;
        boolean bl = true;
        while (listEvent.next()) {
            int n4 = listEvent.getIndex();
            int n5 = listEvent.getType();
            if (n5 == 1) {
                stringBuffer.append("U");
            } else if (n5 == 2) {
                stringBuffer.append("I");
            } else if (n5 == 0) {
                stringBuffer.append("D");
            }
            stringBuffer.append(n4);
            if (n4 < n2 || n4 == n2 && n3 != 0) {
                bl = false;
                stringBuffer.append("*");
            }
            stringBuffer.append(" ");
            n2 = n4;
            n3 = n5;
        }
        if (!bl) {
            System.out.println("List changes not in increasing order: " + stringBuffer);
        }
        listEvent.reset();
    }

    private class ListChangeHandler
    implements ListEventListener<E> {
        private ListChangeHandler() {
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            try {
                ListConsistencyListener.this.assertTrue(ListConsistencyListener.this.source == listEvent.getSource());
                ListConsistencyListener.assertEventsInIncreasingOrder(listEvent);
                if (ListConsistencyListener.this.verbose) {
                    System.out.println(ListConsistencyListener.this.name + ": " + listEvent + ", size: " + ListConsistencyListener.this.source.size() + ", source: " + ListConsistencyListener.this.source);
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int n2 = 0;
                if (listEvent.isReordering()) {
                    int[] nArray = listEvent.getReorderMap();
                    ListConsistencyListener.this.assertTrue(ListConsistencyListener.this.expected.size() == nArray.length);
                    ArrayList arrayList2 = new ArrayList(ListConsistencyListener.this.expected.size());
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        arrayList2.add(i2, ListConsistencyListener.this.expected.get(nArray[i2]));
                        arrayList.add(new Integer(i2));
                    }
                    ListConsistencyListener.this.expected = arrayList2;
                    ListConsistencyListener.this.changeCounts.add(new Integer(2 * nArray.length));
                    ListConsistencyListener.this.reorderings.add(Boolean.TRUE);
                } else {
                    int n3 = 0;
                    while (listEvent.next()) {
                        Object e2;
                        Object e3;
                        ++n3;
                        int n4 = listEvent.getIndex();
                        int n5 = listEvent.getType();
                        arrayList.add(new Integer(n4));
                        ListConsistencyListener.this.assertTrue(n4 >= 0);
                        ListConsistencyListener.this.assertTrue(n4 >= n2);
                        n2 = n4;
                        if (n5 == 2) {
                            e3 = ListConsistencyListener.this.source.get(n4);
                            ListConsistencyListener.this.expected.add(n4, e3);
                            if (!ListConsistencyListener.this.previousElementTracked) continue;
                            e2 = listEvent.getNewValue();
                            continue;
                        }
                        if (n5 == 0) {
                            e3 = ListConsistencyListener.this.expected.remove(n4);
                            if (!ListConsistencyListener.this.previousElementTracked) continue;
                            e2 = listEvent.getOldValue();
                            ListConsistencyListener.this.assertTrue(e3 == e2);
                            continue;
                        }
                        if (n5 != 1) continue;
                        e3 = ListConsistencyListener.this.source.get(n4);
                        e2 = ListConsistencyListener.this.expected.set(n4, e3);
                        if (!ListConsistencyListener.this.previousElementTracked) continue;
                        Object e4 = listEvent.getOldValue();
                        ListConsistencyListener.this.assertTrue(e2 == e4);
                    }
                    ListConsistencyListener.this.changeCounts.add(new Integer(n3));
                    ListConsistencyListener.this.reorderings.add(Boolean.FALSE);
                }
                ListConsistencyListener.this.assertConsistent();
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Failure for " + ListConsistencyListener.this.name, runtimeException);
            }
        }

        public String toString() {
            return "ConsistencyListener:" + ListConsistencyListener.this.name;
        }
    }
}

