/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.testing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class GlazedListsTests {
    private static final Comparator<String> FIRST_LETTER_COMPARATOR = new FirstLetterComparator();
    private static final Comparator<String> LAST_LETTER_COMPARATOR = new LastLetterComparator();
    private static final FunctionList.Function<String, String> FIRST_LETTER_FUNCTION = new FirstLetterFunction();

    private GlazedListsTests() {
        throw new UnsupportedOperationException();
    }

    public static List<String> delimitedStringToList(String string) {
        String[] stringArray = string.split("\\s");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    public static List<String> stringToList(CharSequence charSequence) {
        ArrayList<String> arrayList = new ArrayList<String>(charSequence.length());
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            arrayList.add(charSequence.subSequence(i2, i2 + 1).toString());
        }
        return arrayList;
    }

    public static List<List<String>> stringToLists(CharSequence charSequence) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        String[] stringArray = charSequence.toString().split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(GlazedListsTests.stringToList(stringArray[i2]));
        }
        return arrayList;
    }

    public static List<String> stringsToList(CharSequence[] charSequenceArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
            arrayList.addAll(GlazedListsTests.stringToList(charSequenceArray[i2]));
        }
        return arrayList;
    }

    public static List<Integer> intArrayToIntegerCollection(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(new Integer(nArray[i2]));
        }
        return arrayList;
    }

    public static Matcher<Number> matchAtLeast(int n2) {
        return new AtLeastMatcher(n2);
    }

    public static <T> T serialize(T t2) throws IOException, ClassNotFoundException {
        return (T)GlazedListsTests.fromBytes(GlazedListsTests.toBytes(t2));
    }

    public static byte[] toBytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    public static Object fromBytes(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(byArray[i2] < 0 ? "-" : " ");
            String string = Integer.toString(Math.abs(byArray[i2]), 16);
            while (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append("0x").append(string).append(", ");
            if (i2 % 16 != 15) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static Comparator<String> getFirstLetterComparator() {
        return FIRST_LETTER_COMPARATOR;
    }

    public static Comparator<String> getLastLetterComparator() {
        return LAST_LETTER_COMPARATOR;
    }

    public static Comparator<int[]> intArrayComparator(int n2) {
        return new IntArrayComparator(n2);
    }

    public static FunctionList.Function<String, String> getFirstLetterFunction() {
        return FIRST_LETTER_FUNCTION;
    }

    public static Date createDate(int n2, int n3, int n4) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, n3);
        calendar.set(5, n4);
        return calendar.getTime();
    }

    public static <E> Runnable createJerkyAddRunnable(EventList<E> eventList, E e2, long l2, long l3) {
        return new JerkyAddRunnable<E>(eventList, e2, l2, l3);
    }

    public static class UnserializableListener
    implements ListEventListener {
        private static EventList lastSource = null;

        public void listChanged(ListEvent listEvent) {
            lastSource = listEvent.getSourceList();
        }

        public static EventList getLastSource() {
            return lastSource;
        }
    }

    public static class SerializableListener
    implements ListEventListener,
    Serializable {
        private static EventList lastSource = null;

        public void listChanged(ListEvent listEvent) {
            lastSource = listEvent.getSourceList();
        }

        public static EventList getLastSource() {
            return lastSource;
        }
    }

    public static class ListEventCounter<E>
    implements ListEventListener<E> {
        private int count = 0;

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            ++this.count;
        }

        public int getCountAndReset() {
            int n2 = this.count;
            this.count = 0;
            return n2;
        }
    }

    private static final class JerkyAddRunnable<E>
    implements Runnable {
        private final EventList<E> list;
        private final E value;
        private final long count;
        private final long pause;

        public JerkyAddRunnable(EventList<E> eventList, E e2, long l2, long l3) {
            if (l2 < 1L) {
                throw new IllegalArgumentException("count must be non-negative");
            }
            if (l3 < 1L) {
                throw new IllegalArgumentException("pause must be non-negative");
            }
            this.list = eventList;
            this.value = e2;
            this.count = l2;
            this.pause = l3;
        }

        @Override
        public void run() {
            long l2 = 0L;
            while (l2 < this.count) {
                this.list.getReadWriteLock().writeLock().lock();
                try {
                    this.list.add(this.value);
                    ++l2;
                }
                finally {
                    this.list.getReadWriteLock().writeLock().unlock();
                }
                try {
                    Thread.sleep(this.pause);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static final class FirstLetterFunction
    implements FunctionList.Function<String, String> {
        private FirstLetterFunction() {
        }

        @Override
        public String evaluate(String string) {
            return String.valueOf(string.charAt(0));
        }
    }

    private static class IntArrayComparator
    implements Comparator<int[]> {
        public int index;

        public IntArrayComparator(int n2) {
            this.index = n2;
        }

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            return nArray[this.index] - nArray2[this.index];
        }
    }

    private static class LastLetterComparator
    implements Comparator<String> {
        private LastLetterComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.charAt(string.length() - 1) - string2.charAt(string2.length() - 1);
        }
    }

    private static class FirstLetterComparator
    implements Comparator<String> {
        private FirstLetterComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.charAt(0) - string2.charAt(0);
        }
    }

    private static class AtLeastMatcher
    implements Matcher<Number> {
        private final int minimum;

        public AtLeastMatcher(int n2) {
            this.minimum = n2;
        }

        @Override
        public boolean matches(Number number) {
            return number.intValue() >= this.minimum;
        }
    }
}

