/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.swing;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ScreenGeometry {
    final GraphicsConfiguration graphicsConfiguration;
    final boolean aqua = UIManager.getLookAndFeel().getName().indexOf("Aqua") != -1;

    public ScreenGeometry(JComponent jComponent) {
        this.graphicsConfiguration = this.graphicsConfigurationForComponent(jComponent);
    }

    private GraphicsConfiguration graphicsConfigurationForComponent(Component component) {
        Point point = component.getLocationOnScreen();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            GraphicsConfiguration graphicsConfiguration;
            if (graphicsDeviceArray[i2].getType() != 0 || !(graphicsConfiguration = graphicsDeviceArray[i2].getDefaultConfiguration()).getBounds().contains(point)) continue;
            return graphicsConfiguration;
        }
        return component.getGraphicsConfiguration();
    }

    public Rectangle getScreenBounds() {
        Rectangle rectangle = this.getScreenSize();
        Insets insets = this.getScreenInsets();
        return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
    }

    public Rectangle getScreenSize() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration.getBounds();
        }
        return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public Insets getScreenInsets() {
        Insets insets = this.graphicsConfiguration != null ? Toolkit.getDefaultToolkit().getScreenInsets(this.graphicsConfiguration) : new Insets(0, 0, 0, 0);
        if (this.aqua) {
            int n2 = 21;
            int n3 = 22;
            insets.bottom = Math.max(insets.bottom, n2);
            insets.top = Math.max(insets.top, n3);
        }
        return insets;
    }
}

