/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.swing;

import ca.odell.glazedlists.impl.swing.ScreenGeometry;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class ComboBoxPopupLocationFix {
    private final JComboBox<?> comboBox;
    private final JPopupMenu popupMenu;
    private final Listener listener = new Listener();

    private ComboBoxPopupLocationFix(JComboBox<?> jComboBox) {
        this.comboBox = jComboBox;
        this.popupMenu = (JPopupMenu)jComboBox.getUI().getAccessibleChild(jComboBox, 0);
        this.popupMenu.addPopupMenuListener(this.listener);
    }

    public static ComboBoxPopupLocationFix install(JComboBox<?> jComboBox) {
        if (jComboBox == null) {
            throw new IllegalArgumentException();
        }
        return new ComboBoxPopupLocationFix(jComboBox);
    }

    public void uninstall() {
        this.popupMenu.removePopupMenuListener(this.listener);
    }

    private void fixPopupLocation(JComponent jComponent) {
        if (jComponent.getClass().getName().indexOf("apple.laf") != 0) {
            return;
        }
        Point point = this.comboBox.getLocationOnScreen();
        int n2 = this.comboBox.getHeight();
        int n3 = point.y + n2;
        Rectangle rectangle = new ScreenGeometry(this.comboBox).getScreenBounds();
        int n4 = jComponent.getPreferredSize().height;
        if (point.y + n2 + n4 > rectangle.x + rectangle.height) {
            n3 = point.y - n4;
        }
        jComponent.setLocation(point.x, n3);
    }

    private class Listener
    implements PopupMenuListener {
        private Listener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JComponent jComponent = (JComponent)popupMenuEvent.getSource();
            ComboBoxPopupLocationFix.this.fixPopupLocation(jComponent);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

