/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.sort;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.TableFormat;
import java.util.Comparator;

public class TableColumnComparator<E>
implements Comparator<E> {
    private TableFormat<? super E> tableFormat;
    private int column;
    private Comparator comparator = null;

    public TableColumnComparator(TableFormat<? super E> tableFormat, int n2) {
        this(tableFormat, n2, GlazedLists.comparableComparator());
    }

    public TableColumnComparator(TableFormat<? super E> tableFormat, int n2, Comparator comparator) {
        this.column = n2;
        this.tableFormat = tableFormat;
        this.comparator = comparator;
    }

    @Override
    public int compare(E e2, E e3) {
        Object object = this.tableFormat.getColumnValue(e2, this.column);
        Object object2 = this.tableFormat.getColumnValue(e3, this.column);
        try {
            return this.comparator.compare(object, object2);
        }
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = this.comparator == GlazedLists.comparableComparator() ? new IllegalStateException("TableComparatorChooser can not sort objects \"" + object + "\", \"" + object2 + "\" that do not implement Comparable.") : new IllegalStateException("TableComparatorChooser can not sort objects \"" + object + "\", \"" + object2 + "\" using the provided Comparator.");
            illegalStateException.initCause(classCastException);
            throw illegalStateException;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TableColumnComparator tableColumnComparator = (TableColumnComparator)object;
        if (this.column != tableColumnComparator.column) {
            return false;
        }
        if (!this.comparator.equals(tableColumnComparator.comparator)) {
            return false;
        }
        return this.tableFormat.equals(tableColumnComparator.tableFormat);
    }

    public int hashCode() {
        int n2 = this.tableFormat.hashCode();
        n2 = 29 * n2 + this.column;
        n2 = 29 * n2 + this.comparator.hashCode();
        return n2;
    }
}

