/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.sort;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class ComparatorChain<T>
implements Comparator<T> {
    private final Comparator<T>[] comparators;

    public ComparatorChain(List<Comparator<T>> list) {
        this.comparators = list.toArray(new Comparator[list.size()]);
    }

    @Override
    public int compare(T t2, T t3) {
        for (int i2 = 0; i2 < this.comparators.length; ++i2) {
            int n2 = this.comparators[i2].compare(t2, t3);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public Comparator<T>[] getComparators() {
        return this.comparators;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ComparatorChain comparatorChain = (ComparatorChain)object;
        return Arrays.equals(this.comparators, comparatorChain.comparators);
    }

    public int hashCode() {
        return 0;
    }
}

