/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.reflect;

import ca.odell.glazedlists.impl.Preconditions;
import ca.odell.glazedlists.impl.reflect.MoreTypes;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;

public class TypeLiteral<T> {
    final Class<? super T> rawType;
    final Type type;
    final int hashCode;

    TypeLiteral(Type type) {
        this.type = MoreTypes.canonicalize(Preconditions.checkNotNull(type, "type"));
        this.rawType = MoreTypes.getRawType(this.type);
        this.hashCode = MoreTypes.hashCode(this.type);
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        return object instanceof TypeLiteral && MoreTypes.equals(this.type, ((TypeLiteral)object).type);
    }

    public final String toString() {
        return MoreTypes.toString(this.type);
    }

    public static TypeLiteral<?> get(Type type) {
        return new TypeLiteral(type);
    }

    public static <T> TypeLiteral<T> get(Class<T> clazz) {
        return new TypeLiteral<T>(clazz);
    }

    private List<TypeLiteral<?>> resolveAll(Type[] typeArray) {
        TypeLiteral[] typeLiteralArray = new TypeLiteral[typeArray.length];
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeLiteralArray[i2] = this.resolve(typeArray[i2]);
        }
        return Arrays.asList(typeLiteralArray);
    }

    TypeLiteral<?> resolve(Type type) {
        return TypeLiteral.get(this.resolveType(type));
    }

    Type resolveType(Type type) {
        Type type2;
        while (type instanceof TypeVariable) {
            type2 = (TypeVariable)type;
            if ((type = MoreTypes.resolveTypeVariable(this.type, this.rawType, (TypeVariable)type2)) != type2) continue;
            return type;
        }
        if (type instanceof ParameterizedType) {
            type2 = (ParameterizedType)type;
            Type type3 = type2.getOwnerType();
            Type type4 = this.resolveType(type3);
            boolean bl = type4 != type3;
            Type[] typeArray = type2.getActualTypeArguments();
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type5 = this.resolveType(typeArray[i2]);
                if (type5 == typeArray[i2]) continue;
                if (!bl) {
                    typeArray = (Type[])typeArray.clone();
                    bl = true;
                }
                typeArray[i2] = type5;
            }
            return bl ? new MoreTypes.ParameterizedTypeImpl(type4, type2.getRawType(), typeArray) : type2;
        }
        return type;
    }

    public List<TypeLiteral<?>> getParameterTypes(Member member) {
        Type[] typeArray;
        if (member instanceof Method) {
            Method method = (Method)member;
            Preconditions.checkArgument(method.getDeclaringClass().isAssignableFrom(this.rawType), "%s is not defined by a supertype of %s", method, this.type);
            typeArray = method.getGenericParameterTypes();
        } else if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            Preconditions.checkArgument(constructor.getDeclaringClass().isAssignableFrom(this.rawType), "%s does not construct a supertype of %s", constructor, this.type);
            typeArray = constructor.getGenericParameterTypes();
        } else {
            throw new IllegalArgumentException("Not a method or a constructor: " + member);
        }
        return this.resolveAll(typeArray);
    }

    public TypeLiteral<?> getReturnType(Method method) {
        Preconditions.checkArgument(method.getDeclaringClass().isAssignableFrom(this.rawType), "%s is not defined by a supertype of %s", method, this.type);
        return this.resolve(method.getGenericReturnType());
    }
}

