/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.reflect;

import ca.odell.glazedlists.impl.reflect.TypeLiteral;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class MoreTypes {
    private static final Map<TypeLiteral<?>, TypeLiteral<?>> PRIMITIVE_TO_WRAPPER;

    private MoreTypes() {
    }

    public static <T> TypeLiteral<T> wrapPrimitives(TypeLiteral<T> typeLiteral) {
        TypeLiteral<?> typeLiteral2 = PRIMITIVE_TO_WRAPPER.get(typeLiteral);
        return typeLiteral2 != null ? typeLiteral2 : typeLiteral;
    }

    public static Type canonicalize(Type type) {
        if (type instanceof ParameterizedTypeImpl) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new ParameterizedTypeImpl(parameterizedType.getOwnerType(), parameterizedType.getRawType(), parameterizedType.getActualTypeArguments());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            if (!(type2 instanceof Class)) {
                throw MoreTypes.unexpectedType(type2, Class.class);
            }
            return (Class)type2;
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        if (type instanceof TypeVariable || type instanceof WildcardType) {
            return Object.class;
        }
        throw MoreTypes.unexpectedType(type, ParameterizedType.class);
    }

    private static AssertionError unexpectedType(Type type, Class<?> clazz) {
        return new AssertionError((Object)("Unexpected type. Expected: " + clazz.getName() + ", got: " + type.getClass().getName() + ", for type literal: " + type.toString() + "."));
    }

    public static boolean equals(Type type, Type type2) {
        if (type == type2) {
            return true;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            if (!(type2 instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ParameterizedType parameterizedType2 = (ParameterizedType)type2;
            return MoreTypes.equal(parameterizedType.getOwnerType(), parameterizedType2.getOwnerType()) && parameterizedType.getRawType().equals(parameterizedType2.getRawType()) && Arrays.equals(parameterizedType.getActualTypeArguments(), parameterizedType2.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType genericArrayType = (GenericArrayType)type;
            GenericArrayType genericArrayType2 = (GenericArrayType)type2;
            return MoreTypes.equals(genericArrayType.getGenericComponentType(), genericArrayType2.getGenericComponentType());
        }
        return false;
    }

    public static boolean equal(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static int hashCode(Type type) {
        if (type instanceof Class) {
            return type.hashCode();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return Arrays.hashCode(parameterizedType.getActualTypeArguments()) ^ parameterizedType.getRawType().hashCode() ^ MoreTypes.hashCodeOrZero(parameterizedType.getOwnerType());
        }
        if (type instanceof GenericArrayType) {
            return MoreTypes.hashCode(((GenericArrayType)type).getGenericComponentType());
        }
        return MoreTypes.hashCodeOrZero(type);
    }

    private static int hashCodeOrZero(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static String toString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            Type type2 = parameterizedType.getOwnerType();
            StringBuilder stringBuilder = new StringBuilder();
            if (type2 != null) {
                stringBuilder.append(MoreTypes.toString(type2)).append(".");
            }
            stringBuilder.append(MoreTypes.toString(parameterizedType.getRawType())).append("<").append(MoreTypes.toString(typeArray[0]));
            for (int i2 = 1; i2 < typeArray.length; ++i2) {
                stringBuilder.append(", ").append(MoreTypes.toString(typeArray[i2]));
            }
            return stringBuilder.append(">").toString();
        }
        if (type instanceof GenericArrayType) {
            return MoreTypes.toString(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        return type.toString();
    }

    public static Type getGenericSupertype(Type type, Class<?> object, Class<?> clazz) {
        Object object2;
        if (clazz == object) {
            return type;
        }
        if (clazz.isInterface()) {
            object2 = ((Class)object).getInterfaces();
            int n2 = ((Class<?>[])object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (object2[i2] == clazz) {
                    return ((Class)object).getGenericInterfaces()[i2];
                }
                if (!clazz.isAssignableFrom(object2[i2])) continue;
                return MoreTypes.getGenericSupertype(((Class)object).getGenericInterfaces()[i2], object2[i2], clazz);
            }
        }
        if (!((Class)object).isInterface()) {
            while (object != Object.class) {
                object2 = ((Class)object).getSuperclass();
                if (object2 == clazz) {
                    return ((Class)object).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object2)) {
                    return MoreTypes.getGenericSupertype(((Class)object).getGenericSuperclass(), object2, clazz);
                }
                object = object2;
            }
        }
        return clazz;
    }

    public static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable typeVariable) {
        Class<?> clazz2 = MoreTypes.declaringClassOf(typeVariable);
        if (clazz2 == null) {
            return typeVariable;
        }
        Type type2 = MoreTypes.getGenericSupertype(type, clazz, clazz2);
        if (type2 instanceof ParameterizedType) {
            int n2 = Arrays.asList(clazz2.getTypeParameters()).indexOf(typeVariable);
            return ((ParameterizedType)type2).getActualTypeArguments()[n2];
        }
        return typeVariable;
    }

    private static Class<?> declaringClassOf(TypeVariable typeVariable) {
        Object d2 = typeVariable.getGenericDeclaration();
        return d2 instanceof Class ? (Class)d2 : null;
    }

    static {
        HashMap<TypeLiteral<Object>, TypeLiteral<Object>> hashMap = new HashMap<TypeLiteral<Object>, TypeLiteral<Object>>();
        hashMap.put(TypeLiteral.get(Boolean.TYPE), TypeLiteral.get(Boolean.class));
        hashMap.put(TypeLiteral.get(Byte.TYPE), TypeLiteral.get(Byte.class));
        hashMap.put(TypeLiteral.get(Short.TYPE), TypeLiteral.get(Short.class));
        hashMap.put(TypeLiteral.get(Integer.TYPE), TypeLiteral.get(Integer.class));
        hashMap.put(TypeLiteral.get(Long.TYPE), TypeLiteral.get(Long.class));
        hashMap.put(TypeLiteral.get(Float.TYPE), TypeLiteral.get(Float.class));
        hashMap.put(TypeLiteral.get(Double.TYPE), TypeLiteral.get(Double.class));
        hashMap.put(TypeLiteral.get(Character.TYPE), TypeLiteral.get(Character.class));
        hashMap.put(TypeLiteral.get(Void.TYPE), TypeLiteral.get(Void.class));
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(hashMap);
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public ParameterizedTypeImpl(Type type, Type type2, Type ... typeArray) {
            this.ownerType = type == null ? null : MoreTypes.canonicalize(type);
            this.rawType = MoreTypes.canonicalize(type2);
            this.typeArguments = (Type[])typeArray.clone();
            for (int i2 = 0; i2 < this.typeArguments.length; ++i2) {
                ParameterizedTypeImpl.checkArgument(!(this.typeArguments[i2] instanceof Class) || !((Class)this.typeArguments[i2]).isPrimitive(), "Parameterized types may not have primitive arguments: %s", this.typeArguments[i2]);
                this.typeArguments[i2] = MoreTypes.canonicalize(this.typeArguments[i2]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object object) {
            return object instanceof ParameterizedType && MoreTypes.equals(this, (ParameterizedType)object);
        }

        public int hashCode() {
            return MoreTypes.hashCode(this);
        }

        public String toString() {
            return MoreTypes.toString(this);
        }

        private static void checkArgument(boolean bl, String string, Object ... objectArray) {
            if (!bl) {
                throw new IllegalArgumentException(String.format(string, objectArray));
            }
        }
    }
}

