/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.matchers;

import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class WeakReferenceMatcherEditor<E>
implements MatcherEditor<E>,
MatcherEditor.Listener<E> {
    private final List<MatcherEditor.Listener<E>> listenerList = new ArrayList<MatcherEditor.Listener<E>>();
    private MatcherEditor<E> source;

    public WeakReferenceMatcherEditor(MatcherEditor<E> matcherEditor) {
        this.source = matcherEditor;
        matcherEditor.addMatcherEditorListener(new WeakMatcherEditorListener<E>(matcherEditor, this));
    }

    @Override
    public Matcher<E> getMatcher() {
        return this.source.getMatcher();
    }

    @Override
    public synchronized void addMatcherEditorListener(MatcherEditor.Listener<E> listener) {
        this.listenerList.add(new WeakMatcherEditorListener<E>(this, listener));
    }

    @Override
    public synchronized void removeMatcherEditorListener(MatcherEditor.Listener<E> listener) {
        Iterator<MatcherEditor.Listener<E>> iterator = this.listenerList.iterator();
        while (iterator.hasNext()) {
            WeakMatcherEditorListener weakMatcherEditorListener;
            MatcherEditor.Listener listener2;
            MatcherEditor.Listener<E> listener3 = iterator.next();
            if (listener3 == listener) {
                iterator.remove();
                continue;
            }
            if (!(listener3 instanceof WeakMatcherEditorListener) || (listener2 = (weakMatcherEditorListener = (WeakMatcherEditorListener)listener3).getDecoratedListener()) != listener) continue;
            iterator.remove();
        }
    }

    @Override
    public synchronized void changedMatcher(MatcherEditor.Event<E> event) {
        for (int i2 = this.listenerList.size() - 1; i2 >= 0; --i2) {
            this.listenerList.get(i2).changedMatcher(event);
        }
    }

    private class WeakMatcherEditorListener<E>
    implements MatcherEditor.Listener<E> {
        private final WeakReference<MatcherEditor.Listener<E>> weakListener;
        private final MatcherEditor<E> editor;

        public WeakMatcherEditorListener(MatcherEditor<E> matcherEditor, MatcherEditor.Listener<E> listener) {
            this.weakListener = new WeakReference<MatcherEditor.Listener<E>>(listener);
            this.editor = matcherEditor;
        }

        public MatcherEditor.Listener<E> getDecoratedListener() {
            return (MatcherEditor.Listener)this.weakListener.get();
        }

        @Override
        public void changedMatcher(MatcherEditor.Event<E> event) {
            MatcherEditor.Listener listener = (MatcherEditor.Listener)this.weakListener.get();
            if (listener == null) {
                this.editor.removeMatcherEditorListener(this);
            } else {
                event = new MatcherEditor.Event<E>(WeakReferenceMatcherEditor.this, event.getType(), event.getMatcher());
                listener.changedMatcher(event);
            }
        }
    }
}

