/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.matchers;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.List;

public class RangeMatcher<D extends Comparable, E>
implements Matcher<E> {
    private final D start;
    private final D end;
    private final Filterator<D, E> filterator;
    private final List<D> filterComparables = new ArrayList<D>();

    public RangeMatcher(D d2, D d3) {
        this(d2, d3, null);
    }

    public RangeMatcher(D d2, D d3, Filterator<D, E> filterator) {
        this.start = d2;
        this.end = d3;
        this.filterator = filterator;
    }

    @Override
    public boolean matches(E e2) {
        this.filterComparables.clear();
        if (this.filterator == null) {
            this.filterComparables.add((Comparable)e2);
        } else {
            this.filterator.getFilterValues(this.filterComparables, e2);
        }
        for (int i2 = 0; i2 < this.filterComparables.size(); ++i2) {
            Comparable comparable = (Comparable)this.filterComparables.get(i2);
            if (comparable != null && (this.start != null && this.start.compareTo((Comparable)comparable) > 0 || this.end != null && this.end.compareTo((Comparable)comparable) < 0)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[RangeMatcher between " + this.start + " and " + this.end + "]";
    }
}

