/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.matchers;

import ca.odell.glazedlists.matchers.Matcher;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class PropertyEventNameMatcher
implements Matcher<PropertyChangeEvent> {
    private final Set<String> propertyNames = new HashSet<String>();
    private boolean matchPropertyNames;

    public PropertyEventNameMatcher(boolean bl, String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Array of property names may not be null");
        }
        this.matchPropertyNames = bl;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.propertyNames.add(stringArray[i2]);
        }
    }

    public PropertyEventNameMatcher(boolean bl, Collection<String> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Collection of property names may not be null");
        }
        this.matchPropertyNames = bl;
        this.propertyNames.addAll(collection);
    }

    @Override
    public boolean matches(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = this.propertyNames.contains(propertyChangeEvent.getPropertyName());
        return this.matchPropertyNames ? bl : !bl;
    }

    public boolean isMatchPropertyNames() {
        return this.matchPropertyNames;
    }
}

