/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;

public abstract class ThreadProxyEventList<E>
extends TransformedList<E, E>
implements RandomAccess {
    private List<E> localCache = new ArrayList();
    private UpdateRunner updateRunner = new UpdateRunner();
    private final ListEventAssembler<E> cacheUpdates = new ListEventAssembler(this, ListEventAssembler.createListEventPublisher());
    private volatile boolean scheduled = false;

    public ThreadProxyEventList(EventList<E> eventList) {
        super(eventList);
        this.localCache.addAll(eventList);
        this.cacheUpdates.addListEventListener(this.updateRunner);
        eventList.addListEventListener(this);
    }

    @Override
    public final void listChanged(ListEvent<E> listEvent) {
        if (!this.scheduled) {
            this.updates.beginEvent(true);
            this.cacheUpdates.beginEvent(true);
        }
        this.updates.forwardEvent(listEvent);
        this.cacheUpdates.forwardEvent(listEvent);
        if (!this.scheduled) {
            this.scheduled = true;
            this.schedule(this.updateRunner);
        }
    }

    protected abstract void schedule(Runnable var1);

    @Override
    public final int size() {
        return this.localCache.size();
    }

    @Override
    public final E get(int n2) {
        return this.localCache.get(n2);
    }

    @Override
    protected final boolean isWritable() {
        return true;
    }

    protected List<E> applyChangeToCache(EventList<E> eventList, ListEvent<E> listEvent, List<E> list) {
        ArrayList arrayList = new ArrayList(eventList.size());
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            if (listEvent.next()) {
                n5 = listEvent.getIndex();
                n4 = listEvent.getType();
            } else {
                n5 = eventList.size();
                n4 = -1;
            }
            while (n2 < n5) {
                arrayList.add(n2, list.get(n2 + n3));
                ++n2;
            }
            if (n4 == 0) {
                ++n3;
                continue;
            }
            if (n4 == 1) {
                arrayList.add(n2, eventList.get(n5));
                ++n2;
                continue;
            }
            if (n4 == 2) {
                arrayList.add(n2, eventList.get(n5));
                ++n2;
                --n3;
                continue;
            }
            if (n4 == -1) break;
        }
        return arrayList;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cacheUpdates.removeListEventListener(this.updateRunner);
    }

    private class UpdateRunner
    implements Runnable,
    ListEventListener<E> {
        private UpdateRunner() {
        }

        @Override
        public void run() {
            ThreadProxyEventList.this.getReadWriteLock().writeLock().lock();
            try {
                ThreadProxyEventList.this.cacheUpdates.commitEvent();
                ThreadProxyEventList.this.updates.commitEvent();
            }
            finally {
                ThreadProxyEventList.this.scheduled = false;
                ThreadProxyEventList.this.getReadWriteLock().writeLock().unlock();
            }
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            ThreadProxyEventList.this.localCache = ThreadProxyEventList.this.applyChangeToCache(ThreadProxyEventList.this.source, listEvent, ThreadProxyEventList.this.localCache);
        }
    }
}

